/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.handlers;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;

public class GadgetHandler
extends AbstractHandler {
    private static Logger logger = Logger.getLogger(GadgetHandler.class.getName());
    private static String COMMAND_ID_FORWARD = "com.hisagisoft.eclipse.gadgetholder.command.forward";
    private static String COMMAND_ID_BACKWARD = "com.hisagisoft.eclipse.gadgetholder.command.backward";
    private static String COMMAND_ID_REMOVE = "com.hisagisoft.eclipse.gadgetholder.command.remove";
    private static String COMMAND_ID_REFRESH = "com.hisagisoft.eclipse.gadgetholder.command.refresh";
    private static String COMMAND_ID_SAVE = "com.hisagisoft.eclipse.gadgetholder.command.save";
    private static String COMMAND_ID_ROLLBACK = "com.hisagisoft.eclipse.gadgetholder.command.rollback";
    private static String COMMAND_ID_COPY = "com.hisagisoft.eclipse.gadgetholder.command.copy";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        logger.fine("event = " + event);
        String commandId = event.getCommand().getId();
        IWorkbenchPart part = Activator.getDefault().getActivePart();
        if (part == null) {
            logger.warning("ActivePart not found");
            return null;
        }
        GadgetView view = null;
        if (!(part instanceof GadgetView)) {
            logger.fine("another ViewPart is active.");
            return null;
        }
        view = (GadgetView)part;
        if (COMMAND_ID_FORWARD.equals(commandId)) {
            logger.fine("Next Gadget");
            view.changeNextTab();
        } else if (COMMAND_ID_BACKWARD.equals(commandId)) {
            logger.fine("Previous Gadget");
            view.changePrevTab();
        } else if (COMMAND_ID_REMOVE.equals(commandId)) {
            logger.fine("Remove Gadget");
            view.removeGadget();
        } else if (COMMAND_ID_REFRESH.equals(commandId)) {
            logger.fine("Refresh Gadget");
            view.refreshActiveBrowser();
        } else if (COMMAND_ID_SAVE.equals(commandId)) {
            logger.fine("Save Gadget");
            view.saveGadget();
        } else if (COMMAND_ID_ROLLBACK.equals(commandId)) {
            logger.fine("Rollback Gadget");
            view.rollbackGadget();
        } else if (COMMAND_ID_COPY.equals(commandId)) {
            logger.fine("Copy Gadget");
            view.copyToClip();
        } else {
            logger.severe("invalid commandId = " + commandId);
        }
        return null;
    }
}

