/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class GadgetBrowser
extends ViewPart
implements Observer {
    public static final String ID = "com.hisagisoft.eclipse.gadgetholder.views.GadgetBrowser";
    private static Logger logger = Logger.getLogger(GadgetView.class.getName());
    private GadgetManager manager = GadgetManager.getInstance();
    private Browser browser;

    public GadgetBrowser() {
        this.manager.getGadgets().addObserver(this);
    }

    public void createPartControl(Composite parent) {
        logger.fine("createPartControl - start");
        File file = this.manager.createUnifiedHtmlFile();
        this.browser = new Browser(parent, 0);
        this.browser.setUrl(file.getAbsolutePath());
        logger.fine("createPartControl - end");
    }

    public void dispose() {
        super.dispose();
        logger.fine("delete observer");
        this.manager.getGadgets().deleteObserver(this);
    }

    public void setFocus() {
    }

    public void update(Observable o, Object arg) {
        logger.fine("observable = " + o.getClass());
        if (o instanceof GadgetList) {
            this.manager.createUnifiedHtmlFile();
            this.browser.refresh();
        }
    }
}

