/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class GadgetDropListener
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(GadgetDropListener.class.getName());
    private GadgetView view;
    private GadgetManager manager;

    public GadgetDropListener(GadgetView view) {
        this.view = view;
        this.manager = GadgetManager.getInstance();
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = 1;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        try {
            String source = event.data.toString();
            logger.fine("drop source = " + source);
            Gadget newGadget = this.manager.getGadgets().createGadget();
            newGadget.setSource(source);
            File file = this.manager.createHtmlFile(newGadget);
            newGadget.setFile(file);
            this.view.addBrowser(newGadget);
            this.view.setEnabledActions();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

