/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.GadgetHolderManager;
import com.hisagisoft.eclipse.gadgetholder.StructTitle;
import com.hisagisoft.eclipse.gadgetholder.dialogs.NewGadgetDialog;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.part.ViewPart;

public class GadgetView
extends ViewPart {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private CTabFolder folder;
    private GadgetHolderManager manager;
    private GadgetList gadgets;
    private Action newAction;
    private Action removeAction;
    private Action saveAction;
    private Action rollbackAction;
    private Action importAction;
    private Action exportAction;
    private StructTitle title;

    public void createPartControl(Composite parent) {
        this.title = new StructTitle();
        this.title.put(StructTitle.Key.TITLE, this.getPartName());
        this.title.put(StructTitle.Key.UNSAVED, "");
        this.logger.fine("title = " + this.title);
        this.setPartName(this.title.toString());
        this.folder = new CTabFolder(parent, 0);
        this.manager = GadgetHolderManager.getInstance();
        this.gadgets = this.manager.getGadgets();
        for (Gadget gadget : this.gadgets) {
            this.addBrowser(gadget);
        }
        this.makeActions();
        this.setEnabledActions();
    }

    private void addBrowser(Gadget gadget) {
        assert (gadget != null && this.folder != null);
        CTabItem item = new CTabItem(this.folder, 0);
        item.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE").createImage());
        if (gadget.isNew()) {
            item.setText("unsaved");
        }
        if (gadget.isRemoved()) {
            item.setText("removed");
        }
        this.folder.setSelection(item);
        BrowserViewer browser = new BrowserViewer((Composite)this.folder, 0);
        item.setControl((Control)browser);
        item.setData(Gadget.class.getName(), (Object)gadget);
        browser.setURL(gadget.getFile().getAbsolutePath());
    }

    private void makeActions() {
        IToolBarManager bars = this.getViewSite().getActionBars().getToolBarManager();
        this.newAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("NEW Action");
                    NewGadgetDialog ngd = new NewGadgetDialog(GadgetView.this.folder.getShell());
                    if (ngd.open() == 0) {
                        GadgetView.this.addBrowser(ngd.getNewGadget());
                        GadgetView.this.setEnabledActions();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.newAction.setToolTipText("Add New Gadget");
        this.newAction.setImageDescriptor(Activator.getImageDescriptor("icons/new.gif"));
        bars.add((IAction)this.newAction);
        this.removeAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("REMOVE Action");
                    boolean ok = MessageDialog.openConfirm((Shell)GadgetView.this.folder.getShell(), (String)"Confirm", (String)"Are you sure you want to remove this gadget?");
                    if (!ok) {
                        GadgetView.this.logger.fine("CANCEL");
                        return;
                    }
                    GadgetView.this.logger.fine("OK");
                    CTabItem item = GadgetView.this.folder.getSelection();
                    Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
                    GadgetView.this.logger.info("remove gadget.id = " + gadget.getId());
                    gadget.setRemoved(true);
                    item.setText("removed");
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.removeAction.setToolTipText("Remove Gadget");
        this.removeAction.setImageDescriptor(Activator.getImageDescriptor("icons/remove.gif"));
        bars.add((IAction)this.removeAction);
        this.saveAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("SAVE Action");
                    GadgetView.this.gadgets.commit();
                    GadgetView.this.manager.saveProperties();
                    GadgetView.this.updateView();
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.saveAction.setToolTipText("Save changes");
        this.saveAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_SAVE_EDIT"));
        bars.add((IAction)this.saveAction);
        this.rollbackAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("ROLLBACK Action");
                    boolean ok = MessageDialog.openConfirm((Shell)GadgetView.this.folder.getShell(), (String)"Confirm", (String)"Are you sure you want to rollback changes?");
                    if (!ok) {
                        GadgetView.this.logger.fine("CANCEL");
                        return;
                    }
                    GadgetView.this.logger.fine("OK");
                    GadgetView.this.gadgets.rollback();
                    GadgetView.this.updateView();
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.rollbackAction.setToolTipText("rollback changes");
        this.rollbackAction.setImageDescriptor(Activator.getImageDescriptor("icons/rollback.gif"));
        bars.add((IAction)this.rollbackAction);
        this.importAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("IMPORT Action");
                    FileDialog fd = new FileDialog(GadgetView.this.folder.getShell());
                    fd.setFilterExtensions(new String[]{"*.html"});
                    fd.setFilterPath(String.valueOf(System.getProperty("user.home")) + File.separator + "My Documents");
                    String filePath = fd.open();
                    if (filePath == null) {
                        return;
                    }
                    GadgetList newGadgets = GadgetView.this.manager.importGadget(new File(filePath));
                    for (Gadget g : newGadgets) {
                        GadgetView.this.addBrowser(g);
                    }
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.importAction.setToolTipText("Import gadget");
        this.importAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_IMPORT_WIZ"));
        bars.add((IAction)this.importAction);
        this.exportAction = new Action(){

            public void run() {
                try {
                    boolean ok;
                    GadgetView.this.logger.fine("EXPORT Action");
                    FileDialog fd = new FileDialog(GadgetView.this.folder.getShell());
                    fd.setFileName("export.html");
                    fd.setFilterExtensions(new String[]{"*.html"});
                    fd.setFilterPath(String.valueOf(System.getProperty("user.home")) + File.separator + "My Documents");
                    String filePath = fd.open();
                    if (filePath == null) {
                        return;
                    }
                    File file = new File(filePath);
                    if (file.exists() && !(ok = MessageDialog.openConfirm((Shell)GadgetView.this.folder.getShell(), (String)"Confirm", (String)"File already exists. Overwrite?"))) {
                        GadgetView.this.logger.fine("CANCEL");
                        return;
                    }
                    GadgetView.this.manager.exportGadget(file);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.exportAction.setToolTipText("Export gadget");
        this.exportAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_EXPORT_WIZ"));
        bars.add((IAction)this.exportAction);
    }

    private void setEnabledActions() {
        assert (this.newAction != null && this.removeAction != null && this.saveAction != null && this.rollbackAction != null && this.importAction != null && this.exportAction != null);
        this.newAction.setEnabled(true);
        if (this.gadgets.size() > 0) {
            this.removeAction.setEnabled(true);
            this.exportAction.setEnabled(true);
        } else {
            this.removeAction.setEnabled(false);
            this.exportAction.setEnabled(false);
        }
        if (this.gadgets.isModified()) {
            this.saveAction.setEnabled(true);
            this.rollbackAction.setEnabled(true);
            this.title.put(StructTitle.Key.UNSAVED, "*");
        } else {
            this.saveAction.setEnabled(false);
            this.rollbackAction.setEnabled(false);
            this.title.put(StructTitle.Key.UNSAVED, "");
        }
        this.setPartName(this.title.toString());
        this.importAction.setEnabled(true);
    }

    private void updateView() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget.isRemoved()) {
                item.dispose();
            } else if (gadget.isNew()) {
                item.dispose();
            } else {
                item.setText("");
            }
            ++n2;
        }
    }

    public void setFocus() {
    }
}

