/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.dialogs;

import com.hisagisoft.eclipse.gadgetholder.GadgetHolderManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class NewGadgetDialog {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private InputDialog dialog;
    private GadgetHolderManager manager;
    private GadgetList gadgets;
    private Gadget newGadget;
    private IInputValidator validator = new IInputValidator(){

        public String isValid(String newText) {
            if (newText == null || newText.length() == 0) {
                return "";
            }
            return null;
        }
    };

    public NewGadgetDialog(Shell parentShell) {
        this.dialog = new InputDialog(parentShell, "New Gadget", "Please enter the gadget script. \nex <script>...</scirpt>", null, this.validator);
        this.manager = GadgetHolderManager.getInstance();
        this.gadgets = this.manager.getGadgets();
    }

    public int open() {
        int result = this.dialog.open();
        if (result == 0) {
            this.logger.fine("OK");
            this.newGadget = this.gadgets.createGadget();
            String source = this.dialog.getValue();
            this.newGadget.setSource(source);
            File file = this.manager.createHtmlFile(this.newGadget);
            this.newGadget.setFile(file);
        } else {
            this.logger.fine("CANCEL");
        }
        return result;
    }

    public Gadget getNewGadget() {
        assert (this.newGadget != null);
        return this.newGadget;
    }
}

