/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    private static Logger logger = Logger.getLogger(ParserUtils.class.getName());

    private ParserUtils() {
    }

    public static List<String> getScriptTags(File file) {
        assert (file != null);
        final ArrayList<String> list = new ArrayList<String>();
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(file, new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (qName.equals("script")) {
                        StringBuilder sb = new StringBuilder("<script src=\"");
                        int i = 0;
                        while (i < attributes.getLength()) {
                            if ("src".equals(attributes.getQName(i))) {
                                String value = attributes.getValue(i);
                                sb.append(value);
                                sb.append("\"></script>");
                                logger.fine("script tag = " + sb.toString());
                                list.add(sb.toString());
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            logger.fine(String.valueOf(e.getClass().getName()) + " : " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        return list;
    }
}

