#! /bin/sh

# how to release
# tar zcvf vminstall-${release}.x86-linux.tar.gz vminstall-${release}.x86-linux

_do()
{
    local cmd="$*"
    echo $cmd
    eval $cmd
    local retval=$?
    return $retval
}


progname=`basename $0`
curdir=`dirname $progname`

prefix=http://geant4.kek.jp/~iwai/G4VM
release=20080229
install_dir=G4VM-${release}

if test -d $install_dir; then
    echo "$progname: already exist ${install_dir}, try again after removing."
    exit 1
fi

cmds="mkdir wget bunzip2"
for cmd in $cmds; do
    which $cmd > /dev/null 2>&1
    retval=$?
    if test $retval -ne 0; then
	echo "$progname: not found $cmd"
	exit 1
    fi
done


_do mkdir -p $install_dir && _do cd $install_dir && _do wget $prefix/$release/G4VM.vmx && _do wget $prefix/$release/G4VM.vmdk.bz2 && _do bunzip2 -vv G4VM.vmdk.bz2

exit 0
