#include "stdafx.h"

#include "FileInfoDiffAdaptorImpl.hpp"

/////////////////////////////////

/// INamedFileInfoComparator

HRESULT __stdcall CFileInfoDiffAdaptor::IsEquals(LPCWSTR v_pName, IFileInfo* v_pFileInfo1, IFileInfo* v_pFileInfo2) throw()
{
	if ( !v_pName) {
		return E_POINTER;
	}

	HRESULT result = pFileInfoComparator_->IsEquals(v_pFileInfo1, v_pFileInfo2);
	if (result == S_OK || FAILED(result)) {
		return result;
	}

	if (pFileInfoCollection1_) {
		if (v_pFileInfo2) {
			pFileInfoCollection1_->set_Item(v_pName, v_pFileInfo2);
		}
		else {
			pFileInfoCollection1_->remove_Item(v_pName);
		}
	}
	
	if (pFileInfoCollection2_) {
		if (v_pFileInfo1) {
			pFileInfoCollection2_->set_Item(v_pName, v_pFileInfo1);
		}
		else {
			pFileInfoCollection2_->remove_Item(v_pName);
		}
	}

	return S_FALSE;
}

/// PRIVATE 

HRESULT CFileInfoDiffAdaptor::Init(IFileInfoComparator* v_pFileInfoComparator,
	IFileInfoCollection* v_pFileInfoCollection1,
	IFileInfoCollection* v_pFileInfoCollection2) throw()
{
	if ( !v_pFileInfoComparator) {
		return E_POINTER;
	}

	pFileInfoComparator_ = v_pFileInfoComparator;
	pFileInfoCollection1_ = v_pFileInfoCollection1;
	pFileInfoCollection2_ = v_pFileInfoCollection2;

	return S_OK;
}

/////////////////////////////////

extern "C" HRESULT __stdcall CreateFileInfoDiffAdaptorObject(IFileInfoComparator* v_pComparator, IFileInfoCollection* v_pCollection1, IFileInfoCollection* v_pCollection2, INamedFileInfoComparator** v_ppFileInfoComparator) throw()
{
	if ( !v_ppFileInfoComparator) {
		return E_POINTER;
	}

	ATLASSERT( !*v_ppFileInfoComparator);
	*v_ppFileInfoComparator = NULL;

	HRESULT hr;

	CComObject<CFileInfoDiffAdaptor>* pAdaptorImpl;
	hr = CComObject<CFileInfoDiffAdaptor>::CreateInstance(&pAdaptorImpl);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pAdaptorImpl);
	CComPtr<INamedFileInfoComparator> pAdaptor(pAdaptorImpl);

	hr = pAdaptorImpl->Init(v_pComparator, v_pCollection1, v_pCollection2);
	if (FAILED(hr)) {
		return hr;
	}

	return pAdaptor->QueryInterface(v_ppFileInfoComparator);
}
