#include "stdafx.h"

#include "FWatchCore2Test.hpp"

#include "../include/FWatchCore2Obj.hpp"

void TestFileInfoCollectionObjectPersistence(void) throw()
{
	HRESULT hr;
	CComPtr<IFileInfoCollection> pCollection;
	hr = CreateFileInfoCollectionObject(&pCollection);
	TEST(SUCCEEDED(hr));
	
	CComPtr<IPersist> pPersist;
	hr = pCollection->QueryInterface(&pPersist);
	TEST(SUCCEEDED(hr));

	CLSID clsid = {0};
	hr = pPersist->GetClassID(&clsid);
	TEST(SUCCEEDED(hr));

	CComPtr<IPersistStream> pPersistStream;
	hr = pCollection->QueryInterface(&pPersistStream);
	TEST(SUCCEEDED(hr));

	hr = pPersistStream->IsDirty();
	TEST(SUCCEEDED(hr));

	CComPtr<IPersistStreamInit> pPersistStreamInit;
	hr = pCollection->QueryInterface(&pPersistStreamInit);
	TEST(SUCCEEDED(hr));

	hr = pPersistStreamInit->IsDirty();
	TEST(SUCCEEDED(hr));

	ULARGE_INTEGER siz = {0};
	hr = pPersistStreamInit->GetSizeMax(&siz);
	TEST(SUCCEEDED(hr));
}
