#include "stdafx.h"

#include "../include/FWatchCore2Obj.hpp"

#include "FileInfoImpl.hpp"

////////////////////////////////////////////////////

/// PRIVATE

HRESULT CFileInfo::Init(const FILE_INFO* v_pFileInfo) throw()
{
	if ( !v_pFileInfo) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	fileInfo_ = *v_pFileInfo;

	return S_OK;
}

HRESULT CFileInfo::Init(const WIN32_FIND_DATA* v_pFindData) throw()
{
	if ( !v_pFindData) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	fileInfo_.attributes_        = v_pFindData->dwFileAttributes;
	fileInfo_.fileSize_.HighPart = v_pFindData->nFileSizeHigh;
	fileInfo_.fileSize_.LowPart  = v_pFindData->nFileSizeLow;
	fileInfo_.lastModified_      = v_pFindData->ftLastWriteTime;

	return S_OK;
}

/// IFileInfo

HRESULT __stdcall CFileInfo::get_LastModified(FILETIME* v_pFileTime) throw()
{
	if ( !v_pFileTime) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	*v_pFileTime = fileInfo_.lastModified_;

	return S_OK;
}

HRESULT __stdcall CFileInfo::get_FileSize(ULARGE_INTEGER* v_pFileSize) throw()
{
	if ( !v_pFileSize) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	*v_pFileSize = fileInfo_.fileSize_;

	return S_OK;
}

HRESULT __stdcall CFileInfo::get_Attributes(DWORD* v_pAttributes) throw()
{
	if ( !v_pAttributes) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	*v_pAttributes = fileInfo_.attributes_;

	return S_OK;
}

OBJECT_ENTRY_AUTO(__uuidof(CFileInfo), CFileInfo)

////////////////////////////////////////////////////

extern "C" CreateFileInfoObject(LPCWSTR v_pPath, IFileInfo** v_ppFileInfo) throw()
{
	if ( !v_pPath || !v_ppFileInfo) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	*v_ppFileInfo = NULL;

	HRESULT hr;

	CAtlFile file;
	hr = file.Create(
		v_pPath,
		GENERIC_READ,
		FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE,
		OPEN_EXISTING,
		FILE_FLAG_BACKUP_SEMANTICS
		);
	if (FAILED(hr)) {
		return hr;
	}

	BY_HANDLE_FILE_INFORMATION filePrimitiveInfo;
	if ( !GetFileInformationByHandle(file, &filePrimitiveInfo)) {
		return AtlHresultFromLastError();
	}

	file.Close();


	FILE_INFO fileInfo;

	fileInfo.fileSize_.LowPart = filePrimitiveInfo.nFileSizeLow;
	fileInfo.fileSize_.HighPart = filePrimitiveInfo.nFileSizeHigh;
	fileInfo.lastModified_ = filePrimitiveInfo.ftLastWriteTime;
	fileInfo.attributes_ = filePrimitiveInfo.dwFileAttributes;

	CComObject<CFileInfo>* pFileInfoImpl = NULL;
	hr = CComObject<CFileInfo>::CreateInstance(&pFileInfoImpl);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pFileInfoImpl);
	CComPtr<IFileInfo> pFileInfo(pFileInfoImpl);

	hr = pFileInfoImpl->Init(&fileInfo);
	if (FAILED(hr)) {
		return hr;
	}

	ATLASSERT(pFileInfo);
	return pFileInfo.QueryInterface(v_ppFileInfo);
}


////////////////////////////////////////////////////

extern "C" HRESULT __stdcall ConvertW32FindDataToFileInfo(const WIN32_FIND_DATA* v_pFindData, IFileInfo** v_ppFileInfo) throw()
{
	if ( !v_pFindData || !v_ppFileInfo) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppFileInfo);
	*v_ppFileInfo = NULL;

	HRESULT hr;
	CComObject<CFileInfo>* pFileInfoImpl = NULL;
	hr = CComObject<CFileInfo>::CreateInstance(&pFileInfoImpl);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pFileInfoImpl);
	CComPtr<IFileInfo> pFileInfo(pFileInfoImpl);

	hr = pFileInfoImpl->Init(v_pFindData);
	if (FAILED(hr)) {
		return hr;
	}

	ATLASSERT(pFileInfo);
	return pFileInfo.QueryInterface(v_ppFileInfo);
}

////////////////////////////////////////////////////

HRESULT CW32FindDataToFileInfoAdaptor::Init(IFileInfoReceiver* v_pFileInfoReceiver) throw()
{
	if ( !v_pFileInfoReceiver) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	pFileInfoReceiver_ = v_pFileInfoReceiver;

	return S_OK;
}

/**
 * W32_FIND_DATA󂯎܂B
 * @param v_pPath pX
 * @param v_pFindData t@C񂪊i[Ă|C^
 * @return ܂͎s\HRESULT
 */
HRESULT __stdcall CW32FindDataToFileInfoAdaptor::ReceiveW32FindData(LPCWSTR v_pPath, const WIN32_FIND_DATA* v_pFindData) throw()
{
	if ( !v_pPath || !v_pFindData) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(pFileInfoReceiver_);

	CComPtr<IFileInfo> pFileInfo;
	HRESULT hr = ConvertW32FindDataToFileInfo(v_pFindData, &pFileInfo);
	if (FAILED(hr)) {
		return hr;
	}

	return pFileInfoReceiver_->ReceiveFileInfo(v_pPath, pFileInfo);
}


OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CW32FindDataToFileInfoAdaptor), CW32FindDataToFileInfoAdaptor)

////////////////////////////////////////////////////

/**
 * IFileInfoReceiverIW32FindDataReceiverɕϊA_v^\z܂B
 * ̃\bh\zIW32FindDataReceiverĂяoƁAFILE_INFOɕϊāAIFileInfoReceiverĂяo܂B
 * @param v_pFileInfoReceiver FILE_INFO󂯎C^[tFCX
 * @param v_ppW32FindDataReceiver W32_FIND_DATA󂯎C^[tFCX
 */
extern "C" HRESULT __stdcall CreateW32FindDataToFileInfoAdaptor(IFileInfoReceiver* v_pFileInfoReceiver, IW32FindDataReceiver** v_ppW32FindDataReceiver) throw()
{
	if ( !v_pFileInfoReceiver || !v_ppW32FindDataReceiver) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppW32FindDataReceiver);
	*v_ppW32FindDataReceiver = NULL;

	HRESULT hr;
	CComObject<CW32FindDataToFileInfoAdaptor>* pAdaptorImpl = NULL;
	hr = CComObject<CW32FindDataToFileInfoAdaptor>::CreateInstance(&pAdaptorImpl);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pAdaptorImpl);
	CComPtr<IW32FindDataReceiver> pAdaptor(pAdaptorImpl);

	hr = pAdaptorImpl->Init(v_pFileInfoReceiver);
	if (FAILED(hr)) {
		return hr;
	}

	return pAdaptor.QueryInterface(v_ppW32FindDataReceiver);
}

