#include "stdafx.h"

#include "../include/FWatchCore2Obj.hpp"

#include "EnumDirImpl.hpp"

///////////////////////////////////////////////

HRESULT CEnumDir::FinalConstruct() throw()
{
	return CreateFindFileFactoryObject(&pFindFileFactory_);
}

HRESULT __stdcall CEnumDir::HandleError(HRESULT v_errorCode) throw()
{
	return v_errorCode;
}

HRESULT __stdcall CEnumDir::BeginEnumeration(LPCWSTR v_pDirName, IEnumDirHandler* v_pCallback) throw()
{
	if ( !v_pCallback || !v_pDirName || lstrlen(v_pDirName) == 0) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	CComPtr<IErrorHandler> pErrorHandler;
	if (FAILED(v_pCallback->QueryInterface(&pErrorHandler))) {
		pErrorHandler = this;
	}

	HRESULT hr = v_pCallback->OnInit();
	if (FAILED(hr)) {
		return hr;
	}

	hr = BeginEnumeration0(v_pDirName, v_pCallback, pErrorHandler);

	return v_pCallback->OnExit(hr);
}

HRESULT __stdcall CEnumDir::BeginEnumeration0(LPCWSTR v_pDirName, IEnumDirHandler* v_pCallback, IErrorHandler* v_pErrorHandler) throw()
{
	ATLASSERT(pFindFileFactory_ && v_pCallback && v_pErrorHandler && v_pDirName && lstrlen(v_pDirName) != 0);

	HRESULT hr;

	CComBSTR dirName;
	hr = GetAbsolutePathName(v_pDirName, NULL, &dirName);
	if (FAILED(hr)) {
		return hr;
	}
	
	CComBSTR searchPath(dirName);
	hr = GetAbsolutePathName(dirName, L"*.*", &searchPath);
	if (FAILED(hr)) {
		return hr;
	}

	CComPtr<IFindFile> pFindFile;
	hr = pFindFileFactory_->Create(searchPath, &pFindFile);
	if (FAILED(hr)) {
		return v_pErrorHandler->HandleError(hr);
	}

	hr = v_pCallback->BeginDirectory(dirName);
	if (FAILED(hr)) {
		return hr;
	}

	for(;;) {
		hr = pFindFile->HasNext();
		if (hr == S_FALSE) {
			hr = S_OK; // 񋓏IłS_OKƂĕԂB
			break;
		}
		
		if (FAILED(hr)) {
			hr = v_pErrorHandler->HandleError(hr);
			if (FAILED(hr)) {
				break;
			}
			continue;
		}

		WIN32_FIND_DATA findData;
		hr = pFindFile->Next(&findData);
		if (FAILED(hr)) {
			break;
		}

		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			if (lstrcmp(findData.cFileName, L".") == 0 ||
				lstrcmp(findData.cFileName, L"..") == 0) {
				continue;
			}
		}
		
		CComBSTR path;
		hr = GetAbsolutePathName(dirName, findData.cFileName, &path);
		if (FAILED(hr)) {
			break;
		}

		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			hr = v_pCallback->OnFindDirectory(path, &findData);
			if (hr == S_OK) {
				hr = BeginEnumeration0(path, v_pCallback, v_pErrorHandler);
			}
		}
		else {
			hr = v_pCallback->OnFindFile(path, &findData);
		}

		if (FAILED(hr)) {
			break;
		}
	}

	return v_pCallback->EndDirectory(dirName, hr);
}

OBJECT_ENTRY_AUTO(__uuidof(CEnumDir), CEnumDir)


///////////////////////////////////////////////

HRESULT CEnumDirFilterFactory::FinalConstruct() throw()
{
	maxLevel_ = 0;
	return S_OK;
}

HRESULT __stdcall CEnumDirFilterFactory::set_MaxLevel(UINT v_maxLevel) throw()
{
	maxLevel_ = v_maxLevel;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilterFactory::get_MaxLevel(UINT* v_pMaxLevel) throw()
{
	if ( !v_pMaxLevel) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	*v_pMaxLevel = maxLevel_;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilterFactory::set_NameFilter(INameMatcher* v_pNameMatcher) throw()
{
	pNameMatcher_ = v_pNameMatcher;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilterFactory::get_NameFilter(INameMatcher** v_ppNameMatcher) throw()
{
	if ( !v_ppNameMatcher) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}
	
	*v_ppNameMatcher = pNameMatcher_;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilterFactory::CreateFilter(IW32FindDataReceiver* v_pW32FindDataReceiver, IEnumDirHandler** v_ppCallback) throw ()
{
	if ( !v_pW32FindDataReceiver || !v_ppCallback) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppCallback);
	*v_ppCallback = NULL;

	HRESULT hr;
	CComObject<CEnumDirFilter>* pEnumDirFilterImpl = NULL;
	hr = CComObject<CEnumDirFilter>::CreateInstance(&pEnumDirFilterImpl);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pEnumDirFilterImpl);
	CComPtr<IEnumDirHandler> pEnumDirFilter(pEnumDirFilterImpl);

	hr = pEnumDirFilterImpl->Init(pNameMatcher_, maxLevel_, v_pW32FindDataReceiver);
	if (FAILED(hr)) {
		return hr;
	}

	ATLASSERT(pEnumDirFilter);
	return pEnumDirFilter.QueryInterface(v_ppCallback);
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CEnumDirFilterFactory), CEnumDirFilterFactory)


///////////////////////////////////////////////

HRESULT CEnumDirFilter::FinalConstruct() throw()
{
	maxLevel_ = 0;
	level_ = 0;

	return S_OK;
}

HRESULT CEnumDirFilter::Init(INameMatcher* v_pNameMatcher, UINT v_maxLevel, IW32FindDataReceiver* v_pFindDataReceiver) throw()
{
	if ( !v_pFindDataReceiver) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	maxLevel_ = v_maxLevel;
	pNameMatcher_ = v_pNameMatcher;
	pFindDataReceiver_ = v_pFindDataReceiver;

	return S_OK;
}

/// IEnumDirHandler

HRESULT __stdcall CEnumDirFilter::OnInit() throw()
{
	level_ = 0;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilter::OnExit(HRESULT v_exitCode) throw()
{
	return v_exitCode;
}

HRESULT __stdcall CEnumDirFilter::BeginDirectory(LPCWSTR v_pFullPath) throw()
{
	level_ += 1;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilter::EndDirectory(LPCWSTR v_pFullPath, HRESULT v_exitCode) throw()
{
	level_ -= 1;

	return S_OK;
}

HRESULT __stdcall CEnumDirFilter::OnFindFile(LPCWSTR v_pFullPath, const WIN32_FIND_DATA* v_pFindData) throw()
{
	if ( !v_pFullPath || !v_pFindData) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	HRESULT result = S_OK;

	if (pNameMatcher_) {
		result = pNameMatcher_->IsMatch(v_pFullPath);
	}

	if (result == S_OK) {
		result = NotifyW32FindData(v_pFullPath, v_pFindData);
	}

	return result;
}

HRESULT __stdcall CEnumDirFilter::OnFindDirectory(LPCWSTR v_pFullPath, const WIN32_FIND_DATA* v_pFindData) throw()
{
	if ( !v_pFullPath || !v_pFindData) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	if (level_ <= maxLevel_) {
		return S_OK;
	}

	return S_FALSE;
}

HRESULT __stdcall CEnumDirFilter::HandleError(HRESULT v_errorCode) throw()
{
	if (v_errorCode == E_ACCESSDENIED) {
		return S_OK;
	}

	return v_errorCode;
}

/// PRIVATE

HRESULT CEnumDirFilter::NotifyW32FindData(LPCWSTR v_pPath, const WIN32_FIND_DATA* v_pFindData) throw()
{
	ATLASSERT(v_pPath && v_pFindData);
	ATLASSERT(pFindDataReceiver_);

	return pFindDataReceiver_->ReceiveW32FindData(v_pPath, v_pFindData);
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CEnumDirFilter), CEnumDirFilter)


///////////////////////////////////////////////

extern "C" HRESULT __stdcall CreateEnumDirFilterFactoryObject(IEnumDirFilterFactory** v_ppFilterFactory) throw()
{
	if ( !v_ppFilterFactory) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	return CEnumDirFilterFactory::CreateInstance(v_ppFilterFactory);
}

extern "C" HRESULT __stdcall CreateEnumDirObject(IEnumDir** v_ppEnumDir) throw()
{
	if ( !v_ppEnumDir) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppEnumDir);
	*v_ppEnumDir = NULL;

	HRESULT hr;
	CComObject<CEnumDir>* pEnumDir = NULL;

	hr = CComObject<CEnumDir>::CreateInstance(&pEnumDir);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pEnumDir);
	pEnumDir->AddRef();

	*v_ppEnumDir = pEnumDir;

	return S_OK;
}
