// FWatchCore2.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include "..\FWatchCore2Lib\FWatchCore2Obj.hpp"

class FWatchCore2App : public CAtlExeModuleT<FWatchCore2App>
{
public:

	HRESULT PreMessageLoop(int v_nShowCmd) throw()
	{
		return S_OK;
	}

	HRESULT Run(int v_nShowCmd) throw()
	{
		return __super::Run(v_nShowCmd);
	}

	void RunMessageLoop(void) throw()
	{
		Test1();
		Test2();
		Test3();
		Test4();
		Test5();
	}

	void Test1(void) throw()
	{
		HRESULT hr;

		CComPtr<INameMatcherFactory> pNameMatcherFactory;
		hr = CreateNameMatcherFactoryObject(&pNameMatcherFactory);
		TEST(SUCCEEDED(hr));

		CComPtr<INameMatcher> pNameMatcher;

		hr = pNameMatcherFactory->Create(L"*.txt", &pNameMatcher);
		TEST(SUCCEEDED(hr));

		TEST(pNameMatcher->IsMatch(L".txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"1.txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"123.txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"123.txt.txt") == S_OK);

		TEST(pNameMatcher->IsMatch(L".txt.exe") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"1.txt.exe") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"123.txt.txtx") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"123.txt.txt.") == S_FALSE);

		pNameMatcher.Release();

		hr = pNameMatcherFactory->Create(L"abc*.txt", &pNameMatcher);
		TEST(SUCCEEDED(hr));

		TEST(pNameMatcher->IsMatch(L"abc.txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"abc1.txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"abc123.txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"abcabc123.txt.txt") == S_OK);

		TEST(pNameMatcher->IsMatch(L"abc.txt.exe") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abc1.txt.exe.txt.exe") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abc123.txt.txtx") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abcabc123.txt.txt.") == S_FALSE);

		pNameMatcher.Release();

		hr = pNameMatcherFactory->Create(L"*a*b*c*", &pNameMatcher);
		TEST(SUCCEEDED(hr));

		TEST(pNameMatcher->IsMatch(L"aBc") == S_OK);
		TEST(pNameMatcher->IsMatch(L"aaAbbbcccddd") == S_OK);
		TEST(pNameMatcher->IsMatch(L"abcabc") == S_OK);
		TEST(pNameMatcher->IsMatch(L"1111a222B333c444") == S_OK);
		TEST(pNameMatcher->IsMatch(L"abdc") == S_OK);
		TEST(pNameMatcher->IsMatch(L"Xaabdcb") == S_OK);

		TEST(pNameMatcher->IsMatch(L"Def") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"aaaabd") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"ccccbbbbaaaa") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abd") == S_FALSE);

		pNameMatcher.Release();

		hr = pNameMatcherFactory->Create(L"????.txt?", &pNameMatcher);
		TEST(SUCCEEDED(hr));

		TEST(pNameMatcher->IsMatch(L"AbcD.txt2") == S_OK);
		TEST(pNameMatcher->IsMatch(L"A.tXt") == S_OK);
		TEST(pNameMatcher->IsMatch(L".tXt2") == S_OK);
		TEST(pNameMatcher->IsMatch(L".txt") == S_OK);
		TEST(pNameMatcher->IsMatch(L"abd.txt") == S_OK);

		TEST(pNameMatcher->IsMatch(L"def") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abcde.txt2") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abcde.txt") == S_FALSE);
		TEST(pNameMatcher->IsMatch(L"abcd.tx2x") == S_FALSE);

		pNameMatcher.Release();
	}

	void Test2(void) throw()
	{
		HRESULT hr;
		IFindFileFactory* pFindFileFactory = NULL;
		hr = CreateFindFileFactoryObject(&pFindFileFactory);
		TEST(SUCCEEDED(hr));
		IFindFile* pFindFile = NULL;
		hr = pFindFileFactory->Create(L"c:\\temp\\ba.txt", &pFindFile);
		TEST(SUCCEEDED(hr));

		if (SUCCEEDED(hr)) {
			while (pFindFile->HasNext() == S_OK) {
				WIN32_FIND_DATA findData;
				hr = pFindFile->Next(&findData);
				if (FAILED(hr)) {
					TEST(false);
					break;
				}
			}
			pFindFile->Release();
		}

		pFindFileFactory->Release();
	}
	
	void Test3(void) throw()
	{
		HRESULT hr;
		CComPtr<IFileInfoComparatorFactory> pFileInfoComparatorFactory;
		hr = CreateFileInfoComparatorFactoryObject(&pFileInfoComparatorFactory);
		TEST(SUCCEEDED(hr));

		pFileInfoComparatorFactory->set_AttributesMask(1);
		pFileInfoComparatorFactory->set_FileTimeTolerance(1);

		CComPtr<IFileInfoComparator> pFileInfoComparator;
		hr = pFileInfoComparatorFactory->Create(&pFileInfoComparator);
		TEST(SUCCEEDED(hr));

		WIN32_FIND_DATA f1, f2;

		f1.dwFileAttributes = 0;
		f1.nFileSizeHigh = 0;
		f1.nFileSizeLow = 0;
		f1.ftLastWriteTime.dwHighDateTime = 0;
		f1.ftLastWriteTime.dwLowDateTime = 0;

		f2 = f1;

		f1.dwFileAttributes = 1;

		CComPtr<IFileInfo> pFileTime1, pFileTime2;

		hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
		TEST(SUCCEEDED(hr));
		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_FALSE);

		pFileTime2.Release();

		f2.dwFileAttributes = 3;

		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_OK);

		pFileTime2.Release();

		f2.nFileSizeLow = 1;

		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_FALSE);

		pFileTime2.Release();

		f2.nFileSizeLow = 0;
		f2.ftLastWriteTime.dwLowDateTime = 1;

		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_OK);

		pFileTime1.Release();
		pFileTime2.Release();

		f2.nFileSizeLow = 0;
		f1.ftLastWriteTime.dwLowDateTime = 1;
		f2.ftLastWriteTime.dwLowDateTime = 3;

		hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
		TEST(SUCCEEDED(hr));
		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_FALSE);

		pFileTime1.Release();
		pFileTime2.Release();

		f2.nFileSizeLow = 0;
		f1.ftLastWriteTime.dwLowDateTime = 3;
		f2.ftLastWriteTime.dwLowDateTime = 1;

		hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
		TEST(SUCCEEDED(hr));
		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_FALSE);

		pFileTime1.Release();
		pFileTime2.Release();

		f2.nFileSizeLow = 0;
		f1.ftLastWriteTime.dwLowDateTime = 3;
		f2.ftLastWriteTime.dwLowDateTime = 2;

		hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
		TEST(SUCCEEDED(hr));
		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_OK);

		pFileTime1.Release();
		pFileTime2.Release();

		f2.nFileSizeLow = 0;
		f1.ftLastWriteTime.dwLowDateTime = 2;
		f2.ftLastWriteTime.dwLowDateTime = 2;

		hr = ConvertW32FindDataToFileInfo(&f1, &pFileTime1);
		TEST(SUCCEEDED(hr));
		hr = ConvertW32FindDataToFileInfo(&f2, &pFileTime2);
		TEST(SUCCEEDED(hr));

		hr = pFileInfoComparator->IsEquals(pFileTime1, pFileTime2);
		TEST(hr == S_OK);

		pFileTime1.Release();
		pFileTime2.Release();
	}

	void Test4(void) throw()
	{
		HRESULT hr;

		CComPtr<INameMatcherFactory> pNameMatcherFactory;
		hr = CreateNameMatcherFactoryObject(&pNameMatcherFactory);
		TEST(SUCCEEDED(hr));
		
		CComPtr<INameMatcher> pNameMatcher;
		hr = pNameMatcherFactory->CreateAcceptDeny(L"*.txt;*.doc", L"*readme.txt", &pNameMatcher);
		TEST(SUCCEEDED(hr));

		// 

		CComPtr<IFileInfoCollection> pFileInfoMap;
		hr = CreateFileInfoCollectionObject(&pFileInfoMap);
		TEST(SUCCEEDED(hr));

		//

		CComPtr<IFileInfoReceiver> pFileInfoReceiver;
		hr = pFileInfoMap->QueryInterface(&pFileInfoReceiver);
		TEST(SUCCEEDED(hr));

		//

		CComPtr<IW32FindDataReceiver> pW32FindDataReceiver;
		hr = CreateW32FindDataToFileInfoAdaptor(pFileInfoReceiver, &pW32FindDataReceiver);
		TEST(SUCCEEDED(hr));

		//

		CComPtr<IEnumDirFilterFactory> pEnumDirFilterFactory;
		hr = CreateEnumDirFilterFactoryObject(&pEnumDirFilterFactory);
		TEST(SUCCEEDED(hr));

		UINT maxLevel = 0;
		hr = pEnumDirFilterFactory->get_MaxLevel(&maxLevel);
		TEST(SUCCEEDED(hr));
		TEST(maxLevel == 0);

		hr = pEnumDirFilterFactory->set_MaxLevel(1);
		TEST(SUCCEEDED(hr));

		hr = pEnumDirFilterFactory->get_MaxLevel(&maxLevel);
		TEST(SUCCEEDED(hr));
		TEST(maxLevel == 1);

		INameMatcher* pNameMatcher0 = NULL;
		hr = pEnumDirFilterFactory->get_NameFilter(&pNameMatcher0);
		TEST(hr == S_OK);
		TEST(pNameMatcher0 == NULL);

		hr = pEnumDirFilterFactory->set_NameFilter(pNameMatcher);
		TEST(SUCCEEDED(hr));

		hr = pEnumDirFilterFactory->get_NameFilter(&pNameMatcher0);
		TEST(hr == S_OK);
		TEST(pNameMatcher == pNameMatcher0);

		//

		CComPtr<IEnumDirHandler> pCallback;
		hr = pEnumDirFilterFactory->CreateFilter(pW32FindDataReceiver, &pCallback);
		TEST(hr == S_OK);

		//

		CComPtr<IEnumDir> pEnumDir;
		hr = CreateEnumDirObject(&pEnumDir);
		TEST(SUCCEEDED(hr));

		hr = pEnumDir->BeginEnumeration(L"c:\\", pCallback);

		//

		ULONG cnt;
		hr = pFileInfoMap->get_Length(&cnt);
		TEST(SUCCEEDED(hr));
		std::cout << "Count=" << cnt << std::endl;

		//

		CComPtr<IFileInfoComparatorFactory> pFileInfoComparatorFactory;
		hr = CreateFileInfoComparatorFactoryObject(&pFileInfoComparatorFactory);
		TEST(SUCCEEDED(hr));

		CComPtr<IFileInfoComparator> pFileInfoComparator;
		hr = pFileInfoComparatorFactory->Create(&pFileInfoComparator);
		TEST(SUCCEEDED(hr));

		//FILE_INFO findData0;
		//TEST(pFileInfoMap->get_Item(L"c:\\username.txt", &findData0) == S_OK);
		//TEST(pFileInfoMap->get_Item(L"c:\\username.txt2", NULL) == S_FALSE);

		CComPtr<IFileInfoEnumerator> pFileInfoEnumerator;
		hr = pFileInfoMap->new_Enum(&pFileInfoEnumerator);
		TEST(SUCCEEDED(hr));
		ULONG c = 0;
		while ((hr = pFileInfoEnumerator->HasNext()) == S_OK) {
			CComBSTR name;
			CComPtr<IFileInfo> pFileInfo;
			hr = pFileInfoEnumerator->Next(&name, &pFileInfo);
			TEST(SUCCEEDED(hr));

			CW2A printName(name);
			DWORD attributes;

			hr = pFileInfo->get_Attributes(&attributes);
			TEST(SUCCEEDED(hr));

			CComPtr<IFileInfo> pFileInfo2;
			hr = CreateFileInfoObject(name, &pFileInfo2);
			TEST(SUCCEEDED(hr));

			std::cout << printName << ":" << attributes << " @ ";

			hr = pFileInfoComparator->IsEquals(pFileInfo, pFileInfo2);

			std::cout << hr << std::endl;

			c += 1;
		}
		std::cout << "cnt=" << c << std::endl;

		CComPtr<IFileInfoCollection> pCollection2;
		hr = pFileInfoMap->Clone(&pCollection2);
		TEST(SUCCEEDED(hr));
		hr = pCollection2->get_Length(&cnt);
		TEST(SUCCEEDED(hr));

		std::cout << cnt << std::endl;

		pCollection2->Clear();
		hr = pCollection2->get_Length(&cnt);
		TEST(SUCCEEDED(hr));

		std::cout << cnt << std::endl;
		TEST(cnt == 0);

		hr = pFileInfoMap->get_Length(&cnt);
		TEST(SUCCEEDED(hr));
		std::cout << cnt << std::endl;
		TEST(cnt != 0);
	}

	void Test5(void) throw()
	{
		std::cout << "message loop" << std::endl;

		HRESULT hr;

		IFindFileFactory* pFindFileFactory = NULL;
		
		hr = CreateFindFileFactoryObject(&pFindFileFactory);

		if (FAILED(hr)) {
			TEST(false);
		}
		else {
			IFindFile* pFindFile = NULL;
			hr = pFindFileFactory->Create(L"C:\\*.*", &pFindFile);
			std::cout << hr << std::endl;
			if (SUCCEEDED(hr)) {
				WIN32_FIND_DATA findData;
				while (pFindFile->HasNext() == S_OK) {
					if (FAILED(pFindFile->Next(&findData))) {
						std::cout << "occured error (in Next): " << std::endl;
						break;
					}
					CW2A name(findData.cFileName);
					std::cout << name << std::endl;
				}

				IFindFile2* pFindFile2 = NULL;
				if (SUCCEEDED(pFindFile->QueryInterface(&pFindFile2))) {
					HANDLE handle = NULL;
					std::cout << "enumdir2:" << pFindFile2->GetHandle(&handle) << std::endl;
					pFindFile2->Release();
				}

				pFindFile->Release();
			}
			pFindFileFactory->Release();
		}
	}

};

int _tmain(int argc, _TCHAR* argv[])
{
	FWatchCore2App app;
	return app.WinMain(SW_SHOWNORMAL);
}

