#include "stdafx.h"

#include "FWatchCore2Obj.hpp"

/**
 * v_pPath̍Ō̖O擾܂B
 * v_pPath󕶎܂NULL̏ꍇE_INVALIDARGƂȂ܂B
 * tH_؂ŏIĂꍇNULLԂ܂B
 * NULLԂꍇS_FALSE߂lƂ܂B
 * łȂS_OKԂ܂B
 * v_pLastNameNULL̏ꍇ͊i[A̔̂ݍs܂B
 * @param v_pPath pXA(󕶎܂NULL͎wł܂B)
 * @param v_pLastName pX̍Ō̖Oi[|C^ANULL
 * @return S_OKȂ΃pX̍Ō̖Oi[Ă܂B
 *         S_FALSEł΃tH_؂ŏIĂ܂B
 *         sł΃G[R[h(E_INVALIDARG)Ԃ܂B
 */
extern "C" HRESULT __stdcall GetPathLastName(LPCWSTR v_pPath, LPCWSTR* v_pLastName) throw()
{
	if ( !v_pPath || !*v_pPath) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}
	
	LPCWSTR p = v_pPath;
	while (*p) p++;

	while (p > v_pPath) {
		if (*p == '\\' || *p == '/') {
			break;
		}
		p--;
	}

	if (*p == '\\' || *p == '/') {
		p += 1;
	}

	if (*p == 0) {
		p = NULL;
	}

	if (v_pLastName) {
		*v_pLastName = p;
	}

	return p ? S_OK : S_FALSE;
}

/**
 * Ɏw肳ꂽpX΃pXƂĎ擾܂B
 * v_addNameNULL܂͋łȂꍇ́Aǉ̃pXƂČŐ΃pXƂ܂B
 * pX݂邩͔肳܂B
 * ꍇBSTR͌ĂяoƂȂ΂Ȃ܂B
 * @param v_pDirName pX
 * @param v_addName ǉpXANULL
 * @param v_pAbsoluteName ʂi[BSTRւ̃|C^
 * @return ܂͎sHRESULT
 */
extern "C" HRESULT __stdcall GetAbsolutePathName(LPCWSTR v_pDirName, LPCWSTR v_pAddName, BSTR* v_pAbsoluteName) throw()
{
	if ( !v_pAbsoluteName || !v_pDirName || lstrlen(v_pDirName) == 0) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	LPCWSTR pAddName = v_pAddName;
	if (pAddName != NULL) {
		while (*pAddName == '\\' || *pAddName == '/') {
			pAddName += 1;
		}
	}
	DWORD appendLen = (pAddName == NULL) ? 0 : lstrlen(pAddName);
	if (appendLen > 0) {
		appendLen += 1; // ɒǉtH_؂蕪ǉB
	}

	BSTR buf = NULL;
	__try {
		DWORD len = 128;
		LPWSTR pName = NULL;
		do {
			buf = SysAllocStringLen(NULL, len);
			if (!buf) {
				return E_OUTOFMEMORY;
			}
			DWORD wdLen = GetFullPathName(v_pDirName, len, buf, &pName);
			if (wdLen == 0) {
				return AtlHresultFromLastError();
			}
			if (wdLen + appendLen <= len) {
				break;
			}
			len = wdLen + appendLen;
			SysFreeString(buf);
		} while(1);

		if (appendLen > 0) {
			LPWSTR pExt = NULL;
			if (pName == NULL || lstrlen(pName) == 0) {
				pExt = buf + lstrlen(buf);
			}
			else {
				pExt = buf + lstrlen(buf);
				*pExt++ = '\\';
			}

			lstrcpy(pExt, pAddName);
			ATLASSERT(static_cast<UINT>(lstrlen(buf)) <= SysStringLen(buf));

			return GetAbsolutePathName(buf, NULL, v_pAbsoluteName);
		}

		ATLASSERT(buf);
		*v_pAbsoluteName = SysAllocString(buf); // Kvŏ̒Ƃč쐬ȂB
		return S_OK;
	}
	__finally {
		SysFreeString(buf);
	}
}
