#include "stdafx.h"

#include "FWatchCore2Obj.hpp"

#include "FileInfoComparatorImpl.hpp"
#include "ObjectLockUty.hpp"

using namespace FWatchCore2Lib;

HRESULT CFileInfoComparatorFactory::FinalConstruct() throw()
{
	attributesMask_ = 0;
	tolerance_ = 0;

	return S_OK;
}

/**
 * IFileInfoComparator\z܂B
 * @param v_ppFileInfoComparator C^[tFCXi[|C^
 * @return ܂͎s\HRESULT
 */
HRESULT __stdcall CFileInfoComparatorFactory::Create(IFileInfoComparator** v_ppFileInfoComparator) throw()
{
	if ( !v_ppFileInfoComparator) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CFileInfoComparatorFactory> lock(this);

	ATLASSERT(!*v_ppFileInfoComparator);
	*v_ppFileInfoComparator = NULL;

	CComObject<CFileInfoComparator>* pFileInfoComparator = NULL;
	HRESULT hr = CComObject<CFileInfoComparator>::CreateInstance(&pFileInfoComparator);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pFileInfoComparator);
	pFileInfoComparator->AddRef();

	hr = pFileInfoComparator->Init(tolerance_, attributesMask_);
	if (FAILED(hr)) {
		pFileInfoComparator->Release();
		return hr;
	}

	*v_ppFileInfoComparator = pFileInfoComparator;

	return S_OK;
}

/**
 * t@C̍XV𓯈Ƃ݂Ȃ͈͂100imbPʂŎw肵܂B
 * @param v_tolerance Ƃ݂Ȃe͈
 * @return ܂͎s\HRESULT
 */
HRESULT __stdcall CFileInfoComparatorFactory::set_FileTimeTolerance(ULONG v_tolerance) throw()
{
	ThreadGuard<CFileInfoComparatorFactory> lock(this);

	tolerance_ = v_tolerance;

	return S_OK;
}

/**
 * t@C̍XV𓯈Ƃ݂Ȃ͈(100imbP)擾܂B
 * @param v_pTolerance Ƃ݂Ȃe͈͂i[|C^
 * @return ܂͎s\HRESULT
 */
HRESULT __stdcall CFileInfoComparatorFactory::get_FileTimeTolerance(ULONG* v_pTolerance) throw()
{
	if ( !v_pTolerance) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CFileInfoComparatorFactory> lock(this);

	*v_pTolerance = tolerance_;

	return S_OK;
}

/**
 * t@C̑r邽߂̃rbg}XNB
 * }XNꂽlŔr܂B
 * @param v_attributesMask t@C̃rbg}XN
 * @return ܂͎s\HRESULT
 */
HRESULT __stdcall CFileInfoComparatorFactory::set_AttributesMask(DWORD v_attributesMask) throw()
{
	ThreadGuard<CFileInfoComparatorFactory> lock(this);

	attributesMask_ = v_attributesMask;

	return S_OK;
}

/**
 * t@C̑r邽߂̃rbg}XN擾܂B
 * @param v_pAttributesMask t@C̃rbg}XNi[|C^
 * @return ܂͎s\HRESULT
 */
HRESULT __stdcall CFileInfoComparatorFactory::get_AttributesMask(DWORD* v_pAttributesMask) throw()
{
	if ( !v_pAttributesMask) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CFileInfoComparatorFactory> lock(this);
	
	*v_pAttributesMask = attributesMask_;

	return S_OK;
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CFileInfoComparatorFactory), CFileInfoComparatorFactory)


///////////////////////////////////////////////


HRESULT CFileInfoComparator::Init(ULONG v_tolerance, DWORD v_attributesMask) throw()
{
	tolerance_ = v_tolerance;
	attributesMask_ = v_attributesMask;

	return S_OK;
}

HRESULT __stdcall CFileInfoComparator::IsEquals(IFileInfo* v_pFileInfo1, IFileInfo* v_pFileInfo2) throw()
{
	if (v_pFileInfo1 == v_pFileInfo2) {
		// oNULLł邩A͓|C^ꍇ͈v邱Ƃ͖
		return S_OK;
	}
	
	if ( !v_pFileInfo1 || !v_pFileInfo2) {
		// ꂩNULLłΈvȂƂ͖
		return S_FALSE;
	}

	// ̔r

	HRESULT hr;

	DWORD attr1, attr2;

	hr = v_pFileInfo1->get_Attributes(&attr1);
	if (FAILED(hr)) {
		return hr;
	}
	hr = v_pFileInfo2->get_Attributes(&attr2);
	if (FAILED(hr)) {
		return hr;
	}

	attr1 &= attributesMask_;
	attr2 &= attributesMask_;

	if (attr1 != attr2) {
		return S_FALSE;
	}

	// t@CTCY̔r
	
	ULARGE_INTEGER fileSize1, fileSize2;

	hr = v_pFileInfo1->get_FileSize(&fileSize1);
	if (FAILED(hr)) {
		return hr;
	}
	hr = v_pFileInfo2->get_FileSize(&fileSize2);
	if (FAILED(hr)) {
		return hr;
	}

	const ULONGLONG sizeDiff = fileSize1.QuadPart - fileSize2.QuadPart;

	if (sizeDiff) {
		return S_FALSE;
	}

	// ŏIXV̔r
	
	FILETIME fileTime1, fileTime2;

	hr = v_pFileInfo1->get_LastModified(&fileTime1);
	if (FAILED(hr)) {
		return hr;
	}
	hr = v_pFileInfo2->get_LastModified(&fileTime2);
	if (FAILED(hr)) {
		return hr;
	}

	ULARGE_INTEGER nFileTime1;
	ULARGE_INTEGER nFileTime2;
	
	nFileTime1.HighPart = fileTime1.dwHighDateTime;
	nFileTime1.LowPart = fileTime1.dwLowDateTime;
	
	nFileTime2.HighPart = fileTime2.dwHighDateTime;
	nFileTime2.LowPart = fileTime2.dwLowDateTime;

	const LONGLONG timeDiff = nFileTime1.QuadPart - nFileTime2.QuadPart;

	if (timeDiff) {
		if ((timeDiff > 0 && timeDiff > tolerance_) || (timeDiff < 0 && -timeDiff > tolerance_)) {
			return S_FALSE;
		}
	}

	return S_OK;
}

HRESULT __stdcall CFileInfoComparator::IsEquals(LPCWSTR v_pName, IFileInfo* v_pFileInfo1, IFileInfo* v_pFileInfo2) throw()
{
	if ( !v_pName) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	return IsEquals(v_pFileInfo1, v_pFileInfo2);
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CFileInfoComparator), CFileInfoComparator)


///////////////////////////////////////////////


extern "C" HRESULT __stdcall CreateFileInfoComparatorFactoryObject(IFileInfoComparatorFactory** v_ppFileInfoComparatorFactory) throw()
{
	if ( !v_ppFileInfoComparatorFactory) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	return CFileInfoComparatorFactory::CreateInstance(v_ppFileInfoComparatorFactory);
}

