#include "stdafx.h"

#include "FWatchCore2Impl.hpp"
#include "ObjectLockUty.hpp"

using namespace FWatchCore2Lib;

////////////// CEnumDir ///////////////

CFindFile::CFindFile() throw()
	: maxLevel_(0)
	, hasNext_(FALSE)
	, hFindHandle_(NULL)
	, errorCode_(0)
{
}

void CFindFile::FinalRelease() throw()
{
	if (hFindHandle_ && hFindHandle_ != INVALID_HANDLE_VALUE) {
		FindClose(hFindHandle_);
	}
}

HRESULT CFindFile::Begin(LPCWSTR v_dirName) throw()
{
	ATLASSERT( !hFindHandle_);
	if ( !v_dirName) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CFindFile> lock(this);

	hFindHandle_ = FindFirstFile(v_dirName, &findData_);
	if (hFindHandle_ != INVALID_HANDLE_VALUE) {
		hasNext_ = TRUE;
	}
	else {
		const DWORD err = GetLastError();
		if (err != ERROR_NO_MORE_FILES) {
			return AtlHresultFromWin32(err);
		}
		hasNext_ = FALSE;
	}

	return S_OK;
}

HRESULT __stdcall CFindFile::HasNext() throw()
{
	ThreadGuard<CFindFile> lock(this);

	if ( !hFindHandle_ || hFindHandle_ == INVALID_HANDLE_VALUE) {
		ATLASSERT(false);
		return E_FAIL;
	}

	if (hasNext_) {
		return S_OK;
	}
	return S_FALSE;
}

HRESULT __stdcall CFindFile::Next(WIN32_FIND_DATA* v_pFindData) throw()
{
	if ( !v_pFindData) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CFindFile> lock(this);

	if ( !hFindHandle_ || hFindHandle_ == INVALID_HANDLE_VALUE) {
		ATLASSERT(false);
		return E_FAIL;
	}

	if (errorCode_) {
		HRESULT hr = AtlHresultFromWin32(errorCode_);
		errorCode_ = 0;
		return hr;
	}

	if ( !hasNext_) {
		return E_FAIL;
	}

	*v_pFindData = findData_;

	if (FindNextFile(hFindHandle_, &findData_)) {
		hasNext_ = TRUE;
	}
	else {
		const DWORD err = GetLastError();
		if (err == ERROR_NO_MORE_FILES) {
			hasNext_ = FALSE;
		}
		else {
			errorCode_ = err;
		}
	}

	return S_OK;
}

HRESULT __stdcall CFindFile::GetHandle(HANDLE* v_pHandle) throw()
{
	if ( !v_pHandle) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CFindFile> lock(this);

	if ( !hFindHandle_ || hFindHandle_ == INVALID_HANDLE_VALUE) {
		return E_FAIL;
	}

	*v_pHandle = hFindHandle_;

	return S_OK;
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CFindFile), CFindFile)

////////////// CEnumDirFactory ///////////////

HRESULT __stdcall CFindFileFactory::Create(LPCWSTR v_dirName, IFindFile** v_ppEnumDir) throw()
{
	if ( !v_dirName || !v_ppEnumDir) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppEnumDir);
	*v_ppEnumDir = NULL;

	HRESULT hr;
	CComObject<CFindFile>* pEnumDir = NULL;

	hr = CComObject<CFindFile>::CreateInstance(&pEnumDir);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pEnumDir);
	pEnumDir->AddRef();

	hr = pEnumDir->Begin(v_dirName);
	if (FAILED(hr)) {
		pEnumDir->Release();
		return hr;
	}

	*v_ppEnumDir = pEnumDir;

	return S_OK;
}

OBJECT_ENTRY_AUTO(/*__uuidof(CFindFileFactory)*/ CLSID_CFindFileFactory, CFindFileFactory)

///////////////////////////////////////////////

extern "C" HRESULT __stdcall CreateFindFileFactoryObject(IFindFileFactory** v_ppFindFileFactory) throw()
{
	if ( !v_ppFindFileFactory) {
		ATLASSERT(false);
		return E_FAIL;
	}

	return CFindFileFactory::CreateInstance(v_ppFindFileFactory);
}
