#include "stdafx.h"

#include "FWatchCore2Obj.hpp"

#include "ObjectLockUty.hpp"
#include "ErrorHandlerImpl.hpp"

using namespace FWatchCore2Lib;

////////////////////////////////

HRESULT __stdcall CErrorTransformerFactory::Clear(void) throw()
{
	ThreadGuard<CErrorTransformerFactory> lock(this);

	errorCodeMapping_.RemoveAll();

	return S_OK;
}

HRESULT __stdcall CErrorTransformerFactory::TransformErrorCode(HRESULT v_errorCode, HRESULT v_transformedErrorCode) throw()
{
	if (v_errorCode == v_transformedErrorCode) {
		return S_OK;
	}
	
	HRESULT_TRANSFORM trans;

	trans.mask = 0xffffffff; // 32bit
	trans.targetCode = v_errorCode;
	trans.resultCode = v_transformedErrorCode;

	ThreadGuard<CErrorTransformerFactory> lock(this);

	try {
		errorCodeMapping_.AddTail(trans);
	}
	catch (...) {
		return E_OUTOFMEMORY;
	}

	return S_OK;
}

HRESULT __stdcall CErrorTransformerFactory::Create(IErrorHandler* v_pChainHandler, IErrorHandler** v_ppErrorTransformer) throw()
{
	if ( !v_ppErrorTransformer) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppErrorTransformer);
	*v_ppErrorTransformer = NULL;

	ThreadGuard<CErrorTransformerFactory> lock(this);

	HRESULT hr;
	CComObject<CErrorTransformer>* pErrorTransformerImpl = NULL;
	hr = CComObject<CErrorTransformer>::CreateInstance(&pErrorTransformerImpl);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pErrorTransformerImpl);
	CComPtr<IErrorHandler> pErrorTransformer(pErrorTransformerImpl);

	hr = pErrorTransformerImpl->Init(v_pChainHandler, errorCodeMapping_);
	if (FAILED(hr)) {
		return hr;
	}

	ATLASSERT(pErrorTransformer);
	return pErrorTransformer.QueryInterface(v_ppErrorTransformer);
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CErrorTransformerFactory), CErrorTransformerFactory)


////////////////////////////////

/// PRIVATE

HRESULT CErrorTransformer::Init(IErrorHandler* v_pChainHandler, TransformMappingList& v_mappingList) throw()
{
	errorCodeMapping_.RemoveAll();

	pChainHandler_ = v_pChainHandler;

	POSITION pos = v_mappingList.GetHeadPosition();
	while (pos) {
		errorCodeMapping_.AddTail(v_mappingList.GetNext(pos));
	}

	return S_OK;
}

/// IErrorHandler

HRESULT __stdcall CErrorTransformer::HandleError(HRESULT v_errorCode) throw()
{
	POSITION pos = errorCodeMapping_.GetHeadPosition();
	while (pos) {
		HRESULT_TRANSFORM trans = errorCodeMapping_.GetNext(pos);
		HRESULT maskedErrorCode = trans.mask & v_errorCode;
		if (maskedErrorCode == trans.targetCode) {
			return trans.resultCode;
		}
	}

	if (pChainHandler_) {
		return pChainHandler_->HandleError(v_errorCode);
	}

	return v_errorCode;
}

////////////////////////////////

/**
 * gXtH[t@Ng\z܂B
 */
extern "C" HRESULT __stdcall CreateErrorTransformFactoryObject(IErrorTransformerFactory** v_ppErrorTransformerFactory) throw()
{
	if ( !v_ppErrorTransformerFactory) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	return CErrorTransformerFactory::CreateInstance(v_ppErrorTransformerFactory);
}

