#include "stdafx.hpp"

#include "tstringUty.hpp"
#include "Utility.hpp"

#include <assert.h>
#include <vector>

/*!
 * 𕶎ƂĕԂ܂B
 * ԂIuWFNg͈ꎞIuWFNgłB
 * \param v_value 
 * \return 
 */
tstring tstringuty::IntToString( int v_value ) throw()
{
	return ToString( _TEXT("%d"), v_value );
}

/*!
 * 𕶎ɕϊĕԂ܂B
 * ԂIuWFNg͈ꎞIuWFNgłB
 * \param v_format tH[}bg
 * \return 
 */
tstring tstringuty::ToString( const LPCTSTR v_format, ... ) throw()
{
	//required:
	assert( v_format != NULL && "v_formatnull͎wł܂B" );

	//do:
	va_list marker;
	va_start( marker, v_format );

	TCHAR buffer[ 4096 ];
	wvsprintf( buffer, v_format, marker );
	
	return tstring( buffer );
}

/*!
 * ̑OɊ܂܂󔒂ƃ^v菜Ԃ܂B
 * ͔j󂳂܂B
 * Ԃ镶͈ꎞIIuWFNgłB
 */
tstring tstringuty::trimSpaceBoth( const tstring& v_in )
{
	const tstring::size_type len = v_in.length();

	tstring::size_type firstNonSpcIdx = 0;
	tstring::size_type idx = 0;
	while( idx < len ) {
		if( ! ( v_in[ idx ] > 0 && v_in[ idx ] <= ' ' ) ) {
			break;
		}
		idx++;
		firstNonSpcIdx++;
	}
	tstring::size_type lastNonSpcIdx = idx;
	while( idx < len ) {
		if( ! ( v_in[ idx ] > 0 && v_in[ idx ] <= ' ' ) ) {
			lastNonSpcIdx = idx;
		}
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( v_in[ idx ] ) ) {
			idx ++;
			lastNonSpcIdx = idx;
		}
#endif
		idx++;
	}

	if( firstNonSpcIdx == 0 && lastNonSpcIdx == len ) {
		// 󔒂Ȃ
		return v_in;
	}
	return v_in.substr( firstNonSpcIdx, lastNonSpcIdx - firstNonSpcIdx + 1 );
}

/*!
 * 񂪎w肵ŏI[邱ƂۏႵ܂B
 * ͔j󂳂܂B
 * Ԃ镶͈ꎞIuWFNgłB
 * \param v_str 
 * \param v_endStr I[镶
 * \return I[Ă邱ƂۏႳꂽ(ꎞIuWFNg)
 */
tstring tstringuty::ensureEndsWith( const tstring& v_str, const tstring& v_endStr ) throw()
{
	const tstring::size_type len1 = v_str.length();
	const tstring::size_type len2 = v_endStr.length();

	bool match = true;
	if( len2 > len1 ) {
		match = false;
	}
	else {
		const tstring::size_type off = getCharLastIndex( v_str, getCharCount( v_endStr ) );
		tstring::size_type idx = 0;
		while( idx < len2 ) {
			if( v_str[ idx + off ] != v_endStr[ idx ] ) {
				match = false;
				break;
			}
#ifndef _UNICODE
			if( ::IsDBCSLeadByte( v_str[ idx + off ] ) ) {
				if( v_str[ idx + off + 1 ] != v_endStr[ idx + 1 ] ) {
					match = false;
					break;
				}
				idx++;
			}
#endif
			idx++;
		}
	}

	if( ! match ) {
		return v_str + v_endStr;
	}
	return v_str;
}

/*!
 * JEg܂B
 * _uoCg̏ꍇ2oCg1ƃJEg܂B
 * \return 
 */
tstring::size_type tstringuty::getCharCount( const tstring& v_str ) throw()
{
	const tstring::size_type len = v_str.length();
	
	tstring::size_type count = 0;
	tstring::size_type idx = 0;
	while( idx < len ) {
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( v_str[ idx ] ) ) {
			idx++;
		}
#endif
		idx++;
		count++;
	}
	return count;
}

/*!
 * w肵̃CfbNX擾܂B
 * _uoCg̏ꍇ2oCg1ƃJEg܂B
 * ۂ̒̕傫ꍇ́A̒(I[+1)̃CfbNXԂ܂B
 * \param v_str 
 * \param v_index A܂npos
 * \return w肵̃CfbNXA܂͏I[+1
 */
tstring::size_type tstringuty::getCharIndex( const tstring& v_str, tstring::size_type v_index ) throw()
{
	const tstring::size_type len = v_str.length();
	
	tstring::size_type count = 0;
	tstring::size_type idx = 0;
	while( idx < len ) {
		if( count >= v_index ) {
			break;
		}
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( v_str[ idx ] ) ) {
			idx++;
		}
#endif
		idx++;
		count++;
	}
	return idx;
}

/*!
 * ̌̎w肵̃CfbNX擾܂B
 */
tstring::size_type tstringuty::getCharLastIndex( const tstring& v_str, tstring::size_type v_lastIndex ) throw()
{
	tstring::size_type count = getCharCount( v_str );
	if( count < v_lastIndex ) {
		return 0;
	}
	return getCharIndex( v_str, count - v_lastIndex );
}

/*!
 * 񂩂琮(int)擾܂B
 * s󔒂͖܂B
 * \param v_text 
 * \return 
 */
int tstringuty::atoi( const tstring& v_text ) throw()
{
	return ::_ttoi( v_text.c_str() );
}

/*!
 * 񂩂琮(long)擾܂B
 * s󔒂͖܂B
 * \param v_text 
 * \return 
 */
int tstringuty::atol( const tstring& v_text ) throw()
{
	return ::_ttol( v_text.c_str() );
}

/*!
 * 񂩂琮(long long)擾܂B
 * s󔒂͖܂B
 * \param v_text 
 * \return 
 */
__int64 tstringuty::atoi64( const tstring& v_text ) throw()
{
	return ::_ttoi64( v_text.c_str() );
}

bool tstringuty::isMatch( const tstring& v_text, const tstring& v_pattern ) throw()
{
	return IsMatch( v_text.c_str(), v_pattern.c_str() );
}

/*!
 * UNICODEԂ܂B
 * \param 
 * \return UNICODE
 */
#ifndef _UNICODE
std::basic_string<char> tstringuty::getStdString( const tstring& v_text ) throw()
{
	return v_text;
}
#else
std::basic_string<char> tstringuty::getStdString( const tstring& v_text ) throw()
{
	const size_t siz = ( v_text.length() + 1 ) * 2;
	std::vector<char> buf( siz );
	if( ! v_text.empty() ) {
		const int resultCount = ::WideCharToMultiByte( CP_OEMCP, 0, v_text.c_str(), -1, &buf[0], (int) siz, NULL, 0 );
		assert( resultCount != 0 );
	}
	return std::basic_string<char>( &buf[0] );
}
#endif

/*!
 * UNICODE݂tstrinǧ^ɕϊĕԂ܂B
 * \param 
 * \return ݂̕TCY̕
 */
#ifndef _UNICODE
tstring tstringuty::getTString( const std::string& v_text ) throw()
{
	return v_text;
}
#else
tstring tstringuty::getTString( const std::string& v_text ) throw()
{
	const size_t siz = v_text.length() + 1;
	std::vector<wchar_t> buf( siz );
	if( ! v_text.empty() ) {
		const int resultCount = ::MultiByteToWideChar( CP_OEMCP, MB_PRECOMPOSED, v_text.c_str(), -1, &buf[0], (int) siz );
		assert( resultCount != 0 );
	}
	return std::basic_string<wchar_t>( &buf[0] );
}
#endif
