#ifndef INCLUDE_H_WATCHTASKGROUP
#define INCLUDE_H_WATCHTASKGROUP

#include "WatchTask.hpp"
#include "SettingInfo.hpp"

#include "Thread.hpp"

#include "tstring.hpp"
#include <vector>

class WatchTaskGroup
{
private:
	WatchTaskGroup( const WatchTaskGroup& ); //<! Ȃ
	operator=( const WatchTaskGroup& ); //<! Ȃ

public:
	
	/*!
	 * ĎXbhO[v\z܂B
	 * hC[hLɂƃXbh͎ۂɂ͍쐬ꂸҏŴ݂ƂȂ܂B
	 * \param v_dryrun hC[h̏ꍇAtrue
	 */
	WatchTaskGroup( const bool v_dryrun );

	virtual ~WatchTaskGroup();
	
	void clear();

	const CSettingInfo& getInfo( unsigned int idx ) const;
	unsigned int size() const;

	bool append( const CSettingInfo& v_settingInfo );
	bool replace( unsigned int idx, const CSettingInfo& v_settingInfo );
	bool erase( unsigned int idx );

	bool isRunning() const;
	bool isDryRun() const;

	bool LoadInfData( const tstring& InfPath );
	bool SaveInfData( const tstring& InfPath, bool bForce = false ) const;
	bool isModified() const;

private:
	const bool dryrun_;
	mutable bool modified_;

	BasicMultiTaskEx multiTask_;

	typedef std::vector<WatchTask*> WatchTaskList;
	WatchTaskList taskList_;
};

#endif
