#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "SettingInfoFactory.hpp"

#include "tstringUty.hpp"

#include <assert.h>

#pragma warning( disable : 4290 )

CSettingInfoFactory::CSettingInfoFactory()
	: pErrorInfoListener_( NULL )
{
}

CSettingInfoFactory::CSettingInfoFactory( const CSettingInfo& v_settingInfo )
	: info_( v_settingInfo )
	, pErrorInfoListener_( NULL )
{
}

CSettingInfoFactory::CSettingInfoFactory( const CSettingInfoFactory& v_other )
	: info_( v_other.info_ )
	, pErrorInfoListener_( v_other.pErrorInfoListener_ )
{
}

CSettingInfoFactory& CSettingInfoFactory::operator=( const CSettingInfoFactory& v_other )
{
	if( this == &v_other ) {
		return *this;
	}

	info_ = v_other.info_;
	pErrorInfoListener_ = v_other.pErrorInfoListener_;

	return *this;
}

CSettingInfoFactory::~CSettingInfoFactory()
{
}

void CSettingInfoFactory::setErrorInfoListener( ErrorInfoListener* v_pErrorInfoListener ) throw()
{
	pErrorInfoListener_ = v_pErrorInfoListener;
}

bool CSettingInfoFactory::validate( const bool v_silent ) const
{
	bool result = true;
	if( info_.nWaitWrite_ <= 0){
		result = false;
		if( ! v_silent ) {
			notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_WAITTIME ) );
		}
	}
	if( info_.watchDir_.empty() ) {
		result = false;
		if( ! v_silent ) {
			notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_NEEDFOLDER ) );
		}
	}
	if( ! info_.bUsingNotificationAPI_ && info_.nForceInterval_ == 0 ) {
		result = false;
		if( ! v_silent ) {
			notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_UNSETDIRNOTIFICATION ) );
		}
	}

	return result;
}

CSettingInfo CSettingInfoFactory::create() const throw( CSettingInfoFactoryException )
{
	if( ! validate( true ) ) {
		throw CSettingInfoFactoryException( _TEXT("\zp[^sȂ߃IuWFNg쐬邱Ƃ͂ł܂B") );
	}
	return info_;
}

/*!
 * XiɃG[ʒm܂B
 * Xi̓G[󂯓ďC邱Ƃ]ޏꍇtrueԂƂł܂B
 * ̏ꍇÃ\bhtrueԂ܂B
 * Xio^ĂȂꍇ͏falseԂ܂B
 * \param G[bZ[W
 * \return G[CsꍇAtrue
 */
bool CSettingInfoFactory::notifyErrorInfo( const tstring& v_errorInfo ) const
{
	if( pErrorInfoListener_ != NULL ) {
		return pErrorInfoListener_->notifyErrorInfo( v_errorInfo );
	}
	return false;
}

void CSettingInfoFactory::setWatchDir( const tstring& v_watchDir )
{
	info_.watchDir_ = tstringuty::trimSpaceBoth( v_watchDir );
	if( ! info_.watchDir_.empty() ) {
		info_.watchDir_ = tstringuty::ensureEndsWith(
			tstringuty::trimSpaceBoth( info_.watchDir_ ), tstring( _TEXT("\\") ) );
	}
}

void CSettingInfoFactory::setWatchFile( const tstring& v_watchFile )
{
	info_.watchFile_ = tstringuty::trimSpaceBoth( v_watchFile );
	if( info_.watchFile_.empty() ) {
		info_.watchFile_ = tstring( _TEXT("*.*") );
	}
}

void CSettingInfoFactory::setAction( const tstring& v_action )
{
	info_.action_ = tstringuty::trimSpaceBoth( v_action );
}

void CSettingInfoFactory::setAppName( const tstring& v_appName )
{
	info_.appName_ = tstringuty::trimSpaceBoth( v_appName );
}

void CSettingInfoFactory::setParam( const tstring& v_param )
{
	info_.param_ = tstringuty::trimSpaceBoth( v_param );
}

void CSettingInfoFactory::setLog( const tstring& v_log )
{
	info_.log_ = tstringuty::trimSpaceBoth( v_log );
}

void CSettingInfoFactory::setWaitWrite( const int v_waitWrite )
{
	if( v_waitWrite < 1 && ! notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_WAITTIME ) ) ) {
		return;
	}
	info_.nWaitWrite_ = ( v_waitWrite < 1 ) ? 1 : v_waitWrite;
}

void CSettingInfoFactory::setMaxProcess( const unsigned int v_nMaxProcess )
{
	info_.nMaxProcess_ = ( v_nMaxProcess < 0 ) ? 0 : v_nMaxProcess;
}

void CSettingInfoFactory::setShowWindow( const ShowWindowType& v_showWindow )
{
	info_.showWindow_ = v_showWindow;
}

void CSettingInfoFactory::setTolerance( const int v_nTolerance )
{
	info_.nTolerance_ = ( v_nTolerance < 0 ) ? 0 : v_nTolerance;
}

void CSettingInfoFactory::setDeletePending( const int v_deletePending )
{
	info_.nDeletePending_ = ( v_deletePending < 0 ) ? 0 : v_deletePending;
}

void CSettingInfoFactory::setMaxDepth( const int v_maxDepth )
{
	info_.nMaxDepth_ = ( v_maxDepth < 0 ) ? 0 : v_maxDepth;
}

void CSettingInfoFactory::setForceInterval( const int v_forceInterval )
{
	if( v_forceInterval <= 0 && ! info_.bUsingNotificationAPI_ ) {
		if( ! notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_UNSETDIRNOTIFICATION ) ) ) {
			return;
		}
	}
	info_.nForceInterval_ = ( v_forceInterval <= 0 ) ? ( info_.bUsingNotificationAPI_ ? 0 : 180 ) : v_forceInterval;
}

void CSettingInfoFactory::setUsingDirNotificationAPI( const bool v_usingDirNotificationAPI )
{
	if( ! v_usingDirNotificationAPI && info_.nForceInterval_ <= 0 ) {
		if( ! notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_UNSETDIRNOTIFICATION ) ) ) {
			return;
		}
		info_.nForceInterval_ = 180;
	}
	info_.bUsingNotificationAPI_ = v_usingDirNotificationAPI;
}

void CSettingInfoFactory::setDirNotificationAPIRetryInterval( const int v_dirNotificationAPIRetryInterval )
{
	info_.nDirNotificationAPIRetryInterval_ = ( v_dirNotificationAPIRetryInterval < 0 ) ? 0 : v_dirNotificationAPIRetryInterval;
}

void CSettingInfoFactory::setDirNotificationAPIExpirySpan( const int v_dirNotificationAPIExpirySpan )
{
	info_.nDirNotificationAPIExpirySpan_ = ( v_dirNotificationAPIExpirySpan < 0 ) ? 0 : v_dirNotificationAPIExpirySpan;
}

void CSettingInfoFactory::setDelaySignalSpan( const int v_delaySignalSpan ) throw()
{
	info_.delaySignalSpan_ = ( v_delaySignalSpan < 0 ) ? 0 : v_delaySignalSpan;
}

void CSettingInfoFactory::setAppCurrentDir( const tstring& v_appCurrentDir ) throw()
{
	info_.appCurrentDir_ = tstringuty::trimSpaceBoth( v_appCurrentDir );
}


