#include "stdafx.hpp"

#include "ResourceAccessor.hpp"

#include "tstringUty.hpp"

#include <assert.h>
#include <vector>

int AbstractResourceAccessor::LoadString( UINT uMessageID, LPTSTR buffer, int nBufferMax ) const
{
	return ::LoadString( getInstanceHandle(), uMessageID, buffer, nBufferMax );
}

tstring AbstractResourceAccessor::LoadString( UINT uMessageID ) const
{
	TCHAR buffer[ 4096 ] = { 0 };
	::LoadString( getInstanceHandle(), uMessageID, buffer, 4096 );
	return buffer;
}

int AbstractResourceAccessor::LoadInteger( UINT uMessageID ) const
{
	return tstringuty::atoi( LoadString( uMessageID ).c_str() );
}

tstring AbstractResourceAccessor::LoadStringFormat( UINT uMessageID, ... ) const
{
	va_list marker;
	va_start( marker, uMessageID );

	const tstring format = LoadString( uMessageID );

	TCHAR buffer[ 4096 ];
	wvsprintf( buffer, format.c_str(), marker );
	
	return tstring( buffer );
}

//////

ResourceAccessor::ResourceAccessor( HINSTANCE v_hInstance )
	: hInstance_( v_hInstance )
{
	assert( hInstance_ != NULL && "v_hInstanceNULL͎wł܂B" );
}

HINSTANCE ResourceAccessor::getInstanceHandle() const
{
	return hInstance_;
}


