<?php
/**
 * ページ取得結果を表示する関数の定義
 * scrapshot.phpから利用
 *
 *
 */

require_once (dirname(__FILE__) . '/../config.php');
require_once (dirname(__FILE__) . '/smarty/Smarty.class.php');

if(readConfig("BAYESIANTAG")){
  require_once 'analyze/naivebayes.php';
}

//ログ情報を表示するtableを作成
function _echoResultTable($meta, $echoDownload=true) {
  
  //追加情報の取得
  $basenames = urlToBasename($meta["url"]);
  
  //urlキー名の設定
  $keyname = saniCookie(substr($meta["url"], 7));
  
  $userhost = gethostbyaddr(getClientIp());
  $tags = array();
  foreach($meta["tags"] as $tag) {
    $tags[] = array(
      "value" => $tag[0],
      "owner" => ($tag[1] == $userhost)
      );
  }
  $meta["stocked"] = in_array(read_regid(), $meta['alluserid']);
  
  $smarty = new Smarty();
    
  $smarty->template_dir = dirname(__FILE__) . '/../templates/';
  $smarty->compile_dir  = dirname(__FILE__) . '/../templates_c/';

  $smarty->assign('alltag', readalltag());
  $smarty->assign('meta', $meta);
  $smarty->assign('usethumb', readConfig("THUMB") && $meta["thumb"]);
  $smarty->assign('echoDownload', $echoDownload);
  $smarty->assign('tags', $tags);
  $smarty->assign('md5url', md5($meta["url"]));
  $smarty->assign('datestr', date("Y/m/d H:i:s", $meta["date"]));
  $smarty->assign('USEZIP', readConfig("USEZIP"));
  $smarty->assign('res_count', number_format($meta["res_count"]-1));
  $smarty->assign('dumb', number_format(ceil($meta["du"]/1000/100)*0.1,1) );
  $smarty->assign('NEARBY', readConfig("USEFILEHASHING"));
  
  $smarty->assign('USECONTACT', readConfig("USECONTACT") );
  
  if(readConfig("BAYESIANTAG")){
    $bayes = new NaiveBayes();
    $bayestag = $bayes->classifier_list( $meta["res"] );
    $bayes->close(); 
    $smarty->assign('bayestag', $bayestag );
  }
  $smarty->assign('BAYESIANTAG', readConfig("BAYESIANTAG") );
  $smarty->assign('STOCKLIST', readConfig("STOCKLIST"));
  
  return $smarty->fetch('infotable.tpl');
}

function resultPage($meta) {

  $smarty = new Smarty();
  $smarty->template_dir = dirname(__FILE__) .'/../templates/';
  $smarty->compile_dir  = dirname(__FILE__) .'/../templates_c/';

  $smarty->assign('urlencode', urlencode($meta["url"]) );
  return $smarty->fetch('result.tpl');
}

function errorPage($msg,$meta=false) {
  
  $smarty = new Smarty();
  $smarty->template_dir = dirname(__FILE__) .'/../templates/';
  $smarty->compile_dir  = dirname(__FILE__) .'/../templates_c/';

  $smarty->assign('title', readConfig("TITLE"));
  $smarty->assign('msg',$msg);
  
  $table = "";
  if($meta) {
    $table = _echoResultTable($meta);
  }
  $smarty->assign('infotable',$table);

  $smarty->display('errpage.tpl');
}
