<?php

require_once( 'zip.lib.php' );
require_once( dirname(__FILE__) . '/../fsutil.php' );


function pzip_dir($dir, $outputPath) {
  //openoutputfile
  $fp = fopen($outputPath,"wb");
  if($fp) {
    $zip = new ZipFile();
    $zip ->setDoWrite($fp);
    $targetFiles = find_files($dir);
    
    foreach($targetFiles as $path){
      $data = file_get_contents($path);
      $storePath = substr($path, strlen($dir));
      $storePath = preg_replace('/^\/*/i','',$storePath);
      $storePath = basename($dir) . '/' . $storePath;
      
      //拡張子により圧縮モードを切り替える
      $pinfo = pathinfo($path);
      $compress = true;
      if(in_array(strtolower($pinfo['extension']), 
                  array('jpg','png','gif','zip','gz') ))
      {
        $compress = false;
      }
      
      //uncompress
      $zip->addFile($data,$storePath,filemtime($path),$compress);
    }
    $zip->file(); //write header
    
    fclose($fp);
  }
}

//*
function pzip_stdout_writer($arg, $data) {
  print $data;
  ob_flush();
  flush();
}
/*/
function pzip_stdout_writer($arg, $data) {
  if (ini_get('mbstring.func_overload') & 2 && function_exists('mb_strlen')) {
    $size = mb_strlen($data, 'ASCII');
  } else {
    $size = strlen($data);
  }
  
  $blocksize = 4096;
  $ptr = 0;
  
  while($ptr < $size) {
    $readlen = min($size, $ptr+$blocksize) - $ptr;
    $putdata = substr($data, $ptr, $readlen);
    $ptr += $readlen;
    
    print $putdata;
    ob_flush();
    flush();
  }
  
}
//*/

function pzip_list_stdout($dir, $targetFiles=FALSE) {
  $zip = new ZipFile();
  $zip ->setDoWrite('dummy', 'pzip_stdout_writer');
  
  if( $targetFiles==FALSE ) {
    $targetFiles = find_files($dir);
  }
  
  foreach($targetFiles as $path){
    $data = file_get_contents($path);
    $storePath = substr($path, strlen($dir));
    $storePath = preg_replace('/^\/*/i','',$storePath);
    $storePath = basename($dir) . '/' . $storePath;
    
    //拡張子により圧縮モードを切り替える
    $pinfo = pathinfo($path);
    $compress = true;
    if(in_array(strtolower($pinfo['extension']), 
                array('jpg','png','gif','zip','gz') ))
    {
      $compress = false;
    }
    
    //uncompress
    $zip->addFile($data,$storePath,filemtime($path),$compress);
  }
  $zip->file(); //write header
}

//---------------------------------------------------------
//unzip


/**
* Unzip the source_file in the destination dir
*
* @param   string      The path to the ZIP-file.
* @param   string      The path where the zipfile should be unpacked, if false the directory of the zip-file is used
* @param   boolean     Indicates if the files will be unpacked in a directory with the name of the zip-file (true) or not (false) (only if the destination directory is set to false!)
* @param   boolean     Overwrite existing files (true) or not (false)
* 
* @return  boolean     Succesful or not
*/

/*******************************************************************
// Extract C:/zipfiletest/zip-file.zip to C:/zipfiletest/zip-file/ and overwrites existing files
unzip("C:/zipfiletest/zip-file.zip", false, true, true);

// Extract C:/zipfiletest/zip-file.zip to C:/another_map/zipfiletest/ and doesn't overwrite existing files. NOTE: It doesn't create a map with the zip-file-name!
unzip("C:/zipfiletest/zip-file.zip", "C:/another_map/zipfiletest/", true, false);

*******************************************************************/


function unzip($src_file, $dest_dir=false, $create_zip_name_dir=true, $overwrite=true)
{
  if ( !extension_loaded ("zip") ){
    return false;
  }

  if ($zip = zip_open($src_file))
  {
    if ($zip)
    {
      $splitter = ($create_zip_name_dir === true) ? "." : "/";
      if ($dest_dir === false) $dest_dir = substr($src_file, 0, strrpos($src_file, $splitter))."/";
     
      // Create the directories to the destination dir if they don't already exist
      create_dirs($dest_dir);

      // For every file in the zip-packet
      while ($zip_entry = zip_read($zip))
      {
        // Now we're going to create the directories in the destination directories
       
        // If the file is not in the root dir
        $pos_last_slash = strrpos(zip_entry_name($zip_entry), "/");
        if ($pos_last_slash !== false)
        {
          // Create the directory where the zip-entry should be saved (with a "/" at the end)
          create_dirs($dest_dir.substr(zip_entry_name($zip_entry), 0, $pos_last_slash+1));
        }

        // Open the entry
        if (zip_entry_open($zip,$zip_entry,"r"))
        {
         
          // The name of the file to save on the disk
          $file_name = $dest_dir.zip_entry_name($zip_entry);
         
          // Check if the files should be overwritten or not
          if ($overwrite === true || $overwrite === false && !is_file($file_name))
          {
            // Get the content of the zip entry
            $fstream = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));

            file_put_contents($file_name, $fstream );
            // Set the rights
            chmod($file_name, 0777);
            //echo "save: ".$file_name."<br />";
          }
         
          // Close the entry
          zip_entry_close($zip_entry);
        }      
      }
      // Close the zip-file
      zip_close($zip);
    }
  }
  else
  {
    return false;
  }
 
  return true;
}



