<?php

/**
 * key毎にスレッド情報ファイルを生成し格納するkvs
 *
 * windows+php4環境で動作するが
 * 一覧処理がとにかく苦手で性能が出ない
 * 0.6.20以降はchunkfileが利用されデータ読み取りのためだけに利用
**/

class DBA_Flatfile{

  function DBA_Flatfile($mode)
  {
  }

  function close()
  {
  }

  function optimize(){}

  function get($key)
  {
    $basenames = urlToBasename($key);
    $metaPath = readConfig("METADIR") . $basenames["META"];
    if(is_file($metaPath)){
      $json = file_get_contents($metaPath);
      $info = $this->_unserialize($json) ;
      if($this->_check_info($info)){
        return $info;
      }else{
        //リカバリ処理
        if($info = $this->_recovery_info($key)){
          $this->set($key, $info);
        }
        return $info;
      }
    }else{
      return FALSE;
    }
  }

  function set($key, $value)
  {
    $basenames = urlToBasename($key);
    $jsonname = readConfig("METADIR") . $basenames["META"];
    file_put_contents($jsonname, $this->_serialize($value));
  }

  function del($key)
  {
    $basenames = urlToBasename($key);
    $target = readConfig("METADIR") . $basenames["META"];
    if(file_exists($target)){unlink($target);}
  }

  function exists($key)
  {
    $basenames = urlToBasename($key);
    $metaPath = readConfig("METADIR") . $basenames["META"];
    return is_file($metaPath);
  }

  function allKeys()
  {
    $keys = array();
    $suffix = metaFileSfx();
    if ($dir = opendir(readConfig("METADIR"))){
      while ($fbase = readdir($dir)){
        $file = readConfig("METADIR") . $fbase;

        //拡張子のチェック
        $pinfo = pathinfo($file);
        $ext = "." . get_value($pinfo,'extension',"");
        if($ext != $suffix || !is_file($file)) {
          continue;
        }

        $keys[] = "http://". str_replace("_","/", str_replace($ext,".htm",$fbase));
      }
    }
    return $keys;
  }

  function allValues()
  {
    $keys = $this->allKeys();

    $infos = array();
    $infosSort = array();

    foreach($keys as $key){
      $info = $this->get($key);
      //if(is_array($info) && array_key_exists("url",$info) && strlen($info["url"]) > 0) {
        $infos[] = $info;
        $infosSort[] = $info["date"];
      //}
    }
    array_multisort($infosSort, SORT_DESC, $infos);

    return $infos;
  }

  //private:==========================================

  function _unserialize($data) {
    return unserialize($data);
  }

  function _serialize($data) {
    return serialize($data);
  }

  function _check_info($info){
    return is_array($info) && array_key_exists("url",$info) && strlen($info["url"]) > 0;
  }

  function _recovery_info($key)
  {
    //metaデータの復元(再作成)を試みる
    if(!function_exists("makeMetaInfo")){echo "notexists makeMetaInfo"; return false;}

    //index.htmを読む
    $basenames = urlToBasename($key);
    $indexpath = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_INDEX_PAGE_;

    $info = false;

    $html = "";
    //加工前のhtml(gz版)を優先的に読み込む
    
    if( is_file($indexpath) )
    {
      $html = @file_get_contents($indexpath);
    }
    //infoをhtmlから再作成
    if( strlen($html) > 0){
      log2file("DBA_Flatfile.php restoration log:".__LINE__.":". $key );
      $srcHtml = mb_convert_encoding($html, "UTF8", getEncoding());
      $info = makeMetaInfo($key, $srcHtml);
    }

    return $info;
  }


};
