<?php

/**
 * タグ追加用のスクリプト
 * 
 * param
 *  url     スレッドのurl
 *  retaddr 処理後に表示するページ
 *  tag     追加するtag(utf8)
 * 
**/


require_once 'config.php';
require_once 'phplib/common.php';
require_once 'blacklist.php';

//------------------------------------------------------------
//NGワード
$NGWORDS = array(
  "あああ",
  "いいい",
  "ううう",
  "えええ",
  "おおお",
  "っっっ",
);

//タグ名の上限サイズ(utf8でのバイト数)
$TAGMAXLEN = 40;

//スレッドあたりのタグの個数上限
$TAGMAXCNT = 5;

//------------------------------------------------------------
$GETURL = get_value($_REQUEST,"url");
$RETADDR = get_value($_REQUEST,"retaddr");
$TAGSRC = get_value($_REQUEST,"tag","");
$METHOD = get_value($_REQUEST,"method","add");
$ADDTAG = $TAGSRC; 

//htmlエスケープ
$ADDTAG = htmlspecialchars($ADDTAG);

$hasng = FALSE;
foreach($NGWORDS as $ngword) {
  if( strpos( $TAGSRC , $ngword) !== FALSE){
    $hasng = TRUE;
  }
}

$meta = readUrlInfo($GETURL);

if($METHOD == "add"){
  if( !isWriteBlockHost(getClientIp())
   && strlen($TAGSRC) > 0
   && strlen($TAGSRC) < $TAGMAXLEN
   && count($meta['tags']) < $TAGMAXCNT
   && $hasng == FALSE )
  {
    //タグ追加
    if(addtag($GETURL,$ADDTAG)){
      if(readConfig("BAYESIANTAG")){
        require_once 'phplib/analyze/naivebayes_cache.php';
        $bayes = new NaiveBayesCache();
        $bayes->train($ADDTAG,$meta["res"],$meta["url"]);
        $bayes->close(); 
      }
    }
  }else{
    header("HTTP/1.1 402 Payment Required");
  }
}else if($METHOD == "del"){
  //タグ削除
  deltag_owner($GETURL,$ADDTAG);
}

//ページへ移動
if($RETADDR){
  header('Location: ' . $RETADDR);
}
