<?php

/**
 * スレッド登録等のブラックリストを定義する
 *
 *
 *
**/

require_once 'config.php';
require_once 'phplib/common.php';

/**
 * 指定されたipがブラックリストの場合trueを返す
 * 
**/
function isWriteBlockHost($ip) {
  
  //ブラックリスト(サンプル)
  //php向けの正規表現で記載する
  $blacklist = array(
    "/nns_.*!.*QIRC-4rCw6@.*/i",  // irc系
    "/Xecty_.*!.*@.*/i",          // tor系
    "/.*\.packetix\.net/i",       // 公開vpn(packetx)
    "/vpn.*opengw.net/i",         // 公開vpn(vpngate)
  );

  $host = gethostbyaddr($ip);
  
  foreach($blacklist as $pattern) {
    if(preg_match($pattern, $host) == 1) {
      return TRUE;
    }
  }
  
  return FALSE;
}

