/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "futaba.h"
#include "dirview.h"
#include "thumbnail.h"
#include "eel-graphic-effects.h"

#define THUMBNAIL_WIDTH 96
#define THUMBNAIL_HEIGHT 96
#define THUMBNAIL_SPACE 8

gint thumbwin_width;
gint thumbwin_height;
/*
 *----------------------------------------------------------------
 *        Thumbnail
 *----------------------------------------------------------------
 */
static gboolean cb_enter(GtkWidget *wg, GdkEventCrossing *event, gpointer data);
FbThumbnail *fb_thumbnail_new(gchar *path);

static gboolean
cb_enter(GtkWidget *wg,
	 GdkEventCrossing *event,
	 gpointer data)
{
	g_print("enter\n");

	return TRUE;
}

FbThumbnail *
fb_thumbnail_new(gchar *path)
{
	gint width, height;
	gchar *tmp, *name, *frame_path;
	GdkColor black = {0, 0, 0, 0};
	GdkPixbuf *pixbuf = NULL, *src_pixbuf, *frame_pixbuf;
	PangoLayout *layout;
	PangoRectangle *rect = g_new0(PangoRectangle, 1);
	GtkWidget *eventbox, *image, *label;
	FbThumbnail *thumb;

	/* FIX ME (how to load pixbuf) */
	/*   pixbuf = gdk_pixbuf_new_from_file(path, NULL); */
	src_pixbuf = gdk_pixbuf_new_from_file_at_size(path, THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT, NULL);
	/* END */
	if (!src_pixbuf) {
		g_free(path);
		return NULL;
	}

	frame_path = g_strconcat(ICONDIR, "/thumbnail_frame.png", NULL);
	frame_pixbuf = gdk_pixbuf_new_from_file(frame_path, NULL);
	if (frame_pixbuf) {
		pixbuf = eel_embed_image_in_frame(src_pixbuf, frame_pixbuf, 3, 3, 6, 6);
		gdk_pixbuf_unref(frame_pixbuf);
	}

	if (GDK_IS_PIXBUF(pixbuf))
		gdk_pixbuf_unref(src_pixbuf);
	else
		pixbuf = src_pixbuf;

	/*   width = gdk_pixbuf_get_width(pixbuf); */
	/*   height = gdk_pixbuf_get_height(pixbuf); */

	/*   if ((THUMBNAIL_WIDTH < width) && (THUMBNAIL_HEIGHT < height)) */
	/*     { */
	/*       gdk_pixbuf_unref(pixbuf);  */
	/*       pixbuf = gdk_pixbuf_new_from_file_at_size(path, THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT, NULL); */
	/*       GdkPixbuf *new; */

	/*       width = THUMBNAIL_WIDTH; */
	/*       height = THUMBNAIL_HEIGHT * ((gfloat)THUMBNAIL_WIDTH / (gfloat)gdk_pixbuf_get_width(pixbuf)); */
	/*       if (THUMBNAIL_HEIGHT < height) */
	/* 	{ */
	/* 	  height = THUMBNAIL_HEIGHT; */
	/* 	  width = THUMBNAIL_WIDTH * ((gfloat)THUMBNAIL_HEIGHT / (gfloat)gdk_pixbuf_get_height(pixbuf)); */
	/* 	} */
	/*       g_print("width %d height %d\n", width, height); */
	/*       new = gdk_pixbuf_scale_simple(pixbuf, width, height, GDK_INTERP_NEAREST); */
	/*       gdk_pixbuf_unref(pixbuf); */
	/*       pixbuf = new; */
	/*     } */

	thumb = g_new0(FbThumbnail, 1);

	/*   eventbox = gtk_event_box_new(); */
	/*   g_signal_connect(G_OBJECT(eventbox), "enter-notify-event", */
	/* 		   G_CALLBACK(cb_enter), thumb); */
	/*   gtk_widget_show(eventbox); */

	image = gtk_image_new_from_pixbuf(pixbuf);
	/*   gtk_widget_modify_fg(eventbox, GTK_STATE_PRELIGHT, &black); */
	/*   gtk_container_add(GTK_CONTAINER(eventbox), image); */
	gtk_widget_show(image);

	tmp = g_path_get_basename(path);
	name = str_local_to_utf8(tmp);
	g_free(tmp);
	label = gtk_label_new(name);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	/*   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER); */
	/*   gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5); */
	/*   gtk_misc_set_padding(GTK_MISC(label), 0, 0); */
	gtk_widget_set_size_request(label, THUMBNAIL_WIDTH, -1);
	gtk_widget_show(label);
	g_free(name);

	layout = gtk_label_get_layout(GTK_LABEL(label));
	pango_layout_get_pixel_extents(layout, rect, NULL);
	/*   pango_layout_set_wrap(layout, PANGO_WRAP_WORD_CHAR); */
	/*   pango_layout_context_changed(layout); */
	/*   gtk_widget_queue_resize(label); */

	if (rect->width > THUMBNAIL_WIDTH) {
		/*       gtk_widget_set_size_request(label, THUMBNAIL_WIDTH, -1); */
		/*       gtk_label_set_line_wrap(GTK_LABEL(label), TRUE); */
		/*       pango_layout_set_width(layout, THUMBNAIL_WIDTH); */
		/*       pango_layout_set_wrap(layout, PANGO_WRAP_WORD_CHAR); */
		/*       gtk_widget_queue_resize(label); */
	}
	/*   g_print("width: %d name %s\n", rect->width, base); */

	/* set member */
	thumb->image = image;
	thumb->label = label;
	thumb->path = g_strdup(path);
	thumb->width = gdk_pixbuf_get_width(pixbuf);
	thumb->height = gdk_pixbuf_get_height(pixbuf);
	thumb->label_width = rect->width;
	thumb->label_height = rect->height;

	gdk_pixbuf_unref(pixbuf);
	g_free(rect);

	return thumb;
}

void
fb_thumbnail_free(FbThumbnail *thumb)
{
	g_return_if_fail(thumb != NULL);

	gtk_widget_destroy(thumb->image);
	gtk_widget_destroy(thumb->label);
	g_free(thumb->path);
	g_free(thumb);
}
/*
 *----------------------------------------------------------------
 *        Thumbnail Window
 *----------------------------------------------------------------
 */
static gboolean cb_focus_in(GtkWidget *wg, GdkEventFocus *event, gpointer data);
static void cb_size(GtkWidget *top, GtkAllocation *alloc, gpointer data);
static void cb_destroy(GtkObject *obj, gpointer data);
FbThumbWin *fb_thumbwin_new(Futaba *futaba);
void fb_thumbwin_set(FbThumbWin *thumbwin, GList *path_list);
void fb_thumbwin_destroy(FbThumbWin *thumbwin);

static gboolean
cb_focus_in(GtkWidget *wg,
	    GdkEventFocus *event,
	    gpointer data)
{
	Futaba *futaba = data;

	futaba->thumbwin = g_object_get_data(G_OBJECT(wg), "ThumbWin");

	return TRUE;
}

static void
cb_size(GtkWidget *top,
	GtkAllocation *alloc,
	gpointer data)
{
	thumbwin_width = alloc->width;
	thumbwin_height = alloc->height;
}

static void cb_destroy(GtkObject *obj,
		       gpointer data)
{
	Futaba *futaba = data;

	fb_thumbwin_end(futaba);
}

FbThumbWin *
fb_thumbwin_new(Futaba *futaba)
{
	GdkPixbuf *pixbuf;
	GdkPixmap *pixmap;
	GtkWidget *top, *scrolled, *layout;
	FbThumbWin *thumbwin;

	thumbwin = g_new0(FbThumbWin, 1);

	top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size(GTK_WINDOW(top), thumbwin_width, thumbwin_height);
	gtk_window_set_title(GTK_WINDOW(top), "Thumbnail - Futaba");
	g_object_set_data(G_OBJECT(top), "ThumbWin", thumbwin);
	g_signal_connect(G_OBJECT(top), "focus-in-event",
			 G_CALLBACK(cb_focus_in), futaba);
	g_signal_connect(G_OBJECT(top), "size-allocate",
			 G_CALLBACK(cb_size), NULL);
	g_signal_connect(G_OBJECT(top), "destroy",
			 G_CALLBACK(cb_destroy), futaba);
	gtk_widget_show(top);

	scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolled),
					    GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
				       GTK_POLICY_NEVER,
				       GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(top), scrolled);
	gtk_widget_show(scrolled);

	layout = gtk_layout_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled), layout);
	gtk_widget_show(layout);

	/* set background */
	pixbuf = gdk_pixbuf_new_from_file(ICONDIR"/cork.png", NULL);
	if (pixbuf) {
		pixmap = gdk_pixmap_new( GTK_LAYOUT(layout)->bin_window,
					 gdk_pixbuf_get_width(pixbuf),
					 gdk_pixbuf_get_height(pixbuf),
					 -1);
		gdk_draw_pixbuf(pixmap, NULL, pixbuf,
				0, 0, 0, 0, -1, -1, 
				GDK_RGB_DITHER_NONE,
				0, 0);
		gdk_pixbuf_unref(pixbuf);
		gdk_window_set_back_pixmap(GTK_LAYOUT(layout)->bin_window, pixmap, FALSE);
		gdk_pixmap_unref(pixmap);
	}
	else {
		GdkColor white = {0, 65535, 65535, 65535};

		gtk_widget_modify_bg(layout, GTK_STATE_NORMAL, &white);
	}

	/* set member */
	thumbwin->top = top;
	thumbwin->scrolled = scrolled;
	thumbwin->layout = layout;
	thumbwin->thumb_list = NULL;
	thumbwin->width = thumbwin_width;
	thumbwin->height = thumbwin_height;

	return thumbwin; 
}

void
fb_thumbwin_set(FbThumbWin *thumbwin,
		GList *path_list)
{
	gint i, n;
	gint win_width, win_height, add_height;
	gint x0, y0, space;
	gchar *path;
	FbThumbnail *thumb;

	g_return_if_fail(thumbwin != NULL);
	g_return_if_fail(path_list != NULL);

	win_width = thumbwin->top->allocation.width;
	win_height = thumbwin->top->allocation.height;
	n = win_width / (THUMBNAIL_WIDTH + THUMBNAIL_SPACE);

	add_height = 0;

	space = (win_width - THUMBNAIL_WIDTH * n) / (n + 1);
	x0 = THUMBNAIL_WIDTH / 2 + space;
	y0 = THUMBNAIL_HEIGHT / 2 + THUMBNAIL_SPACE;

	for (i = 0; path = g_list_nth_data(path_list, i); i++) {
		while (gtk_events_pending()) gtk_main_iteration();

		/* create thumbnail */
		thumb = fb_thumbnail_new(path);
		if (!thumb) continue;

		thumbwin->thumb_list = g_list_append(thumbwin->thumb_list, thumb);

		/* allocate thumbnail */
		gtk_layout_put(GTK_LAYOUT(thumbwin->layout), thumb->image,
			       x0 - (thumb->width / 2), y0 - (thumb->height / 2));
		gtk_layout_put(GTK_LAYOUT(thumbwin->layout), thumb->label,
			       x0 - (thumb->label_width / 2), y0 + (thumb->height / 2) + 3);

		add_height = MAX(add_height, ((THUMBNAIL_HEIGHT / 2) + (thumb->height / 2) + thumb->label_height + 3));
    
		x0 += THUMBNAIL_WIDTH + space;
		if (x0 >= win_width) {
			x0 = THUMBNAIL_WIDTH / 2 + space;
			y0 += add_height + THUMBNAIL_SPACE;
			add_height = 0;
		}

		if (y0 > win_height) gtk_layout_set_size(GTK_LAYOUT(thumbwin->layout), win_width, y0);
	}

	y0 += add_height;
	gtk_layout_set_size(GTK_LAYOUT(thumbwin->layout), win_width, y0);

	/*  if (x0 < win_width) */
	/*     gtk_layout_set_size(GTK_LAYOUT(thumbwin->layout), THUMBWIN_WIDTH, y0 + THUMBNAIL_HEIGHT + label_height + THUMBNAIL_SPACE); */
	/* shift containers */
	if (y0 > win_height) {
		gint x;
		GList *children;
		GtkWidget *child;

		space = 20 / (n + 1);
		children = gtk_container_get_children(GTK_CONTAINER(thumbwin->layout));
		for (i = 0; child = g_list_nth_data(children, i); i++) {
			gtk_container_child_get(GTK_CONTAINER(thumbwin->layout), child,
						"x", &x,
						NULL);
			x -= space;
			gtk_container_child_set(GTK_CONTAINER(thumbwin->layout), child,
						"x", x,
						NULL);
		}
	}
}

void
fb_thumbwin_destroy(FbThumbWin *thumbwin)
{
	gint i;
	GList *children;
	GtkWidget *child;
	FbThumbnail *thumb;

	/*   thumb = g_list_nth_data(thumbwin->thumb_list, 0); */
	/*   while (thumb = g_list_nth_data(thumbwin->thumb_list, 0)) */
	/*     { */
	/*       thumbwin->thumb_list = g_list_remove(thumbwin->thumb_list, thumb); */
	/*       fb_thumbnail_free(thumb); */
	/*     } */

	for (i = 0; thumb = g_list_nth_data(thumbwin->thumb_list, i); i++) {
		fb_thumbnail_free(thumb);
	}

	g_list_free(thumbwin->thumb_list);

	/*   children = gtk_container_get_children(GTK_CONTAINER(thumbwin->layout)); */
	/*   for (i = 0; child = g_list_nth_data(children, i); i++) */
	/*     gtk_widget_destroy(child); */

	gtk_widget_destroy(thumbwin->layout);
	gtk_widget_destroy(thumbwin->scrolled);
	gtk_widget_destroy(thumbwin->top);

	g_free(thumbwin);
}

void 
fb_thumbwin_start(Futaba *futaba)
{
	GList *path_list;
	FbThumbWin *thumbwin;

	thumbwin = fb_thumbwin_new(futaba);
	futaba->thumbwin = thumbwin;
	futaba->thumbwin_list = g_list_append(futaba->thumbwin_list, thumbwin);

	path_list = fb_dirview_get_path(futaba, IMAGE);
	fb_thumbwin_set(thumbwin, path_list);
	free_dir_entries(path_list);
}

void
fb_thumbwin_end(Futaba *futaba)
{
	gint i;

	if (!futaba->thumbwin) return;

	i = MAX(0, g_list_index(futaba->thumbwin_list, futaba->thumbwin) - 1);

	futaba->thumbwin_list = g_list_remove(futaba->thumbwin_list, futaba->thumbwin);
	fb_thumbwin_destroy(futaba->thumbwin);

	futaba->thumbwin = g_list_nth_data(futaba->thumbwin_list, i);
}
