/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DIALOG_H__
#define __DIALOG_H__

#define FB_TYPE_PROGRESS_DIALOG         (fb_progress_dialog_get_type())
#define FB_PROGRESS_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_PROGRESS_DIALOG, FbProgDialog))
#define FB_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_PROGRESS_DIALOG, FbProgDialogClass))
#define FB_IS_PROGRESS_DIALOG(obj)      (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_PROGRESS_DIALOG))
#define FB_IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_PROGRESS_DIALOG))
#define FB_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_PROGRESS_DIALOG, FbProgDialogClass))

typedef struct _FbProgDialog FbProgDialog;
typedef struct _FbProgDialogClass FbProgDialogClass;

struct _FbProgDialog
{
	GtkDialog dialog;

	GtkWidget *label;
	GtkWidget *message;
	GtkWidget *progress;

	gboolean interrupt;
};

struct _FbProgDialogClass
{
	GtkDialogClass parent_class;
};

GType fb_progress_dialog_get_type(void);
GtkWidget *fb_progress_dialog_new(gchar *text);
void fb_progress_dialog_set_label(FbProgDialog *dialog,
				  gchar *text);
void fb_progress_dialog_set_message(FbProgDialog *dialog,
				    gchar *text);
void fb_progress_dialog_set_progress(FbProgDialog *dialog,
				     gdouble fraction,
				     gchar *message);
/* other dialog */
GtkWidget *fb_about_dialog_new(GtkWidget *parent);
GtkWidget *fb_property_dialog_new(Futaba *futaba);
GtkWidget *fb_bulk_change_dialog_new(Futaba *futaba);
/* other function */
gboolean fb_rmdir_start(gchar *path);
gboolean fb_paste_start(Futaba *futaba,
			gchar *dest_path);

#endif /* __DIALOG_H__ */
