/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CANVAS_H__
#define __CANVAS_H__

GdkRectangle *fb_rectangle_copy(GdkRectangle *src);
gboolean fb_rectangle_diff(GdkRectangle *src, GdkRectangle *dest, GdkRectangle *harea, GdkRectangle *varea);
FbImageCanvas *fb_imagecanvas_new(GtkWidget *widget, gint x, gint y, gint width, gint height);
FbImageCanvas *fb_imagecanvas_new_from_file(GtkWidget *widget, gchar *path, gint x, gint y, gint width, gint height);
gboolean fb_imagecanvas_load_pixmap(FbImageCanvas *fic);
gboolean fb_imagecanvas_load_zoom(FbImageCanvas *fic);
gfloat fb_imagecanvas_calc_fit_scale(FbImageCanvas *fic);
void fb_imagecanvas_free(FbImageCanvas *fic);
void fb_imagecanvas_destroy(FbImageCanvas *fic);
void fb_imagecanvas_draw(FbImageCanvas *fic, GdkRectangle *draw_area);
void fb_imagecanvas_zooming(FbImageCanvas *fic, gfloat power);
void fb_imagecanvas_zoomfit(FbImageCanvas *fic);
void fb_imagecanvas_rotate(FbImageCanvas *fic, gboolean counter_clockwise);
void fb_imagecanvas_mirror(FbImageCanvas *fic, gboolean mirror, gboolean flip);
void fb_imagecanvas_move_image(FbImageCanvas *fic, gint x, gint y);

#endif /* __CANVAS_H__ */
