# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

__version__ = '1.1'

from ftg.flow_table import FlowTable
from ftg.flow_priority import FlowPriority
from ftg.flow_entry import FlowEntry
from ftg.utils.common import CommonUtils


class BaseFormatter(object):
    HEADER_FORMAT = ""
    FOOTER_FORMAT = ""
    formatter_name = "base"

    def __init__(self, util=CommonUtils(), title=""):
        self._tables = []
        self.util = util
        self._title = title
        self._groupid = 1
        self.output_summary = True
        self.output_resubmit_loop = True
        self.output_target_tables = []
        self.util.debug_out(self.formatter_name + " formatter initialized")

    def format(self):
        return "FORMATTED STRINGS"
    
    def get_header(self):
        header = self.HEADER_FORMAT
        return header

    def get_footer(self):
        footer = self.FOOTER_FORMAT
        return footer

    def set_tables(self, tables):
        self._tables = tables

    def set_output_target_tables(self, output_target_tables):
        if output_target_tables is not None:
            self.output_target_tables = output_target_tables

    def set_output_summary(self, output_summary):
        self.output_summary = output_summary

    def set_output_resubmit_loop(self, output_resubmit_loop):
        self.output_resubmit_loop = output_resubmit_loop
