# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from ftg.utils.common import CommonUtils
from ftg.parser.ovs_flow_dump import OVSFlowDumpParser
from ftg.parser.csv import CSVParser
from ftg.parser.tsv import TSVParser


class Grapher():
    DUMP_FILE_OVS = 1
    DUMP_FILE_CSV = 2
    DUMP_FILE_TSV = 3
    
    def __init__(self, util, dump_file, dump_file_type, formatter):
        self.util = util
        self.dump_file = dump_file
        self.dump_file_type = dump_file_type
        self.formatter = formatter

    def run(self):
        if self.dump_file_type == self.DUMP_FILE_OVS:
            parser = OVSFlowDumpParser(self.util, self.dump_file)
        elif self.dump_file_type == self.DUMP_FILE_CSV:
            parser = CSVParser(self.util, self.dump_file)
        elif self.dump_file_type == self.DUMP_FILE_TSV:
            parser = TSVParser(self.util, self.dump_file)
        else:
            util.error_out("specify flow file with -i or -c or -t option.")
            sys.exit(1)
            
        parser.parse()
        tables = parser.get_tables()
        self.formatter.set_tables(tables)
        for formatted_line in self.formatter.format():
            print formatted_line
