# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from ftg.flowobject import FlowObject


class FlowEntry(FlowObject):
    DEFAULT_TYPE = 1

    def __init__(self, match_exp, instructions=[], counter="", label="", type=DEFAULT_TYPE, metadata={}):
        self.match_exp = match_exp
        self.instructions = instructions
        self.counter = counter
        self.label = label
        self.type = type
        self.metadata = metadata

    def set_match_exp(self, match_exp):
        self.match_exp = match_exp

    def get_match_exp(self):
        return self.match_exp

    def set_instructions(self, instructions):
        self.instructions = instructions

    def get_instructions(self):
        return self.instructions

    def set_counter(self, counter):
        self.counter = counter

    def get_counter(self):
        return self.counter

    def __str__(self):
        return "\"" + self.match_exp + "\",\"" + ",".join(self.instructions) + "\""
