/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.PageActionEditor;
import com.ftinc.si.assist.test.web.PageAssistMenu;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.Caret;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebElementGetter
extends JDialog {
    private JTextArea m_target;
    protected JComboBox<String> m_params;
    private JLabel m_lblParams;
    private PageActionEditor m_owner;
    private WebDriver m_driver = null;
    private String m_driverName = null;
    private PageAction m_curAction = null;
    private ArrayList<WebElement> m_elms;
    private ArrayList<String> m_xpaths;
    private String[] m_elms_style;
    private int m_focusedPos = -1;
    protected Integer m_selectedRow = -1;
    private JTextField elmPosText;
    private JButton prevBtn;
    private JButton nextBtn;
    private static String s_elmByXpath = "function _elementAtXpath(path){return document.evaluate(path,document,null,XPathResult.FIRST_ORDERED_NODE_TYPE,null).singleNodeValue;}";
    private boolean paramReplaced;

    WebElementGetter(PageActionEditor owner) {
        super((Dialog)owner, false);
        this.setBackground(Color.GRAY);
        this.setResizable(false);
        this.m_owner = owner;
        int x = 100;
        int y = 100;
        int h = 205;
        if (owner != null) {
            x = owner.getX() + owner.getWidth();
            y = owner.getY();
            h = 180;
        }
        this.setBounds(x, y, 590, h);
        if (owner != null) {
            this.setUndecorated(true);
        }
        this.setTitle(String.valueOf(Messages.getString("WebElementGetter.0")) + "  (Copyright:Toyoaki Furusawa, 2017-)");
        this.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WebElementGetter.this.closing();
            }
        });
        final JComboBox<String> comboBrowsers = new JComboBox<String>();
        comboBrowsers.addItem("Chrome");
        comboBrowsers.addItem("IE");
        comboBrowsers.addItem("Firefox");
        comboBrowsers.setBounds(12, 10, 114, 19);
        this.getContentPane().add(comboBrowsers);
        final JButton openBrowser = new JButton(Messages.getString("WebElementGetter.5"));
        openBrowser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int n;
                if (WebElementGetter.this.m_driver == null && (n = comboBrowsers.getSelectedIndex()) >= 0) {
                    WebElementGetter.this.m_driverName = ((String)comboBrowsers.getItemAt(n)).toString();
                    WebElementGetter.this.m_driver = WebElementGetter.this.getDriver(WebElementGetter.this.m_driverName);
                    comboBrowsers.setEditable(false);
                    openBrowser.setEnabled(false);
                    if (WebElementGetter.this.m_selectedRow >= 0 && ((WebElementGetter)WebElementGetter.this).m_curAction.arg_map.get("url") == null) {
                        WebElementGetter.this.initTags();
                    }
                    PageAction.s_win_id = WebElementGetter.this.m_driver.getWindowHandle();
                }
            }
        });
        openBrowser.setBounds(131, 9, 91, 21);
        this.getContentPane().add(openBrowser);
        this.m_lblParams = new JLabel(Messages.getString("WebElementGetter.6"));
        this.m_lblParams.setBounds(12, 123, 67, 13);
        this.getContentPane().add(this.m_lblParams);
        JLabel lblElement = new JLabel(Messages.getString("WebElementGetter.7"));
        lblElement.setBounds(12, 36, 67, 13);
        this.getContentPane().add(lblElement);
        this.m_params = new JComboBox();
        this.m_params.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, WebElementGetter.this.m_params.getFont());
                if (t_font != null) {
                    WebElementGetter.this.m_params.setFont(t_font);
                }
            }
        });
        this.m_params.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object t_str;
                if ("comboBoxEdited".equals(e.getActionCommand()) && (t_str = WebElementGetter.this.m_params.getSelectedItem()) != null && t_str.toString().length() > 0) {
                    WebElementGetter.this.m_params.removeItem(t_str);
                    WebElementGetter.this.m_params.addItem(t_str.toString());
                }
            }
        });
        this.m_params.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object t_str = WebElementGetter.this.m_params.getSelectedItem();
                WebElementGetter.this.paramReplaced = false;
                if (t_str != null && t_str.toString().startsWith(Messages.getString("WebElementGetter.4"))) {
                    StringBuilder sb = new StringBuilder(t_str.toString());
                    if (WebElementGetter.this.m_curAction.modifyByKeyInput(e, sb)) {
                        WebElementGetter.this.m_params.setSelectedItem(sb);
                        WebElementGetter.this.paramReplaced = true;
                        e.consume();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (WebElementGetter.this.paramReplaced) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (WebElementGetter.this.paramReplaced) {
                    e.consume();
                }
            }
        });
        this.m_params.setBounds(91, 120, 487, 19);
        this.getContentPane().add(this.m_params);
        JButton btnSet = new JButton(Messages.getString("WebElementGetter.8"));
        btnSet.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WebElementGetter.this.m_selectedRow >= 0) {
                    if (WebElementGetter.this.m_target.getText().length() > 0) {
                        String str = WebElementGetter.this.makeActionsJson();
                        if (str.length() == 0) {
                            Tool.alertMSG(null, Messages.getString("WebElementGetter.2"));
                        } else {
                            String t_reg = Messages.getString("WebElementGetter.16");
                            if (WebElementGetter.this.m_params.isEditable()) {
                                t_reg = WebElementGetter.this.m_params.getSelectedItem().toString();
                            }
                            if (WebElementGetter.this.m_owner != null) {
                                WebElementGetter.this.m_owner.setArgumentAt(WebElementGetter.this.m_selectedRow, str, t_reg);
                            }
                        }
                    } else {
                        Tool.alertMSG(null, Messages.getString("WebElementGetter.1"));
                    }
                }
            }
        });
        btnSet.setBounds(253, 149, 91, 21);
        this.getContentPane().add(btnSet);
        if (this.m_owner == null) {
            btnSet.setEnabled(false);
        }
        JLabel lblMove = new JLabel(Messages.getString("WebElementGetter.9"));
        lblMove.setBounds(253, 13, 91, 13);
        this.getContentPane().add(lblMove);
        this.elmPosText = new JTextField();
        this.prevBtn = new JButton(Messages.getString("WebElementGetter.10"));
        this.nextBtn = new JButton(Messages.getString("WebElementGetter.11"));
        this.elmPosText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int t_key = e.getKeyCode();
                if (t_key == 10) {
                    if (!WebElementGetter.this.m_curAction.hasPath()) {
                        return;
                    }
                    String t_str = VCentral.pickNumber(WebElementGetter.this.elmPosText.getText());
                    if (t_str != null && t_str.length() > 0) {
                        Integer n = new Integer(t_str);
                        if (n < WebElementGetter.this.m_elms.size()) {
                            int prev_focus = WebElementGetter.this.m_focusedPos;
                            WebElementGetter.this.moveFocus(prev_focus, n);
                        }
                    } else {
                        WebElementGetter.this.elmPosText.setText(Integer.toString(WebElementGetter.this.m_elms.size() - 1));
                    }
                }
            }
        });
        this.elmPosText.setHorizontalAlignment(0);
        this.elmPosText.setText(Integer.toString(this.m_focusedPos));
        this.elmPosText.setBounds(425, 10, 74, 19);
        this.getContentPane().add(this.elmPosText);
        this.elmPosText.setColumns(10);
        this.prevBtn.setBounds(340, 9, 83, 21);
        this.getContentPane().add(this.prevBtn);
        this.prevBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WebElementGetter.this.m_selectedRow >= 0) {
                    if (!WebElementGetter.this.m_curAction.hasPath()) {
                        return;
                    }
                    if (WebElementGetter.this.m_focusedPos >= 0) {
                        WebElementGetter webElementGetter = WebElementGetter.this;
                        webElementGetter.m_focusedPos = webElementGetter.m_focusedPos - 1;
                        WebElementGetter.this.moveFocus(WebElementGetter.this.m_focusedPos + 1, WebElementGetter.this.m_focusedPos);
                    }
                }
            }
        });
        this.nextBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!WebElementGetter.this.m_curAction.hasPath()) {
                    return;
                }
                if (WebElementGetter.this.m_xpaths.size() > WebElementGetter.this.m_focusedPos) {
                    WebElementGetter webElementGetter = WebElementGetter.this;
                    webElementGetter.m_focusedPos = webElementGetter.m_focusedPos + 1;
                    WebElementGetter.this.moveFocus(WebElementGetter.this.m_focusedPos - 1, WebElementGetter.this.m_focusedPos);
                }
            }
        });
        this.nextBtn.setBounds(504, 9, 74, 21);
        this.getContentPane().add(this.nextBtn);
        JButton btnReadagain = new JButton(Messages.getString("WebElementGetter.22"));
        btnReadagain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WebElementGetter.this.moveFocus(WebElementGetter.this.m_focusedPos, -1);
                WebElementGetter.this.initTags();
                Object t_arg = WebElementGetter.this.m_params.getSelectedItem();
                if (WebElementGetter.this.m_xpaths.size() == 0 && t_arg != null && t_arg.toString().length() > 0) {
                    Tool.alertMSG(null, String.valueOf(Messages.getString("WebElementGetter.12")) + WebElementGetter.this.m_params.getSelectedItem().toString() + ".");
                }
            }
        });
        btnReadagain.setBounds(131, 149, 111, 21);
        this.getContentPane().add(btnReadagain);
        JButton btnPreview = new JButton(Messages.getString("WebElementGetter.23"));
        btnPreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WebElementGetter.this.m_target.setToolTipText("");
                PageAction t_act = (PageAction)Tool.getObjectfromJSON(null, WebElementGetter.this.m_owner.makeJsonAt(WebElementGetter.this.m_selectedRow, WebElementGetter.this.makeActionsJson()));
                t_act.arg_map.put(Messages.getString("WebElementGetter.17"), Messages.getString("WebElementGetter.18"));
                try {
                    ArrayList<String> res = t_act.doAction(WebElementGetter.this.m_driver);
                    if (t_act.assertable() && res != null && res.size() > 0) {
                        WebElementGetter.this.m_target.setToolTipText("RESULT = " + res.get(0));
                    }
                }
                catch (Exception e1) {
                    String t_msg = String.valueOf(Messages.getString("WebElementGetter.13")) + t_act.getClass().getSimpleName() + "\n";
                    t_msg = e1.getCause() != null ? String.valueOf(t_msg) + e1.getCause().getClass().getName() + " = " + e1.getCause().getMessage() : String.valueOf(t_msg) + e1.getClass().getName() + " = " + e1.getMessage();
                    t_msg = t_msg.replaceAll("_cssByXPath", Matcher.quoteReplacement("$x"));
                    Tool.alertMSG(null, t_msg);
                }
            }
        });
        btnPreview.setBounds(356, 149, 91, 21);
        this.getContentPane().add(btnPreview);
        if (this.m_owner == null) {
            btnPreview.setEnabled(false);
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(90, 36, 488, 74);
        this.getContentPane().add(scrollPane);
        this.m_target = new JTextArea();
        this.m_target.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, WebElementGetter.this.m_target.getFont());
                if (t_font != null) {
                    WebElementGetter.this.m_target.setFont(t_font);
                }
            }
        });
        this.m_params.setEditable(true);
        this.m_target.setEditable(true);
        this.m_target.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    WebElementGetter.this.goPopup(e);
                }
            }
        });
        this.m_target.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!(openBrowser.isEnabled() || e.getKeyChar() != '=' && e.getKeyChar() != '@')) {
                    WebElementGetter.this.popupCandidate(e);
                }
            }
        });
        scrollPane.setViewportView(this.m_target);
        this.m_target.setColumns(10);
        Font t_f = this.m_target.getFont();
        FontUIResource t_fres = new FontUIResource(t_f);
        UIManager.getLookAndFeelDefaults().put(Messages.getString("WebElementGetter.24"), t_fres);
    }

    private void moveFocus(int prev, int next) {
        if (prev != next && this.m_driver != null) {
            if (this.m_elms.size() == 1) {
                this.nextBtn.setEnabled(false);
                this.prevBtn.setEnabled(false);
            } else {
                this.nextBtn.setEnabled(true);
                this.prevBtn.setEnabled(true);
            }
            if (this.m_elms.size() == 0) {
                this.moveWindowFocus(next);
            } else {
                this.moveElementFocus(prev, next);
            }
        } else {
            this.moveElementFocus(prev, -1);
            this.elmPosText.setText("");
            this.nextBtn.setEnabled(false);
            this.prevBtn.setEnabled(false);
        }
    }

    private void moveWindowFocus(int next) {
        if (this.m_xpaths == null) {
            return;
        }
        if (next == 0) {
            this.prevBtn.setEnabled(false);
        } else if (next < 0) {
            this.m_focusedPos = -1;
            this.prevBtn.setEnabled(false);
            return;
        }
        if (this.m_xpaths.size() == next + 1) {
            this.nextBtn.setEnabled(false);
        } else if (next >= this.m_xpaths.size()) {
            this.m_focusedPos = this.m_xpaths.size();
            this.nextBtn.setEnabled(false);
            return;
        }
        this.m_focusedPos = next;
        this.m_driver.switchTo().window(this.m_xpaths.get(this.m_focusedPos));
        this.elmPosText.setText(String.valueOf(Integer.toString(this.m_focusedPos + 1)) + " / " + Integer.toString(this.m_xpaths.size()));
        this.m_target.setText("\"title\":\"" + Fson.escape(this.m_driver.getTitle()) + "\"");
        if (!this.m_curAction.assertable()) {
            this.m_params.setSelectedItem(this.m_xpaths.get(this.m_focusedPos));
        }
        if (this.m_focusedPos < this.m_xpaths.size() - 1) {
            this.nextBtn.setEnabled(true);
        }
        if (this.m_focusedPos > 0) {
            this.prevBtn.setEnabled(true);
        }
    }

    private void moveElementFocus(int prev, int next) {
        JavascriptExecutor jsexe = (JavascriptExecutor)this.m_driver;
        if (next == 0) {
            this.prevBtn.setEnabled(false);
        } else if (next < 0) {
            this.m_focusedPos = -1;
            if (prev >= 0) {
                this.setElementStyle(jsexe, prev, this.m_elms_style[prev]);
            }
            this.prevBtn.setEnabled(false);
            return;
        }
        if (this.m_elms.size() == next + 1) {
            this.nextBtn.setEnabled(false);
        } else if (next >= this.m_elms.size()) {
            this.m_focusedPos = this.m_elms.size();
            this.nextBtn.setEnabled(false);
            if (prev < this.m_elms.size()) {
                this.setElementStyle(jsexe, prev, this.m_elms_style[prev]);
            }
            return;
        }
        this.m_focusedPos = next;
        this.elmPosText.setText(String.valueOf(Integer.toString(next + 1)) + " / " + Integer.toString(this.m_elms.size()));
        WebElement t_elm2 = this.m_elms.get(next);
        this.setCurrentStringtoTarget(t_elm2);
        String t_src0 = "var _elm=_elementAtXpath(\"" + this.m_xpaths.get(next) + "\");if(_elm==null)return;";
        String t_src1 = "return _elm.style.border;";
        String t_src2 = "return _elm.style.backgroundColor;";
        String t_src3 = "_elementAtXpath(\"" + this.m_xpaths.get(next) + "\").scrollIntoView(false);";
        try {
            String t_style1 = (String)jsexe.executeScript(String.valueOf(s_elmByXpath) + t_src0 + t_src1, new Object[0]);
            String t_style2 = (String)jsexe.executeScript(String.valueOf(s_elmByXpath) + t_src0 + t_src2, new Object[0]);
            if (t_style1 == null || t_style1.length() <= 0) {
                t_style1 = "none";
            }
            if (t_style2 == null || t_style2.length() <= 0) {
                t_style2 = "transparent";
            }
            this.m_elms_style[next] = String.valueOf(t_style1) + "\t" + t_style2;
            if (prev >= 0 && prev < this.m_elms_style.length) {
                this.setElementStyle(jsexe, prev, this.m_elms_style[prev]);
            }
            this.setElementStyle(jsexe, next, "thick solid red\tred");
            jsexe.executeScript(String.valueOf(s_elmByXpath) + t_src3, new Object[0]);
        }
        catch (Exception e) {
            String t_msg = e.getCause() != null ? String.valueOf(e.getCause().getClass().getName()) + " = " + e.getCause().getMessage() : String.valueOf(e.getClass().getName()) + " = " + e.getMessage();
            if (e.getMessage() != null && e.getMessage().startsWith("_elementAtXpath")) {
                t_msg = Messages.getString("WebElementGetter.15");
            }
            Tool.alertMSG(null, "Exception>> " + t_msg);
        }
    }

    private void setElementStyle(JavascriptExecutor jsexe, int n, String style) {
        if (style == null) {
            return;
        }
        String[] t_style = style.split("\t");
        String t_src0 = "var _elm=_elementAtXpath(\"" + this.m_xpaths.get(n) + "\");if(_elm==null)return;_elm.removeAttribute('readonly');";
        String t_src1 = "_elm.style.border=\"";
        jsexe.executeScript(String.valueOf(s_elmByXpath) + t_src0 + t_src1 + t_style[0] + "\";", new Object[0]);
        String t_src2 = "_elm.style.backgroundColor=\"";
        jsexe.executeScript(String.valueOf(s_elmByXpath) + t_src0 + t_src2 + t_style[1] + "\";", new Object[0]);
    }

    private void setCurrentStringtoTarget(WebElement elm) {
        if (this.m_curAction.hasPath()) {
            String t_target = this.m_target.getText();
            String next_str = this.m_xpaths.get(this.m_focusedPos);
            Pattern t_pat1 = Pattern.compile("([,\\(\\s]xpath=\")([^\"]*)\"");
            Matcher t_m = t_pat1.matcher(t_target);
            if (t_m.find()) {
                String tstr1 = t_m.group(1);
                t_target = t_m.replaceFirst(Matcher.quoteReplacement(String.valueOf(tstr1) + next_str + "\""));
                this.m_target.setText(t_target);
            } else {
                Pattern t_pat2 = Pattern.compile("\"xpath\":\"([^\"]*)\"");
                t_m = t_pat2.matcher(t_target);
                if (t_m.find()) {
                    t_target = t_m.replaceFirst(Matcher.quoteReplacement("\"xpath\":\"" + next_str + "\""));
                    this.m_target.setText(t_target);
                } else {
                    String t_path = this.getFocussingPath(elm);
                    this.m_target.setText(t_path);
                }
            }
        }
    }

    private WebDriver getDriver(String bname) {
        FirefoxDriver drv = null;
        try {
            if (bname.equals("Firefox")) {
                drv = new FirefoxDriver();
            } else if (bname.equals("IE")) {
                DesiredCapabilities ieCap = DesiredCapabilities.internetExplorer();
                ieCap.setCapability("ignoreProtectedModeSettings", true);
                drv = new InternetExplorerDriver((Capabilities)ieCap);
            } else if (bname.equals("Chrome")) {
                drv = new ChromeDriver();
            }
        }
        catch (Throwable e) {
            Tool.alertMSG(null, e.getMessage());
            if (drv != null) {
                drv.quit();
            }
            return null;
        }
        return drv;
    }

    protected void initParams(int n, PageAction act, String assertStr) {
        this.moveFocus(this.m_focusedPos, -1);
        this.m_target.setToolTipText("");
        this.m_selectedRow = n;
        this.m_curAction = act;
        this.m_params.removeAllItems();
        ArrayList<String> t_candidates = act.getLabelAndParams();
        if (t_candidates != null && t_candidates.size() > 0) {
            this.m_params.setEditable(true);
            this.m_lblParams.setText(t_candidates.get(0));
            int i = 1;
            while (i < t_candidates.size()) {
                this.m_params.removeItem(t_candidates.get(i));
                this.m_params.addItem(t_candidates.get(i));
                ++i;
            }
        } else {
            this.m_lblParams.setText("");
            this.m_params.setEditable(false);
        }
        if (assertStr != null && assertStr.length() > 0) {
            String t_val = (String)act.arg_map.get(Messages.getString("WebElementGetter.25"));
            this.m_params.removeItem(t_val);
            this.m_params.addItem(t_val);
            this.m_params.setSelectedItem(t_val);
        }
        String t_target = act.getTarget();
        this.m_target.setText(t_target);
        this.m_focusedPos = -1;
    }

    private String makeActionsJson() {
        String t_param = Messages.getString("WebElementGetter.26");
        if (this.m_params.isEditable()) {
            t_param = this.m_params.getSelectedItem().toString();
        }
        String t_result = "";
        String t_json = this.m_target.getText();
        Pattern t_pat = Pattern.compile("^([^\"]+)\":\"([^\"]+)");
        Matcher t_m = t_pat.matcher(t_json);
        while (t_m.find()) {
            if (t_result.length() <= 0) continue;
            t_result = String.valueOf(t_result) + ",";
            t_result = String.valueOf(t_result) + "\"" + t_m.group(1) + "\":\"" + Fson.escape(t_m.group(2)) + "\"";
        }
        return this.m_curAction.getJsonElement(t_result, t_param);
    }

    private String getFocussingPath(WebElement elm) {
        String t_json = "";
        this.m_curAction.arg_map.put("xpath", this.m_xpaths.get(this.m_focusedPos));
        for (Map.Entry<String, Object> entry : this.m_curAction.arg_map.entrySet()) {
            if (t_json.length() > 0) {
                t_json = String.valueOf(t_json) + ",";
            }
            t_json = String.valueOf(t_json) + "\"" + entry.getKey() + "\":\"" + entry.getValue() + "\"";
        }
        return t_json;
    }

    private String getKeyWordForPath() {
        String t_str = this.m_target.getText();
        if (t_str.length() > 0) {
            Pattern t_pat = Pattern.compile("\\(.*xpath=\"([^\"]+)\".*\\)\\s*\\->");
            Matcher t_m = t_pat.matcher(t_str);
            if (t_m.find()) {
                String t_path = t_m.group(1);
                return t_path;
            }
            Pattern t_pat2 = Pattern.compile("^\\s*(\\(|/).*$");
            t_m = t_pat2.matcher(t_str);
            if (t_m.find()) {
                return t_str;
            }
            Pattern t_pat3 = Pattern.compile("^\\s*\"xpath\":\"([^\"]+)\".*$");
            t_m = t_pat3.matcher(t_str);
            if (t_m.find()) {
                return t_m.group(1);
            }
        }
        return null;
    }

    private String currentPointedWord() {
        String xstr = this.m_target.getText();
        int pos = this.m_target.getCaretPosition();
        String part1_str = xstr.substring(0, pos);
        Pattern t_pat1 = Pattern.compile("^[\\s\\S]+\"([^\"]*)$");
        Matcher t_m = t_pat1.matcher(part1_str);
        if (t_m.find()) {
            String t_key = t_m.group(1);
            return t_key;
        }
        return part1_str;
    }

    protected boolean initTags() {
        ArrayList<WebElement> el_list = new ArrayList<WebElement>();
        ArrayList<String> xp_list = new ArrayList<String>();
        this.nextBtn.setEnabled(false);
        this.prevBtn.setEnabled(false);
        String xpath = this.getKeyWordForPath();
        boolean t_result = false;
        try {
            if (this.m_curAction == null) {
                this.m_curAction = new PageAction();
                this.m_selectedRow = 0;
            }
            t_result = this.m_curAction.getFocussingElements(this.m_driver, el_list, xp_list, xpath);
        }
        catch (Throwable e) {
            Tool.alertMSG(null, e.getMessage());
        }
        if (!t_result) {
            return false;
        }
        if (xp_list.size() > 0) {
            this.m_elms = el_list;
            this.m_xpaths = xp_list;
            this.m_elms_style = new String[el_list.size()];
        } else {
            this.m_elms = null;
            this.m_xpaths = null;
            this.m_elms_style = null;
        }
        if (this.m_curAction.hasPath()) {
            if (this.m_xpaths != null) {
                this.moveFocus(this.m_focusedPos, this.m_xpaths.size() - 1);
            } else {
                this.moveFocus(this.m_focusedPos, -1);
            }
        } else {
            if (this.m_xpaths != null) {
                this.elmPosText.setText(Integer.toString(this.m_xpaths.size()));
            } else {
                this.elmPosText.setText("");
            }
            this.m_target.setText(this.m_curAction.getTarget());
        }
        return true;
    }

    protected void closing() {
        if (this.m_driver != null) {
            this.m_driver.quit();
            this.m_driver = null;
        }
    }

    private void popupCandidate(KeyEvent e) {
        Caret tc = this.m_target.getCaret();
        Point op = this.m_target.getLocationOnScreen();
        Point pt = tc.getMagicCaretPosition();
        Point pos = new Point(op.x + pt.x, op.y + pt.y);
        String t_src = this.currentPointedWord();
        final PageAssistMenu _popup = new PageAssistMenu(this, this.m_driver, e.getKeyChar(), t_src, pos);
        if (_popup.countCandidate() > 0) {
            _popup.setVisible(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebElementGetter.this.insertAtCaret(_popup.m_answer);
                }
            });
        }
    }

    public void insertAtCaret(String str_answer) {
        if (str_answer != null) {
            int pos = this.m_target.getCaretPosition();
            String t_result = this.m_target.getText();
            String part1_str = t_result.substring(0, pos);
            String part2_str = t_result.substring(pos);
            int len = part1_str.length();
            if (str_answer.matches("^.*\t.+")) {
                String t_attr = str_answer.replaceFirst("^.+\t.+:(.+)$", "$1");
                if (!(str_answer = str_answer.replaceFirst("^(.+)\t.+$", "$1")).contains(":")) {
                    str_answer = " " + str_answer + " ";
                }
                String match_str = Matcher.quoteReplacement("contains(concat(' ',normalize-space(@" + t_attr + "),' '), '" + str_answer + "')]");
                part1_str = part1_str.replaceFirst("^([\\s\\S]+)@" + t_attr + "=$", "$1" + match_str);
                len = part1_str.length() - str_answer.length();
                t_result = String.valueOf(part1_str) + part2_str;
            } else if (part1_str.endsWith("=")) {
                t_result = String.valueOf(part1_str) + "'" + str_answer + "']" + part2_str;
                len += 3;
            } else {
                t_result = String.valueOf(part1_str) + str_answer + part2_str;
            }
            this.m_target.setText(t_result);
            this.m_target.setCaretPosition(len + str_answer.length());
        }
    }

    private void goPopup(MouseEvent e) {
        JPopupMenu t_pop = this.m_curAction.getPopup(this, this.m_target.getText());
        if (t_pop != null) {
            t_pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void setTargetFromPopup(String str) {
        if (str != null) {
            this.m_target.setText(str);
        }
    }

    public void registerTargetFromPopup(String cname, String templateString) {
        String str = JOptionPane.showInputDialog(this, Messages.getString("WebElementGetter.3"), "js_");
        if (str != null) {
            int t_res;
            if (str.matches("^[\\s\\S]*[\\(\\)][\\s\\S]*$")) {
                Tool.alertMSG(null, Messages.getString("WebElementGetter.14"));
                return;
            }
            JSONRecord t_j = JSONRecord.getJSONRec(cname, str);
            if (t_j == null) {
                t_j = new JSONRecord(2);
                t_j.name = str;
                t_j.className = cname;
                t_j.content = templateString;
                t_j.fields = "";
            } else {
                t_j.content = templateString;
                t_j.fields = Messages.getString("WebElementGetter.27");
                t_j.changed();
            }
            if (t_j != null && (t_res = JOptionPane.showConfirmDialog(this, String.valueOf(Messages.getString("WebElementGetter.19")) + str + Messages.getString("WebElementGetter.20"))) == 0) {
                try {
                    Tool._db().updateRecordBySQL(t_j.getUpdateSQL(), true);
                    JSONRecord.updatingJSONRec(t_j);
                    JOptionPane.showMessageDialog(null, Messages.getString("WebElementGetter.21"));
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, String.valueOf(Messages.getString("JSONEditor.9")) + e.getMessage());
                }
            }
        }
    }
}

