/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ArgumentIF;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.ArgumentEditor;
import com.ftinc.si.assist.test.gui.ClassReadDialog;
import com.ftinc.si.assist.test.gui.JSONEditor;
import com.ftinc.si.assist.test.gui.MethodEditor;
import com.ftinc.si.assist.test.gui.Plugin;
import com.ftinc.si.assist.test.gui.ReuseArguments;
import com.ftinc.si.assist.test.gui.TestCmdNode;
import com.ftinc.si.assist.test.gui.plugins.DefaultPlugin;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TestCaseEditor
extends JDialog {
    protected HashMap<Integer, TestCommandRecord> m_cmds;
    protected HashMap<String, ObjectRecord> obj_table;
    protected HashMap<Integer, AssertRecord> m_assert;
    protected ArrayList<Record> m_removings;
    private String m_desc;
    private int m_begin;
    private int m_end;
    private int m_nextid = 0;
    protected String m_include;
    private boolean m_loggable;
    private TestCmdNode m_root;
    private boolean m_isOK = false;
    private boolean hiddenMode;
    private DefaultTreeModel m_model;
    private JTree tree;
    protected TestCmdNode m_snapshot = null;
    private static String s_snap_sign = "\u3010\u25ceP\u3011";
    public static boolean unableMode = false;

    public TestCaseEditor(JFrame owner, TestCaseRecord tcase, boolean hMode) {
        super((Frame)owner, true);
        String t_group;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ClassReadDialog.s_owner = null;
                ArgumentEditor.s_owner = null;
                JSONEditor.s_owner = null;
                MethodEditor.s_owner = null;
            }
        });
        String t_target = tcase.groupCode;
        if (t_target == null) {
            t_target = "";
        }
        unableMode = (t_group = Tool.group_code) != null && t_group.length() > 0 ? !t_group.equals(t_target) : false;
        ClassReadDialog.s_owner = this;
        ArgumentEditor.s_owner = this;
        JSONEditor.s_owner = this;
        MethodEditor.s_owner = this;
        this.setResizable(false);
        t_target = t_target.length() > 0 ? "    edited by GroupCode=" + t_target : "    edited by GroupCode=NULL";
        this.setTitle(String.valueOf(Messages.getString("TestCaseEditor.0")) + t_target);
        this.m_cmds = new HashMap();
        this.obj_table = new HashMap();
        this.m_assert = new HashMap();
        this.m_removings = new ArrayList();
        this.hiddenMode = hMode;
        this.m_desc = tcase.description;
        this.m_begin = new Integer(tcase.begin);
        this.m_end = new Integer(tcase.end);
        this.m_loggable = new Boolean(tcase.loggable);
        this.m_include = tcase.include;
        this.getContentPane().setLayout(null);
        this.setBounds(owner.getX() + 100, owner.getY() + 100, 800, 500);
        this.m_root = this.makeTreeNodes(tcase);
        this.m_model = new DefaultTreeModel(this.m_root);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(0, 0, 784, 415);
        this.getContentPane().add(scrollPane);
        this.tree = new JTree(this.m_model);
        scrollPane.setViewportView(this.tree);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (SwingUtilities.isRightMouseButton(e) && !unableMode) {
                    TreePath path2 = TestCaseEditor.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path2 != null) {
                        TestCmdNode targetNode = (TestCmdNode)path2.getLastPathComponent();
                        if (targetNode.getNodeName().matches("^TestCase=.*$")) {
                            TestCaseEditor.this.goTestCasePopUp(targetNode, e);
                        } else if (targetNode.getNodeName().matches("^/*TestID=.*$")) {
                            TestCaseEditor.this.goTestIDPopUp(targetNode, e);
                        } else if (targetNode.getNodeName().startsWith("$")) {
                            TestCaseEditor.this.goObjectPopUp(targetNode, e);
                        } else if (targetNode.getNodeName().matches("^null$|^Assert=.*$")) {
                            TestCaseEditor.this.goAssertPopUp(targetNode, e);
                        }
                    } else {
                        TestCaseEditor.this.goTestCasePopUp(TestCaseEditor.this.m_root, e);
                    }
                } else if (e.getClickCount() == 2 && (path = TestCaseEditor.this.tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    TestCmdNode targetNode = (TestCmdNode)path.getLastPathComponent();
                    TestCommandRecord t_c = TestCaseEditor.this.m_cmds.get(targetNode.getID());
                    TestCaseRecord t_case = new TestCaseRecord(0);
                    t_case.name = targetNode.getCaseName();
                    t_case.include = TestCaseEditor.this.m_include;
                    if (targetNode.getNodeName().matches("^\\$[0-9]+.*$")) {
                        String n_name = targetNode.getNodeName().replaceFirst("^(\\$[0-9_]+)=.*$", "$1");
                        Plugin t_p = null;
                        int m = 0;
                        int k = 0;
                        while (k < Tool.plugins.size()) {
                            Plugin t_plug = Tool.plugins.get(k);
                            int n = t_plug.getPriority(t_case, t_c, n_name);
                            if (n > m) {
                                t_p = t_plug;
                                m = n;
                            }
                            ++k;
                        }
                        if (t_p != null) {
                            TestCaseEditor.this.editArgByPlugin(targetNode, t_p, null);
                        }
                    } else if (targetNode.getNodeName().matches("^null$|^Assert=.*$")) {
                        Plugin t_p = null;
                        int m = 0;
                        int k = 0;
                        while (k < Tool.plugins.size()) {
                            Plugin t_plug = Tool.plugins.get(k);
                            int n = t_plug.getPriority(t_case, t_c, null);
                            if (n > m) {
                                t_p = t_plug;
                                m = n;
                            }
                            ++k;
                        }
                        if (t_p != null) {
                            TestCaseEditor.this.editAssertByPlugin(targetNode, t_p, null);
                        }
                    }
                }
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        final JButton btnSave = new JButton(Messages.getString("TestCaseEditor.5"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!btnSave.isEnabled()) {
                    return;
                }
                TestCaseEditor.this.m_isOK = true;
                TestCaseEditor.this.setNextID();
                TestCaseEditor.this.setVisible(false);
            }
        });
        btnSave.setBounds(281, 425, 91, 21);
        this.getContentPane().add(btnSave);
        btnSave.setEnabled(!unableMode);
        JButton btnClose = new JButton(Messages.getString("TestCaseEditor.6"));
        btnClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TestCaseEditor.this.m_cmds.clear();
                TestCaseEditor.this.obj_table.clear();
                TestCaseEditor.this.m_assert.clear();
                unableMode = false;
                TestCaseEditor.this.setVisible(false);
            }
        });
        btnClose.setBounds(414, 425, 91, 21);
        this.getContentPane().add(btnClose);
        JButton btnIncompletelist = new JButton(Messages.getString("TestCaseEditor.7"));
        btnIncompletelist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        btnIncompletelist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = 0;
                while (i < TestCaseEditor.this.m_root.getChildCount()) {
                    Object[] t_path;
                    TestCmdNode t_node = (TestCmdNode)TestCaseEditor.this.m_root.getChildAt(i);
                    TestCommandRecord t_cmd = TestCaseEditor.this.m_cmds.get(t_node.getID());
                    if (!t_cmd.isComplete()) {
                        t_path = new Object[]{TestCaseEditor.this.m_root, t_node, t_node.getChildAt(0)};
                        TestCaseEditor.this.tree.expandPath(new TreePath(t_path));
                    } else {
                        t_path = new Object[]{TestCaseEditor.this.m_root, t_node};
                        TestCaseEditor.this.tree.collapsePath(new TreePath(t_path));
                    }
                    ++i;
                }
            }
        });
        btnIncompletelist.setBounds(610, 425, 162, 21);
        this.getContentPane().add(btnIncompletelist);
        this.m_model.reload();
        this.setNextID();
    }

    private TestCmdNode makeTreeNodes(TestCaseRecord tcase) {
        String t_include = " include NONE";
        Integer n_snapshot = 0;
        if (tcase.snapshot > 0) {
            n_snapshot = tcase.snapshot;
        }
        if (tcase.include != null && tcase.include.length() > 0) {
            t_include = " include " + tcase.include;
        }
        t_include = String.valueOf(t_include) + ", loggable " + Boolean.toString(tcase.loggable);
        TestCmdNode t_root = new TestCmdNode("TestCase=" + tcase.name + " :" + Integer.toString(tcase.begin) + "-" + Integer.toString(tcase.end) + t_include, 0, tcase.name);
        ArrayList<TestCommandRecord> tcmds = Tool._db().getTestCmdList(tcase.name, null, null, Tool.version);
        if (tcmds == null) {
            return t_root;
        }
        int i = 0;
        while (tcmds.size() > i) {
            if (!this.hiddenMode || tcmds.get((int)i).enable) {
                ObjectRecord t_obj;
                Boolean[] t_status;
                TestCommandRecord t_cmd = new TestCommandRecord(0);
                t_cmd.testCase = tcmds.get((int)i).testCase;
                t_cmd.id = tcmds.get((int)i).id;
                t_cmd.className = tcmds.get((int)i).className;
                t_cmd.methodName = tcmds.get((int)i).methodName;
                t_cmd.returnType = tcmds.get((int)i).returnType;
                t_cmd.subject = tcmds.get((int)i).subject;
                t_cmd.argTypes = tcmds.get((int)i).argTypes;
                t_cmd.enable = tcmds.get((int)i).enable;
                t_cmd.argStatus = tcmds.get((int)i).argStatus;
                String snap_sign = "";
                if (t_cmd.id == n_snapshot) {
                    snap_sign = s_snap_sign;
                }
                TestCmdNode test = new TestCmdNode("TestID=" + new Integer(t_cmd.id).toString() + snap_sign, t_cmd.id, tcase.name);
                t_root.add(test);
                if (t_cmd.id == n_snapshot) {
                    this.m_snapshot = test;
                }
                TestCmdNode cnameNode = new TestCmdNode(String.valueOf(t_cmd.className) + " # " + t_cmd.methodName, t_cmd.id, tcase.name);
                test.add(cnameNode);
                TestCmdNode ret = new TestCmdNode("$_=" + tcmds.get((int)i).returnType, t_cmd.id, tcase.name);
                cnameNode.add(ret);
                if (t_cmd.argStatus == null || t_cmd.argStatus.equals("null") || t_cmd.argStatus.length() == 0) {
                    t_status = new Boolean[t_cmd.numArgs() + 2];
                    t_status[0] = t_cmd.methodName.startsWith("static") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    int k = 1;
                    while (k < t_status.length) {
                        t_status[k] = false;
                        ++k;
                    }
                    t_cmd.argStatus = Tool.getJSONfromObject(t_status);
                } else {
                    t_status = (Boolean[])Tool.getObjectfromJSON(Boolean[].class, t_cmd.argStatus);
                }
                if (!t_cmd.methodName.startsWith("static") || t_cmd.methodName.equals(t_cmd.className)) {
                    String a_status = t_status[0] != false ? "(done)" : "";
                    TestCmdNode subj = new TestCmdNode("$0=" + tcmds.get((int)i).className + " " + tcmds.get((int)i).subject + a_status, t_cmd.id, tcase.name);
                    cnameNode.add(subj);
                    t_obj = new ObjectRecord(-1, tcase.name, t_cmd.id, 0, t_cmd.className, "$0");
                    t_obj.completed = t_status[0];
                    this.obj_table.put(String.valueOf(new Integer(t_cmd.id).toString()) + t_obj.stack, t_obj);
                }
                int j = 1;
                while (t_cmd.numArgs() + 1 > j) {
                    t_obj = new ObjectRecord(-1, tcase.name, t_cmd.id, j, t_cmd.getArgClass(j - 1), t_cmd.getArgStack(j - 1));
                    t_obj.completed = t_status[j];
                    this.obj_table.put(t_obj.id, t_obj);
                    String a_status = t_status[j] != false ? "(done)" : "";
                    TestCmdNode t_node = new TestCmdNode("$" + Integer.toString(j) + "=" + t_obj.className + " " + t_obj.stack + a_status, t_cmd.id, tcase.name);
                    cnameNode.add(t_node);
                    ++j;
                }
                this.m_cmds.put(new Integer(t_cmd.id), t_cmd);
                test.add(new TestCmdNode("Assert=" + new Integer(t_cmd.id).toString(), t_cmd.id, tcase.name));
            }
            ++i;
        }
        return t_root;
    }

    private void goTestCasePopUp(TestCmdNode targetNode, MouseEvent e) {
        JPopupMenu t_pop = new JPopupMenu();
        TestCaseRecord t_case = new TestCaseRecord(0);
        t_case.name = targetNode.getCaseName();
        t_case.include = this.m_include;
        if (this.m_snapshot != null) {
            ObjectRecord o_rec;
            t_case.snapshot = this.m_snapshot.getID();
            ArrayList<ObjectRecord> o_list = new ArrayList<ObjectRecord>();
            Integer i_arg = 1;
            while ((o_rec = this.obj_table.get(String.valueOf(Integer.toString(t_case.snapshot)) + "$" + i_arg.toString())) != null) {
                if (!o_rec.isUpdated()) {
                    o_list.add(Tool._db().getObjectRecord(o_rec));
                } else {
                    o_list.add(o_rec);
                }
                i_arg = i_arg + 1;
            }
            t_case.snapshot_Args = o_list.toArray(new ObjectRecord[o_list.size()]);
            t_case.snapshot_Assert = this.m_assert.get(t_case.snapshot);
            if (t_case.snapshot_Assert == null) {
                t_case.snapshot_Assert = Tool._db().getAssert(t_case.snapshot);
            }
        }
        ArrayList<JMenuItem> p_list = new ArrayList<JMenuItem>();
        PluginAction.s_curNode = targetNode;
        PluginAction.s_this = this;
        TestCommandRecord t_rec = null;
        if (this.m_cmds.size() > 0) {
            t_rec = this.m_cmds.get(this.m_begin);
        }
        int m = 1;
        int k = 0;
        while (k < Tool.plugins.size()) {
            Plugin t_plug = Tool.plugins.get(k);
            int n = t_plug.getPriority(t_case, t_rec, null);
            if (n >= m) {
                if (n == m) {
                    p_list.add(t_plug.getMenuItem("addCommand"));
                } else {
                    p_list.clear();
                    p_list.add(t_plug.getMenuItem("addCommand"));
                    m = n;
                }
            }
            ++k;
        }
        if (targetNode.getNodeName().startsWith("TestCase=NEW")) {
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.27"), this, targetNode)));
        } else {
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.28"), this, targetNode)));
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.25"), this, targetNode)));
            if (this.m_loggable) {
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.33"), this, targetNode)));
            } else {
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.38"), this, targetNode)));
            }
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.30"), this, targetNode)));
            PluginAction.s_curNode = targetNode;
            PluginAction.s_this = this;
            k = 0;
            while (k < p_list.size()) {
                t_pop.add((JMenuItem)p_list.get(k));
                ++k;
            }
        }
        t_pop.show(e.getComponent(), e.getX(), e.getY());
    }

    private void renTestCase(TestCmdNode curNode) {
        String f_name = curNode.getCaseName();
        ArrayList<String> w_msg = Tool._db().getReferringTestCaseList(f_name, Tool.version);
        if (w_msg != null && w_msg.size() > 0) {
            Tool.alertMSG(null, "ALERT!!:  " + w_msg + Messages.getString("TestCaseEditor.34"));
        }
        String usname = null;
        Integer begin = null;
        Integer end = null;
        if ("NEW".equals(curNode.getCaseName()) && this.m_cmds.size() == 0) {
            String t_data = JOptionPane.showInputDialog(this, Messages.getString("TestCaseEditor.50"), String.valueOf(f_name) + " " + Integer.toString(this.m_begin) + " " + Integer.toString(this.m_end));
            Pattern t_pat = Pattern.compile("^([\\w\\$]+)\\s+([0-9]+)\\s+([0-9]+)$");
            Matcher t_m = t_pat.matcher(t_data);
            if (t_m.find()) {
                usname = t_m.group(1);
                begin = new Integer(t_m.group(2));
                end = new Integer(t_m.group(3));
                if (Tool.group_code.length() > 0) {
                    Integer t_max = new Integer(Tool.group_code);
                    if (end > (t_max + 1) * 10000000 || t_max * 10000000 > begin) {
                        Tool.alertMSG(null, Messages.getString("TestCaseEditor.52"));
                        return;
                    }
                }
                if (Tool._db().getTestCaseList("%", begin, end, Tool.group_code, Tool.version).size() > 0) {
                    Tool.alertMSG(null, Messages.getString("TestCaseEditor.52"));
                    return;
                }
            }
        } else {
            usname = JOptionPane.showInputDialog(this, Messages.getString("TestCaseEditor.50"), f_name);
        }
        if (usname != null && !f_name.equals(usname) && usname.length() > 0) {
            ArrayList<TestCaseRecord> t_list = Tool._db().getTestCaseList(usname, 0, 0, Tool.group_code, Tool.version);
            if (t_list.size() > 0) {
                Tool.alertMSG(null, String.valueOf(usname) + Messages.getString("TestCaseEditor.35"));
            } else {
                String old_name = curNode.getNodeName();
                String n_name = old_name.replaceFirst(Pattern.quote(f_name), Matcher.quoteReplacement(usname));
                curNode.setNodeName(n_name);
                curNode.setCaseName(usname);
                if (begin != null) {
                    this.m_begin = begin;
                    this.m_end = end;
                }
                for (Map.Entry<Integer, TestCommandRecord> entry1 : this.m_cmds.entrySet()) {
                    entry1.getValue().testCase = usname;
                    entry1.getValue().changed();
                }
                HashMap<String, ObjectRecord> t_objRecs = new HashMap<String, ObjectRecord>();
                for (Map.Entry<String, ObjectRecord> entry2 : this.obj_table.entrySet()) {
                    ObjectRecord t_rec = entry2.getValue();
                    if (t_rec.isUnread()) {
                        t_rec = Tool._db().getObjectRecord(t_rec);
                    }
                    t_rec.testCase = usname;
                    t_rec.changed();
                    t_objRecs.put(entry2.getKey(), t_rec);
                }
                this.obj_table = t_objRecs;
                this.m_model.reload(curNode);
            }
        } else if (usname != null && usname.length() == 0) {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.10"));
        }
    }

    private void describeTestCase(TestCmdNode curNode) {
        String desc = JOptionPane.showInputDialog(this, Messages.getString("TestCaseEditor.51"), this.m_desc);
        if (desc != null && !desc.equals(this.m_desc)) {
            String t_desc = "\"\"";
            if (desc.length() > 0) {
                t_desc = "\".+\"";
            }
            String t_str = curNode.getNodeName();
            t_str = t_str.replaceAll("^(.*\\{).*(\\}.*)$", "$1" + t_desc + "$2");
            curNode.setNodeName(t_str);
            this.m_desc = desc;
            this.m_model.reload(curNode);
        }
    }

    private void includeTestCase(TestCmdNode curNode) {
        String str = JOptionPane.showInputDialog(this, Messages.getString("TestCaseEditor.26"), this.m_include);
        if (str != null && !str.equals(this.m_include)) {
            ArrayList<TestCaseRecord> t_list = Tool._db().getTestCaseList(str, 0, this.m_begin, Tool.group_code, Tool.version);
            String t_str = curNode.getNodeName();
            String t_loggable = ", loggable " + Boolean.toString(this.m_loggable);
            if (t_list.size() > 0) {
                t_str = t_str.replaceFirst("^(.*?)include.*$", "$1include " + t_list.get((int)0).include + t_loggable);
                curNode.setNodeName(t_str);
                this.m_include = t_list.get((int)0).include;
                this.m_model.reload();
            } else if (str.length() == 0) {
                t_str = t_str.replaceFirst("^(.*?)include.*$", "$1include NONE" + t_loggable);
                curNode.setNodeName(t_str);
                this.m_include = "NONE";
                this.m_model.reload(curNode);
            } else {
                Tool.alertMSG(null, Messages.getString("TestCaseEditor.32"));
            }
        }
    }

    public void loggableTestCase(TestCmdNode curNode) {
        this.m_loggable = true;
        String t_str = curNode.getNodeName();
        t_str = t_str.replaceFirst("^(.*, loggable ).*$", "$1true");
        curNode.setNodeName(t_str);
        this.m_model.reload(curNode);
    }

    public void unLoggableTestCase(TestCmdNode curNode) {
        this.m_loggable = false;
        String t_str = curNode.getNodeName();
        t_str = t_str.replaceFirst("^(.*, loggable ).*$", "$1false");
        curNode.setNodeName(t_str);
        this.m_model.reload(curNode);
    }

    private void addCommandByPlugin(TestCmdNode curNode, Plugin plug, String prevObj) {
        String tcname = curNode.getCaseName();
        if (this.m_end > this.m_nextid) {
            TestCommandRecord t_cmd = new TestCommandRecord(2);
            t_cmd.id = this.m_nextid;
            t_cmd.testCase = tcname;
            int n = plug.initCommand(t_cmd);
            if (n == -1) {
                Tool.alertMSG(null, Messages.getString("TestCaseEditor.37"));
                return;
            }
            if (n < 0) {
                return;
            }
            t_cmd.enable = true;
            this.m_cmds.put(new Integer(t_cmd.id), t_cmd);
            this.setNextID();
            TestCmdNode test = new TestCmdNode("TestID=" + new Integer(t_cmd.id).toString(), t_cmd.id, tcname);
            this.m_root.add(test);
            TestCmdNode cnameNode = new TestCmdNode(String.valueOf(t_cmd.className) + " # " + t_cmd.methodName, t_cmd.id, tcname);
            test.add(cnameNode);
            TestCmdNode _node = new TestCmdNode("$_=" + t_cmd.returnType, t_cmd.id, tcname);
            cnameNode.add(_node);
            Boolean[] t_status = new Boolean[n + 1];
            int k = 0;
            while (k < t_status.length) {
                t_status[k] = false;
                ++k;
            }
            if (t_cmd.methodName.startsWith("static")) {
                t_status[0] = true;
            }
            if (!plug.hasAssert()) {
                t_status[n] = true;
            }
            t_cmd.argStatus = Tool.getJSONfromObject(t_status);
            ArgumentIF[] t_args = new ObjectRecord[n];
            int k2 = 0;
            while (k2 < n) {
                if (k2 > 0 || plug.hasSubject()) {
                    t_args[k2] = new ObjectRecord(2);
                    if (k2 == 0) {
                        t_cmd.subject = "$0";
                    }
                }
                ++k2;
            }
            plug.initArguments(t_args);
            String str_args = "[";
            int j = 0;
            while (j < n) {
                if (j > 0 || plug.hasSubject()) {
                    ((ObjectRecord)t_args[j]).testCase = tcname;
                    ((ObjectRecord)t_args[j]).testID = t_cmd.id;
                    if (((ObjectRecord)t_args[j]).stack == null) {
                        ((ObjectRecord)t_args[j]).stack = "$" + Integer.toString(j);
                    }
                    ((ObjectRecord)t_args[j]).id = String.valueOf(Integer.toString(t_cmd.id)) + "$" + Integer.toString(j);
                    this.obj_table.put(((ObjectRecord)t_args[j]).id, (ObjectRecord)t_args[j]);
                    this.checkCompleted(t_cmd, (ObjectRecord)t_args[j], null);
                    TestCmdNode t_node = null;
                    if (prevObj != null && j == 0) {
                        ((ObjectRecord)t_args[j]).stack = prevObj;
                        t_cmd.subject = prevObj;
                        t_node = new TestCmdNode("$" + Integer.toString(j) + "=" + ((ObjectRecord)t_args[j]).className + " " + prevObj + "(done)", t_cmd.id, tcname);
                    } else {
                        t_node = new TestCmdNode("$" + Integer.toString(j) + "=" + ((ObjectRecord)t_args[j]).className, t_cmd.id, tcname);
                    }
                    cnameNode.add(t_node);
                    if (j > 0) {
                        if (str_args.length() > 1) {
                            str_args = String.valueOf(str_args) + ",";
                        }
                        str_args = String.valueOf(str_args) + "[" + ((ObjectRecord)t_args[j]).className + "," + ((ObjectRecord)t_args[j]).stack + "]";
                    }
                }
                ++j;
            }
            t_cmd.setArgTypes(String.valueOf(str_args) + "]");
            TestCmdNode t_nodeA = new TestCmdNode("Assert=" + Integer.toString(t_cmd.id), t_cmd.id, tcname);
            test.add(t_nodeA);
            AssertRecord t_ast = new AssertRecord(2);
            t_ast.id = t_cmd.id;
            t_ast.criteriaType = "Exception";
            t_ast.targetObj = "";
            t_ast.criteriaRex = "$null";
            plug.initAssert(t_ast);
            this.m_assert.put(t_cmd.id, t_ast);
            this.checkCompleted(t_cmd, null, t_ast);
            t_nodeA.setNodeName("Assert=" + t_cmd.id + " & " + t_ast.criteriaType + " & " + t_ast.criteriaRex);
            this.m_model.reload(curNode);
        } else {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.1"));
        }
    }

    private void addArgByPlugin(TestCmdNode curNode, Plugin plug, String opt) {
        TestCmdNode parent = null;
        parent = curNode.getNodeName().startsWith("$") ? (TestCmdNode)curNode.getParent() : curNode;
        TestCommandRecord cmd = this.m_cmds.get(curNode.getID());
        String num = Integer.toString(cmd.numArgs() + 1);
        String t_id = String.valueOf(Integer.toString(cmd.id)) + "$" + num;
        ObjectRecord t_obj = this.obj_table.get(t_id);
        if (t_obj == null) {
            t_obj = new ObjectRecord(2);
            t_obj.testCase = cmd.testCase;
            t_obj.testID = cmd.id;
            t_obj.id = String.valueOf(Integer.toString(cmd.id)) + "$" + num;
            t_obj.stack = "$" + num;
            this.obj_table.put(t_obj.id, t_obj);
        } else {
            t_obj.removed = false;
            t_obj.changed();
        }
        try {
            plug.initArgument(t_obj, opt);
        }
        catch (Exception e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseEditor.31")) + e.getMessage() + "\n" + Tool.getStackMessage(e, 0, 10));
            return;
        }
        TestCmdNode t_node = new TestCmdNode("$" + num.toString() + "=" + t_obj.className, cmd.id, cmd.testCase);
        parent.add(t_node);
        cmd.addArg(t_obj.className, t_obj.stack);
        Boolean[] blist = (Boolean[])Tool.getObjectfromJSON(Boolean[].class, cmd.argStatus);
        int n = new Integer(num);
        Boolean[] nlist = new Boolean[blist.length + 1];
        int i = 0;
        while (i < nlist.length) {
            nlist[i] = i < n ? blist[i] : (i == n ? Boolean.valueOf(false) : blist[i - 1]);
            ++i;
        }
        cmd.argStatus = Tool.getJSONfromObject(nlist);
    }

    private void editArgByPlugin(TestCmdNode curNode, Plugin plug, String opt) {
        String aName = curNode.getNodeName().replaceAll("^(\\$[0-9_]+)=.*$", "$1");
        String t_key = String.valueOf(Integer.toString(curNode.getID())) + aName;
        ObjectRecord t_rec = this.obj_table.get(t_key);
        if ("$_".equals(aName)) {
            t_rec = new ObjectRecord(0);
            t_rec.testID = curNode.getID();
            t_rec.testCase = curNode.getCaseName();
            t_rec.id = t_key;
            t_rec.stack = aName;
        } else {
            this.obj_table.put(t_key, t_rec);
        }
        String cname = t_rec.className;
        if (t_rec.isUnread()) {
            t_rec = Tool._db().getObjectRecord(t_rec);
            if (t_rec == null) {
                t_rec = new ObjectRecord(2);
                t_rec.testID = curNode.getID();
                t_rec.stack = aName;
                t_rec.testCase = curNode.getCaseName();
                t_rec.id = t_key;
                t_rec.className = Tool.primitiveToFQN(cname);
                if (Tool.getClassOutLine(t_rec.className).isInterface()) {
                    t_rec.isPOJO = false;
                }
            }
        } else {
            t_rec = t_rec._dup(true);
        }
        String o_stack = t_rec.stack;
        TestCommandRecord t_cmd = this.m_cmds.get(t_rec.testID);
        String num = aName.replaceFirst("\\$", "");
        Integer n = null;
        if ("_".equals(num)) {
            t_rec.className = t_cmd.returnType;
        } else {
            n = new Integer(num);
            t_rec.typeName = n == 0 ? t_cmd.className : t_cmd.getArgClass(new Integer(num) - 1);
        }
        AssertRecord t_ast = this.m_assert.get(t_rec.testID);
        if (t_ast == null) {
            t_ast = Tool._db().getAssert(t_rec.testID);
            if (t_ast == null) {
                t_ast = new AssertRecord(2);
                t_ast.id = new Integer(t_rec.testID);
                plug.initAssert(t_ast);
            }
            this.m_assert.put(t_rec.testID, t_ast);
        }
        try {
            plug.editArgument(t_rec, t_ast, opt);
        }
        catch (Exception e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseEditor.36")) + e.getMessage() + "\n" + Tool.getStackMessage(e, 0, 10));
            return;
        }
        if (t_rec.isUpdated()) {
            TestCommandRecord t_c = this.m_cmds.get(t_rec.testID);
            if (n != null) {
                String n_stack = t_rec.stack;
                this.obj_table.put(t_key, t_rec);
                if (!o_stack.equals(n_stack)) {
                    if (aName.equals("$0")) {
                        t_c.subject = t_rec.stack;
                    } else {
                        Integer pos = new Integer(aName.replace("$", ""));
                        t_c.setArgType(pos - 1, t_rec.className, t_rec.stack);
                    }
                }
                String a_status = "";
                Boolean[] t_status = (Boolean[])Tool.getObjectfromJSON(Boolean[].class, t_c.argStatus);
                if (t_rec.isCompleted()) {
                    t_status[n.intValue()] = true;
                    a_status = "(done)";
                } else {
                    t_status[n.intValue()] = false;
                }
                t_c.argStatus = Tool.getJSONfromObject(t_status);
                curNode.setNodeName(String.valueOf(aName) + "=" + t_rec.className + Messages.getString("TestCaseEditor.53") + aName + a_status);
            } else {
                t_c.returnType = t_rec.className;
                curNode.setNodeName(String.valueOf(aName) + "=" + t_rec.className);
            }
            t_c.changed();
            this.m_model.reload(curNode);
            this.checkCompleted(t_c, t_rec, null);
            this.checkCompleted(t_c, null, t_ast);
        }
    }

    private void goTestIDPopUp(TestCmdNode targetNode, MouseEvent e) {
        JPopupMenu t_pop = new JPopupMenu();
        if (this.m_snapshot == targetNode) {
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.17"), this, targetNode)));
        } else {
            if (targetNode.getNodeName().startsWith("//")) {
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.8"), this, targetNode)));
            } else {
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.55"), this, targetNode)));
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.57"), this, targetNode)));
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.13"), this, targetNode)));
                if (targetNode != this.m_snapshot) {
                    t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.39"), this, targetNode)));
                }
            }
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.56"), this, targetNode)));
        }
        t_pop.show(e.getComponent(), e.getX(), e.getY());
    }

    public void copyAddTest(TestCmdNode curNode) {
        if (this.m_end > this.m_nextid) {
            this.copyPasteCmd(curNode, this.m_nextid);
            this.setNextID();
        } else {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.2"));
        }
    }

    private void copyPasteCmd(TestCmdNode curNode, int newID) {
        String tcname = curNode.getCaseName();
        TestCmdNode n_test = new TestCmdNode("TestID=" + Integer.toString(newID), newID, tcname);
        int n = this.m_root.getChildCount();
        boolean b_added = false;
        int j = 0;
        while (j < n) {
            TestCmdNode t_child = (TestCmdNode)this.m_root.getChildAt(j);
            if (t_child.getID() > newID) {
                this.m_root.insert(n_test, j);
                b_added = true;
                break;
            }
            ++j;
        }
        if (!b_added) {
            this.m_root.add(n_test);
        }
        this.m_cmds.put(new Integer(newID), this.m_cmds.get(curNode.getID())._dup(newID));
        TestCmdNode o_class = (TestCmdNode)curNode.getChildAt(0);
        TestCmdNode n_class = new TestCmdNode(o_class.getNodeName(), newID, tcname);
        n_test.add(n_class);
        TestCmdNode n_assert = new TestCmdNode("Assert=" + Integer.toString(newID), newID, tcname);
        n_test.add(n_assert);
        AssertRecord o_arec = this.m_assert.get(curNode.getID());
        AssertRecord n_arec = null;
        if (o_arec != null) {
            n_arec = o_arec._dup(false);
            n_arec.id = newID;
        } else {
            n_arec = Tool._db().getAssert(curNode.getID());
            if (n_arec == null) {
                n_arec = new AssertRecord(2);
            }
            n_arec.id = newID;
        }
        this.m_assert.put(newID, n_arec);
        int i = 0;
        while (o_class.getChildCount() > i) {
            TestCmdNode o_arg = (TestCmdNode)o_class.getChildAt(i);
            String nodeName = o_arg.getNodeName();
            String t_stack = nodeName.replaceFirst("^(\\$\\w+)=.*$", "$1");
            String t_key = String.valueOf(Integer.toString(o_arg.getID())) + t_stack;
            ObjectRecord t_rec = null;
            ObjectRecord n_rec = null;
            t_rec = this.obj_table.get(t_key);
            if (t_rec != null) {
                if (!t_rec.isUpdated()) {
                    ObjectRecord temp = new ObjectRecord(0);
                    temp.stack = t_stack;
                    temp.id = String.valueOf(Integer.toString(curNode.getID())) + t_stack;
                    n_rec = Tool._db().getObjectRecord(temp);
                }
                if (n_rec != null) {
                    n_rec = n_rec._dup(false);
                    n_rec.testID = newID;
                    n_rec.id = String.valueOf(newID) + t_stack;
                }
                t_key = String.valueOf(Integer.toString(newID)) + t_stack;
                this.obj_table.put(t_key, n_rec);
            }
            TestCmdNode n_arg = new TestCmdNode(nodeName, newID, tcname);
            n_class.add(n_arg);
            ++i;
        }
        this.m_model.reload();
    }

    private void removeTest(TestCmdNode curNode, boolean bAlert) {
        int t_res = 0;
        if (bAlert) {
            ArrayList<String> t_warning = Tool._db().getReferringTestCmdList(curNode.getCaseName(), Integer.toString(curNode.getID()));
            String msg = Messages.getString("TestCaseEditor.16");
            if (t_warning != null && t_warning.size() > 0) {
                msg = t_warning + Messages.getString("TestCaseEditor.66");
            }
            t_res = JOptionPane.showConfirmDialog(this, String.valueOf(msg) + curNode.getNodeName() + "?");
        }
        if (t_res == 0) {
            TestCmdNode parent = (TestCmdNode)curNode.getParent();
            parent.remove(curNode);
            Integer i = curNode.getID();
            this.m_cmds.get((Object)i).removed = true;
            this.m_cmds.get(i).changed();
            this.m_removings.add(this.m_cmds.get(i));
            this.m_cmds.remove(i);
            HashMap temp = (HashMap)this.obj_table.clone();
            for (Map.Entry entry : temp.entrySet()) {
                if (((ObjectRecord)entry.getValue()).testID != i) continue;
                this.obj_table.get(entry.getKey()).removed = true;
                this.obj_table.get(entry.getKey()).changed();
                this.m_removings.add(this.obj_table.get(entry.getKey()));
                this.obj_table.remove(entry.getKey());
            }
            AssertRecord t_ast = null;
            if (this.m_assert.get(i) != null) {
                this.m_assert.get((Object)i).removed = true;
                this.m_assert.get(i).changed();
                this.m_assert.remove(i);
            } else {
                t_ast = Tool._db().getAssert(i);
                if (t_ast != null) {
                    t_ast.removed = true;
                    t_ast.changed();
                }
            }
            this.m_removings.add(t_ast);
            this.m_model.reload();
        }
    }

    public void setSnapshot(TestCmdNode curNode) {
        TestCommandRecord t_rec = this.m_cmds.get(curNode.getID());
        if (t_rec.enable && Tool.hasDefaultConstructor(t_rec.className, true) && t_rec.isComplete()) {
            String t_name = null;
            if (this.m_snapshot != null) {
                int t_res;
                Integer n_observers = this.countSnapshotObserver();
                if (n_observers > 0 && (t_res = JOptionPane.showConfirmDialog(this, String.valueOf(n_observers.toString()) + Messages.getString("TestCaseEditor.54"))) == 1) {
                    return;
                }
                t_name = this.m_snapshot.getNodeName();
                t_name = t_name.replaceFirst(Pattern.quote(s_snap_sign), "");
                this.m_snapshot.setNodeName(t_name);
            }
            t_name = curNode.getNodeName();
            t_name = String.valueOf(t_name) + s_snap_sign;
            curNode.setNodeName(t_name);
            this.m_snapshot = curNode;
            this.m_model.reload();
        } else {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.42"));
        }
    }

    private Integer countSnapshotObserver() {
        ArrayList<TestCommandRecord> t_cmds1 = Tool._db().getTestCmdList(null, null, "$replay(" + Integer.toString(this.m_snapshot.getID()) + ")", Tool.version);
        ArrayList<TestCommandRecord> t_cmds2 = Tool._db().getTestCmdList(this.m_root.getCaseName(), null, "$replay(" + Integer.toString(this.m_snapshot.getID()) + ")", Tool.version);
        int t_count = 0;
        for (Map.Entry<Integer, TestCommandRecord> entry : this.m_cmds.entrySet()) {
            if (!entry.getValue().getMethodName().equals("$replay(" + Integer.toString(this.m_snapshot.getID()) + ")")) continue;
            ++t_count;
        }
        return t_count + t_cmds1.size() - t_cmds2.size();
    }

    public void resetSnapshot(TestCmdNode curNode) {
        if (this.m_snapshot == curNode) {
            int t_res;
            Integer n_observers = this.countSnapshotObserver();
            if (n_observers > 0 && (t_res = JOptionPane.showConfirmDialog(this, String.valueOf(n_observers.toString()) + Messages.getString("TestCaseEditor.67"))) == 1) {
                return;
            }
            String t_name = this.m_snapshot.getNodeName();
            t_name = t_name.replaceFirst(Pattern.quote(s_snap_sign), "");
            this.m_snapshot.setNodeName(t_name);
            this.m_snapshot = null;
            this.m_model.reload(curNode);
        }
    }

    private void disableTest(TestCmdNode curNode) {
        if (this.m_snapshot.equals(curNode)) {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.43"));
        } else {
            TestCommandRecord t_c;
            t_c.setEnable(!(t_c = this.m_cmds.get(curNode.getID())).getEnable());
            t_c.changed();
            curNode.setNodeName("//" + curNode.getNodeName());
            if (this.hiddenMode && !t_c.getEnable()) {
                TestCmdNode parent = (TestCmdNode)curNode.getParent();
                parent.remove(curNode);
                this.m_model.reload();
            }
        }
    }

    public void enableTest(TestCmdNode curNode) {
        TestCommandRecord t_c;
        t_c.setEnable(!(t_c = this.m_cmds.get(curNode.getID())).getEnable());
        t_c.changed();
        curNode.setNodeName(curNode.getNodeName().substring(2));
    }

    private void renumberTest(TestCmdNode curNode) {
        String newID;
        int t_res;
        if (this.hiddenMode) {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.19"));
            return;
        }
        Integer oldID = curNode.getID();
        ArrayList<String> t_warning = Tool._db().getReferringObjectList(curNode.getCaseName(), String.valueOf(oldID.toString()) + "$0");
        if (t_warning != null && t_warning.size() > 0 && (t_res = JOptionPane.showConfirmDialog(this, t_warning + Messages.getString("TestCaseEditor.70") + curNode.getNodeName() + "?")) == 2) {
            return;
        }
        ArrayList<String> w_msg = Tool._db().getReferringTestCmdList(curNode.getCaseName(), oldID.toString());
        if (w_msg != null && w_msg.size() > 0) {
            Tool.alertMSG(null, "ALERT!!:  " + w_msg + Messages.getString("TestCaseEditor.77"));
        }
        if ((newID = JOptionPane.showInputDialog(this, Messages.getString("TestCaseEditor.20"), oldID.toString())) != null && newID.matches("[0-9]+")) {
            Integer nID = new Integer(newID);
            if (!newID.matches("^[0-9]+$")) {
                Tool.alertMSG(null, String.valueOf(newID) + Messages.getString("TestCaseEditor.22"));
                return;
            }
            Integer i = new Integer(newID);
            if (i < this.m_begin || i > this.m_end) {
                Tool.alertMSG(null, String.valueOf(newID) + Messages.getString("TestCaseEditor.23"));
                return;
            }
            TestCommandRecord t_c = this.m_cmds.get(i);
            if (t_c != null) {
                Tool.alertMSG(null, String.valueOf(newID) + Messages.getString("TestCaseEditor.24"));
                return;
            }
            this.copyPasteCmd(curNode, i);
            if (i >= this.m_nextid) {
                this.setNextID();
            }
            this.removeTest(curNode, false);
            Pattern t_pat = Pattern.compile("([0-9]+)\\$");
            for (Map.Entry<String, ObjectRecord> entry : this.obj_table.entrySet()) {
                String num;
                ObjectRecord t_rec = entry.getValue();
                if (t_rec.removed) continue;
                int oid = t_rec.testID;
                if (oldID == oid) {
                    t_rec.testID = nID;
                    continue;
                }
                if (oldID >= oid) continue;
                Matcher t_m = t_pat.matcher(t_rec.stack);
                if (t_m.find() && (num = t_m.group(1)).equals(oldID.toString())) {
                    t_rec.stack = t_rec.stack.replaceAll(t_pat.pattern(), Matcher.quoteReplacement(String.valueOf(newID) + "$"));
                    t_rec.changed();
                }
                if (t_rec.jSON == null) continue;
                t_m = t_pat.matcher(t_rec.jSON);
                String t_json = t_rec.jSON;
                while (t_m.find()) {
                    String num2 = t_m.group(1);
                    if (!num2.equals(oldID.toString())) continue;
                    t_json = t_json.replaceAll(t_pat.pattern(), Matcher.quoteReplacement(String.valueOf(newID) + "$"));
                }
                if (t_rec.jSON.equals(t_json)) continue;
                t_rec.jSON = t_json;
                t_rec.changed();
            }
            for (Map.Entry<Object, Record> entry : this.m_cmds.entrySet()) {
                if ((Integer)entry.getKey() <= oldID) continue;
                TestCommandRecord t_cmd = (TestCommandRecord)entry.getValue();
                t_cmd.relink(oldID.toString(), nID.toString());
            }
            this.m_model.reload();
        } else {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.87"));
        }
    }

    private void goObjectPopUp(TestCmdNode targetNode, MouseEvent e) {
        Integer t_i;
        String n_name = targetNode.getNodeName().replaceFirst("^(\\$[0-9_]+)=.*$", "$1");
        TestCommandRecord t_c = this.m_cmds.get(targetNode.getID());
        TestCaseRecord t_case = new TestCaseRecord(0);
        t_case.name = targetNode.getCaseName();
        t_case.include = this.m_include;
        JPopupMenu t_pop = new JPopupMenu();
        PluginAction.s_curNode = targetNode;
        PluginAction.s_this = this;
        int m = 0;
        boolean not_skip = true;
        int k = 0;
        while (k < Tool.plugins.size()) {
            Plugin t_plug = Tool.plugins.get(k);
            int n = t_plug.getPriority(t_case, t_c, n_name);
            if (n > m) {
                t_pop.removeAll();
                t_pop.add(t_plug.getMenuItem("editArg"));
                if (t_c.varArgsPos() >= 0 && !n_name.equals("$_")) {
                    t_pop.add(t_plug.getMenuItem("addArg"));
                }
                m = n;
                if (n > 1) {
                    not_skip = false;
                }
            }
            ++k;
        }
        if (t_c.varArgsPos() >= 0 && !n_name.equals("$_") && (t_i = new Integer(n_name.replaceFirst("\\$", ""))) > t_c.varArgsPos()) {
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.94"), this, targetNode)));
        }
        if (not_skip) {
            if (!n_name.equals("$0") && !n_name.equals("$_")) {
                t_pop.add(new JMenuItem(new TestNodeAction("NULL", this, targetNode)));
            }
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.75"), this, targetNode)));
            t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.76"), this, targetNode)));
        }
        t_pop.show(e.getComponent(), e.getX(), e.getY());
    }

    public void removeVarArg(TestCmdNode curNode) {
        int t_res;
        TestCommandRecord t_cmd = this.m_cmds.get(curNode.getID());
        String num = curNode.getNodeName().replaceAll("^\\$([0-9]+)=.*$", "$1");
        Integer i = new Integer(num);
        ArrayList<String> t_warning = Tool._db().getReferringObjectList(curNode.getCaseName(), String.valueOf(Integer.toString(curNode.getID())) + "$" + num);
        String msg = Messages.getString("TestCaseEditor.29");
        if (t_warning != null && t_warning.size() > 0) {
            msg = t_warning + Messages.getString("TestCaseEditor.95");
        }
        if ((t_res = JOptionPane.showConfirmDialog(this, String.valueOf(msg) + curNode.getNodeName() + "?")) == 2) {
            return;
        }
        t_cmd.removeLast();
        String t_key = String.valueOf(Integer.toString(t_cmd.id)) + "$";
        ObjectRecord target = this.obj_table.get(String.valueOf(t_key) + num);
        int j = i;
        ObjectRecord t_rec = this.obj_table.get(String.valueOf(t_key) + Integer.toString(j + 1));
        while (t_rec != null) {
            t_rec.stack = "$" + Integer.toString(j);
            t_rec.id = String.valueOf(t_key) + Integer.toString(j);
            t_rec.changed();
            this.obj_table.put(String.valueOf(t_key) + Integer.toString(j), t_rec);
            this.checkCompleted(t_cmd, t_rec, null);
            t_rec = this.obj_table.get(String.valueOf(t_key) + Integer.toString(++j + 1));
        }
        this.obj_table.put(String.valueOf(t_key) + Integer.toString(j), target);
        target.removed = true;
        target.id = String.valueOf(t_key) + Integer.toString(j);
        target.changed();
        this.checkCompleted(t_cmd, null, null);
        int k = 0;
        while (k < curNode.getParent().getChildCount()) {
            TestCmdNode parent = (TestCmdNode)curNode.getParent();
            TestCmdNode t_node = (TestCmdNode)parent.getChildAt(k);
            if (t_node.getNodeName().startsWith("$" + Integer.toString(j))) {
                parent.remove(t_node);
                break;
            }
            ++k;
        }
        this.m_model.reload();
    }

    public void setNullObject(TestCmdNode curNode) {
        String t_stack = curNode.getNodeName().replaceAll("^(\\$[0-9]+)=.*$", "$1");
        String num = t_stack.replaceAll("^.*\\$([0-9]+)$", "$1");
        int t_ID = curNode.getID();
        String t_key = String.valueOf(new Integer(t_ID).toString()) + t_stack;
        ObjectRecord t_rec = this.obj_table.get(t_key);
        String cname = t_rec.className;
        if (!t_rec.isUpdated()) {
            t_rec = Tool._db().getObjectRecord(t_rec);
        }
        if (t_rec == null) {
            t_rec = new ObjectRecord(2);
            t_rec.testID = t_ID;
            t_rec.stack = t_stack;
            t_rec.isPOJO = true;
            t_rec.className = Tool.primitiveToFQN(cname);
        }
        t_rec.jSON = "null";
        t_rec.changed();
        this.obj_table.put(t_key, t_rec);
        curNode.setNodeName("$" + num + "=" + t_rec.className + " " + t_rec.stack);
        this.checkCompleted(this.m_cmds.get(new Integer(t_ID)), t_rec, null);
    }

    private void checkCompleted(TestCommandRecord cmd, ObjectRecord rec, AssertRecord ast) {
        String t_status = "";
        Boolean[] blist = (Boolean[])Tool.getObjectfromJSON(Boolean[].class, cmd.argStatus);
        if (ast == null && rec == null) {
            ObjectRecord t_rec;
            ArrayList<Boolean> new_list = new ArrayList<Boolean>();
            new_list.add(blist[0]);
            String t_key = String.valueOf(Integer.toString(cmd.id)) + "$";
            Integer j = 1;
            while ((t_rec = this.obj_table.get(String.valueOf(t_key) + j.toString())) != null) {
                if (!t_rec.removed) {
                    new_list.add(t_rec.completed);
                }
                j = j + 1;
            }
            new_list.add(blist[blist.length - 1]);
            t_status = Tool.getJSONfromObject(new_list.toArray(new Boolean[new_list.size()]));
        } else {
            if (ast == null) {
                String num = rec.id.replaceAll("^[0-9]+\\$([0-9]+)$", "$1");
                blist[new Integer((String)num).intValue()] = rec.isCompleted();
            } else if (ast != null) {
                blist[blist.length - 1] = ast.isCompleted();
            }
            t_status = Tool.getJSONfromObject(blist);
        }
        cmd.argStatus = t_status;
        cmd.isComplete();
        cmd.changed();
    }

    private void reuseObject(TestCmdNode curNode) {
        String cname = curNode.getNodeName().replaceFirst("^$[0-9]+=([\\w\\.\\[\\]]+)\\$w*$", "$1");
        ArrayList<Integer> test_list = new ArrayList<Integer>();
        HashMap<Integer, String[]> stack_map = new HashMap<Integer, String[]>();
        ArrayList<String> temp = new ArrayList<String>();
        int i = this.m_begin;
        while (i < curNode.getID()) {
            temp.clear();
            TestCommandRecord t_rec = this.m_cmds.get(i);
            if (t_rec != null) {
                if (t_rec.className.equals(cname)) {
                    if (!test_list.contains(t_rec.id)) {
                        test_list.add(t_rec.id);
                    }
                    temp.add("$0");
                }
                if (t_rec.returnType.equals(cname)) {
                    if (!test_list.contains(t_rec.id)) {
                        test_list.add(t_rec.id);
                    }
                    temp.add("$_");
                }
                int j = 0;
                while (j < t_rec.numArgs()) {
                    if (t_rec.getArgClass(j).equals(cname)) {
                        if (!test_list.contains(t_rec.id)) {
                            test_list.add(t_rec.id);
                        }
                        temp.add("[" + cname + "," + t_rec.getArgStack(j) + "]");
                    }
                    ++j;
                }
                if (temp.size() > 0) {
                    stack_map.put(new Integer(t_rec.id), temp.toArray(new String[temp.size()]));
                }
            }
            ++i;
        }
        ReuseArguments t_dial = new ReuseArguments(this, test_list, this.m_cmds, stack_map);
        t_dial.setVisible(true);
        String t_name = curNode.getNodeName();
        if (t_dial.getID() > 0) {
            String r_name = String.valueOf(Integer.toString(t_dial.getID())) + t_dial.getArg();
            t_name = t_name.replaceFirst("^($[0-9]+=[\\w]\\.[\\w\\[\\]]+)\\s+[\\$0-9_]+$", "$1 " + Matcher.quoteReplacement(r_name));
            String t_stack = t_name.replaceFirst("^($[0-9]+)=[\\w]\\.[\\w\\[\\]]+\\s+[\\$0-9_]+$", "$1");
            int t_ID = curNode.getID();
            TestCommandRecord t_cmd = this.m_cmds.get(t_ID);
            String t_key = String.valueOf(Integer.toString(t_ID)) + t_stack;
            ObjectRecord t_rec = this.obj_table.get(t_key);
            t_rec.stack = r_name;
            if (t_key.endsWith("$0")) {
                t_cmd.subject = r_name;
            } else {
                Integer n = new Integer(t_stack.replaceFirst("$", ""));
                t_cmd.setArgType(n - 1, cname, r_name);
            }
            t_rec.stack = r_name;
            curNode.setNodeName(t_name);
            this.m_model.reload(curNode);
        }
    }

    public void addTestOfObject(TestCmdNode curNode) {
        if (this.m_end > this.m_nextid) {
            TestCommandRecord t_cmd = new TestCommandRecord(2);
            t_cmd.id = this.m_nextid;
            this.setNextID();
            String c_name = curNode.getNodeName().replaceFirst("^\\$[0-9]+=([\\.\\w\\[\\]]+)\\s.*$", "$1");
            ClassReadDialog t_dial = new ClassReadDialog(this, Tool.target_dirs, t_cmd);
            t_dial.setClassName(c_name);
            t_dial.setVisible(true);
            String prevnum = Integer.toString(curNode.getID());
            String prevObj = String.valueOf(prevnum) + curNode.getNodeName().replaceFirst("^(\\$[0-9_]+)=.*$", "$1");
            DefaultPlugin plug = new DefaultPlugin();
            this.addCommandByPlugin(curNode, plug, prevObj);
        } else {
            Tool.alertMSG(null, Messages.getString("TestCaseEditor.3"));
        }
    }

    private void goAssertPopUp(TestCmdNode targetNode, MouseEvent e) {
        Integer i = new Integer(targetNode.getID());
        TestCommandRecord t_c = this.m_cmds.get(i);
        TestCaseRecord t_case = new TestCaseRecord(0);
        t_case.name = targetNode.getCaseName();
        t_case.include = this.m_include;
        JPopupMenu t_pop = new JPopupMenu();
        PluginAction.s_curNode = targetNode;
        PluginAction.s_this = this;
        int m = 0;
        boolean not_skip = true;
        int k = 0;
        while (k < Tool.plugins.size()) {
            Plugin t_plug = Tool.plugins.get(k);
            int n = t_plug.getPriority(t_case, t_c, "ASSERT");
            if (n > m) {
                t_pop.removeAll();
                JMenuItem t_item = t_plug.getMenuItem("editAssert");
                if (t_item != null) {
                    t_pop.add(t_item);
                }
                m = n;
                if (n > 1) {
                    not_skip = false;
                }
            }
            ++k;
        }
        if (not_skip) {
            if (targetNode.getNodeName().equals("null")) {
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.9"), this, targetNode)));
            } else {
                t_pop.add(new JMenuItem(new TestNodeAction(Messages.getString("TestCaseEditor.107"), this, targetNode)));
            }
        }
        if (t_pop.getComponentCount() > 0) {
            t_pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void editAssertByPlugin(TestCmdNode curNode, Plugin plug, String opt) {
        Integer i_num = new Integer(curNode.getID());
        String t_id = i_num.toString();
        TestCommandRecord t_c = this.m_cmds.get(curNode.getID());
        TestCaseRecord t_case = new TestCaseRecord(0);
        t_case.name = curNode.getCaseName();
        t_case.include = this.m_include;
        AssertRecord t_ast = this.m_assert.get(curNode.getID());
        if (t_ast == null) {
            t_ast = Tool._db().getAssert(i_num);
            if (t_ast == null) {
                t_ast = new AssertRecord(2);
                t_ast.id = new Integer(t_id);
            }
            this.m_assert.put(i_num, t_ast);
        }
        AssertRecord t_clone = t_ast._dup(true);
        plug.editAssert(t_ast, t_c);
        if (!t_ast.equals(t_clone)) {
            t_clone.changed();
            this.m_assert.put(i_num, t_ast);
            this.checkCompleted(t_c, null, t_ast);
        }
        if (t_ast.enable) {
            String t_regs;
            String t_done = "";
            if (t_ast.isCompleted()) {
                t_done = "(done)";
            }
            if ((t_regs = t_ast.criteriaType) == null || t_regs.length() == 0) {
                t_regs = Messages.getString("TestCaseEditor.62");
            }
            curNode.setNodeName("Assert=" + t_regs + t_done);
        } else {
            curNode.setNodeName("skip");
        }
        this.m_model.reload(curNode);
    }

    private void disableAssert(TestCmdNode curNode) {
        AssertRecord t_ast = this.m_assert.get(curNode.getID());
        if (t_ast != null) {
            t_ast.setEnable(false);
            t_ast.changed();
        }
        curNode.setNodeName("skip");
        this.m_model.reload(curNode);
    }

    private void enableAssert(TestCmdNode curNode) {
        AssertRecord t_ast = this.m_assert.get(curNode.getID());
        Integer i_num = new Integer(curNode.getID());
        if (t_ast != null) {
            t_ast.setEnable(true);
            t_ast.changed();
            if (t_ast.enable) {
                String t_regs;
                String t_done = "";
                if (t_ast.isCompleted()) {
                    t_done = "(done)";
                }
                if ((t_regs = t_ast.criteriaType) == null || t_regs.length() == 0) {
                    t_regs = Messages.getString("TestCaseEditor.71");
                }
                curNode.setNodeName("Assert=" + t_regs + t_done);
            } else {
                curNode.setNodeName("skip");
            }
        } else {
            curNode.setNodeName("Assert=" + i_num.toString());
        }
        this.m_model.reload(curNode);
    }

    private void setNextID() {
        int n = 0;
        if (this.m_cmds.size() > 0) {
            for (Map.Entry<Integer, TestCommandRecord> entry1 : this.m_cmds.entrySet()) {
                if (entry1.getValue().id < n) continue;
                n = entry1.getValue().id + 1;
            }
        } else if (this.m_nextid == 0) {
            n = this.m_begin;
        }
        this.m_nextid = n;
    }

    public static JMenuItem getMenuItem(String cmd, String name, String opt, Plugin p) {
        return new JMenuItem(new PluginAction(cmd, name, opt, p));
    }

    public boolean isOK() {
        return this.m_isOK;
    }

    public void copyData(TestCaseRecord rec) {
        rec.description = this.m_desc;
        rec.name = this.m_root.getCaseName();
        rec.begin = new Integer(this.m_begin);
        rec.end = new Integer(this.m_end);
        int n = 0;
        if (this.m_snapshot != null) {
            n = this.m_snapshot.getID();
        }
        rec.snapshot = n;
        rec.include = this.m_include;
        rec.loggable = this.m_loggable;
    }

    static class PluginAction
    extends AbstractAction {
        static TestCaseEditor s_this;
        static TestCmdNode s_curNode;
        String m_cmd;
        String m_opt;
        Plugin m_p;

        PluginAction(String cmd, String name, String opt, Plugin p) {
            if (name != null && name.length() > 0) {
                this.putValue("Name", name);
            } else {
                Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseEditor.108")) + p.getClass().getName());
            }
            this.m_cmd = cmd;
            this.m_opt = opt;
            this.m_p = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_cmd.equals("addCommand")) {
                PluginAction.s_this.addCommandByPlugin(PluginAction.s_curNode, this.m_p, null);
            } else if (this.m_cmd.equals("addArg")) {
                PluginAction.s_this.addArgByPlugin(PluginAction.s_curNode, this.m_p, this.m_opt);
            } else if (this.m_cmd.equals("editArg")) {
                PluginAction.s_this.editArgByPlugin(PluginAction.s_curNode, this.m_p, this.m_opt);
            } else if (this.m_cmd.equals("editAssert")) {
                PluginAction.s_this.editAssertByPlugin(PluginAction.s_curNode, this.m_p, this.m_opt);
            }
        }
    }

    class TestNodeAction
    extends AbstractAction {
        String m_name;
        TestCmdNode curNode;
        TestCaseEditor m_master;

        TestNodeAction(String name, TestCaseEditor master, TestCmdNode targetNode) {
            this.putValue("Name", name);
            this.m_name = name;
            this.curNode = targetNode;
            this.m_master = master;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_name.equals(Messages.getString("TestCaseEditor.113"))) {
                this.m_master.renTestCase(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.114"))) {
                this.m_master.describeTestCase(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.90"))) {
                this.m_master.includeTestCase(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.33"))) {
                this.m_master.unLoggableTestCase(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.38"))) {
                this.m_master.loggableTestCase(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.120"))) {
                this.m_master.addTestOfObject(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.115"))) {
                this.m_master.copyAddTest(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.11"))) {
                this.m_master.enableTest(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.116"))) {
                this.m_master.disableTest(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.46"))) {
                this.m_master.setSnapshot(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.15"))) {
                this.m_master.resetSnapshot(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.117"))) {
                this.m_master.removeTest(this.curNode, true);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.119"))) {
                this.m_master.reuseObject(this.curNode);
            } else if (this.m_name.equals("NULL")) {
                this.m_master.setNullObject(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.122"))) {
                this.m_master.disableAssert(this.curNode);
            } else if (this.m_name.equals(Messages.getString("TestCaseEditor.4"))) {
                this.m_master.enableAssert(this.curNode);
            } else if (this.m_name.startsWith(Messages.getString("TestCaseEditor.12"))) {
                this.m_master.renumberTest(this.curNode);
            }
        }
    }
}

