/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.test.ClassOutLine;
import com.ftinc.si.assist.test.CodeProcessor;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Tool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javassist.Modifier;
import javassist.NotFoundException;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class CodingAssistMenu
extends JDialog {
    private JList<String> _list;
    private ArrayList<ArrayList<String>> m_stack;
    private String m_head = "";
    private DefaultListModel<String> m_model;
    private FakeMethodRecord m_fake;
    private HashMap<String, Class<?>[]> m_excmap;
    private String m_filter;
    public String m_catches = null;
    public String m_target;
    public String m_answer = null;

    public int countCandidate() {
        return this.m_model.getSize();
    }

    public void addCandidates(ArrayList<String> list) {
        Collections.sort(list);
        int i = 0;
        while (i < list.size()) {
            this.m_model.addElement(list.get(i));
            ++i;
        }
    }

    public CodingAssistMenu(JDialog owner, FakeMethodRecord frec, String src, int caretpos, HashMap<String, Class<?>> class_list, Point pt, String filter) {
        super((Dialog)owner, true);
        this.m_fake = frec;
        this.m_filter = filter;
        this.m_stack = new ArrayList();
        this.m_excmap = new HashMap();
        this.setBounds(pt.x, pt.y, 300, 200);
        this.setUndecorated(true);
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "Center");
        this.m_model = new DefaultListModel();
        this._list = new JList<String>(this.m_model);
        this._list.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (CodingAssistMenu.this.m_model.getSize() == 0) {
                    CodingAssistMenu.this.setVisible(false);
                }
            }
        });
        this._list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CodingAssistMenu.this.setVisible(false);
            }
        });
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = CodingAssistMenu.this._list.getSelectedIndex();
                if (CodingAssistMenu.this.m_model.getElementAt(i) != null) {
                    CodingAssistMenu.this.setVisible(false);
                    String[] temp = ((String)CodingAssistMenu.this.m_model.getElementAt(i)).toString().split(" :");
                    CodingAssistMenu.this.m_answer = temp[0];
                    CodingAssistMenu.this.makeCatches((Class[])CodingAssistMenu.this.m_excmap.get(((String)CodingAssistMenu.this.m_model.getElementAt(i)).toString()));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CodingAssistMenu.this.setVisible(false);
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int i = CodingAssistMenu.this._list.getSelectedIndex();
                    if (CodingAssistMenu.this.m_model.getElementAt(i) != null) {
                        String[] temp = ((String)CodingAssistMenu.this.m_model.getElementAt(i)).toString().split(" :");
                        CodingAssistMenu.this.m_answer = temp[0];
                    }
                    CodingAssistMenu.this.setVisible(false);
                } else if (e.getKeyCode() == 27 || e.getKeyCode() == 8) {
                    CodingAssistMenu.this.setVisible(false);
                } else if (e.getKeyCode() == 37) {
                    if (CodingAssistMenu.this.m_stack.size() == 0) {
                        CodingAssistMenu.this.setVisible(false);
                    } else {
                        ArrayList t_list = (ArrayList)CodingAssistMenu.this.m_stack.get(CodingAssistMenu.this.m_stack.size() - 1);
                        CodingAssistMenu.this.m_head = CodingAssistMenu.this.m_head.substring(0, CodingAssistMenu.this.m_head.length() - 1);
                        CodingAssistMenu.this.m_model.removeAllElements();
                        int i = 0;
                        while (i < t_list.size()) {
                            CodingAssistMenu.this.m_model.addElement((String)t_list.get(i));
                            ++i;
                        }
                        CodingAssistMenu.this.m_stack.remove(t_list);
                    }
                } else {
                    String t_char = Character.toString(e.getKeyChar());
                    if (t_char.matches("[a-zA-Z_]")) {
                        ArrayList<String> t_list = new ArrayList<String>();
                        CodingAssistMenu codingAssistMenu = CodingAssistMenu.this;
                        codingAssistMenu.m_head = String.valueOf(codingAssistMenu.m_head) + t_char;
                        int i = CodingAssistMenu.this.m_model.getSize() - 1;
                        while (i >= 0) {
                            String t_elm = (String)CodingAssistMenu.this.m_model.get(i);
                            t_list.add(t_elm);
                            if (!t_elm.toLowerCase().startsWith(CodingAssistMenu.this.m_head)) {
                                CodingAssistMenu.this.m_model.remove(i);
                            }
                            --i;
                        }
                        Collections.sort(t_list);
                        CodingAssistMenu.this.m_stack.add(t_list);
                        if (CodingAssistMenu.this.m_model.getSize() == 0) {
                            CodingAssistMenu.this.m_answer = CodingAssistMenu.this.m_head;
                            CodingAssistMenu.this.setVisible(false);
                        }
                    }
                }
            }
        });
        scrollPane.setViewportView(this._list);
        if (src != null) {
            this.initMenu(src, caretpos, class_list);
        }
    }

    private String findVarName(String src) {
        String t_src = src;
        if (!src.matches("^[\\s\\S]*\\)$")) {
            ArrayList<String> t_list = CodeProcessor.escDQStrings(src, "@");
            if (t_list.get(0).contains("\"")) {
                return "";
            }
            return t_src.replaceFirst("^[\\s\\S]*[,\\{;\\s\\+\\*\\(\\-/=]([\\w\\.\\$#]+)$", "$1");
        }
        t_src = t_src.replaceAll("\\s*([\\)\\(\\+\\-,\\*/])\\s*", "$1");
        int _level = 0;
        int len = t_src.length();
        int i = 1;
        while (i < len + 1) {
            if (i == len && _level == 0) {
                return t_src;
            }
            String c_str = t_src.substring(len - i, len - i + 1);
            if (_level == 0 && c_str.matches("[=\\s\\-\\+\\*/,;\\{\\(]")) {
                return t_src.substring(len - i + 1);
            }
            if (c_str.equals(")")) {
                ++_level;
            } else if (c_str.equals("(")) {
                --_level;
            }
            ++i;
        }
        return "";
    }

    private void initMenu(String src, int caretpos, HashMap<String, Class<?>> class_list) {
        String t_str = src.substring(0, caretpos);
        if ((t_str = this.findVarName(t_str)).length() == 0) {
            return;
        }
        this.m_target = t_str;
        try {
            Method[] ms;
            src = CodeProcessor.preProcess4Import(src);
            HashMap<String, Class<?>> t_map = CodeProcessor.analyzeVarToClass(new StringBuilder(src), class_list);
            if (CodeProcessor._importList.containsKey(t_str)) {
                t_str = CodeProcessor._importList.get(t_str);
            }
            Class<?> t_c = null;
            if (t_str.endsWith("]")) {
                String cname = t_str.replaceFirst("\\[.*\\]", "");
                Class<?> t_c0 = t_map.get(cname);
                if (t_c0 == null) {
                    return;
                }
                t_c = t_c0.getComponentType();
            } else {
                t_c = t_map.get(t_str);
            }
            if (t_c == null) {
                if (t_str.contains("\"")) {
                    return;
                }
                t_c = Tool.forName(t_str);
                ms = t_c.getMethods();
                Arrays.sort(ms, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        return m1.getName().compareTo(m2.getName());
                    }
                });
                int i = 0;
                while (i < ms.length) {
                    if (!this.m_model.contains(String.valueOf(ms[i].getName()) + "()") && Modifier.isStatic((int)ms[i].getModifiers())) {
                        this.m_model.addElement(String.valueOf(ms[i].getName()) + this.getMethodDetail(ms[i]));
                        this.makeExcps(ms[i]);
                    }
                    ++i;
                }
            } else if (t_c.isArray()) {
                this.m_model.addElement("length : int");
            } else {
                ms = t_c.getMethods();
                Arrays.sort(ms, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        return m1.getName().compareTo(m2.getName());
                    }
                });
                int i = 0;
                while (i < ms.length) {
                    if ((this.m_filter == null || this.m_filter.equals(ms[i].getReturnType().getName())) && !this.m_model.contains(String.valueOf(ms[i].getName()) + this.getMethodDetail(ms[i]))) {
                        this.m_model.addElement(String.valueOf(ms[i].getName()) + this.getMethodDetail(ms[i]));
                        this.makeExcps(ms[i]);
                    }
                    ++i;
                }
                ClassOutLine c_line = Tool.getClassOutLine(t_c.getName());
                if (c_line != null) {
                    HashMap<String, String> t_fs = c_line.getFields(this.m_fake);
                    ArrayList<String> t_list = new ArrayList<String>();
                    for (Map.Entry<String, String> entry : t_fs.entrySet()) {
                        t_list.add(String.valueOf(entry.getKey()) + " : " + entry.getValue());
                    }
                    Collections.sort(t_list);
                    int j = 0;
                    while (j < t_list.size()) {
                        this.m_model.addElement((String)t_list.get(j));
                        ++j;
                    }
                }
            }
        }
        catch (Fson.NotSupportedClassException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException | NotFoundException e1) {
            Tool.logIfDebug(e1, "@CodingAssistMennu#initMenu");
        }
    }

    private void makeExcps(Method ms) {
        Class<?>[] t_exps = ms.getExceptionTypes();
        if (t_exps != null && t_exps.length > 0) {
            this.m_excmap.put(String.valueOf(ms.getName()) + this.getMethodDetail(ms), t_exps);
        }
    }

    private void makeCatches(Class<?>[] exlist) {
        if (exlist != null) {
            String t_catch = ";\n";
            int i = 0;
            while (i < exlist.length) {
                t_catch = String.valueOf(t_catch) + "} catch (" + exlist[i].getName() + " e) { e.printStackTrace();\n";
                ++i;
            }
            this.m_catches = t_catch = String.valueOf(t_catch) + "}";
        }
    }

    private String getMethodDetail(Method m) {
        String t_str = "(";
        String str_args = "";
        Class<?>[] t_args = m.getParameterTypes();
        int i = 0;
        while (i < t_args.length) {
            str_args = this.m_filter != null ? String.valueOf(str_args) + t_args[i].getName() : String.valueOf(str_args) + t_args[i].getSimpleName();
            if (i < t_args.length - 1) {
                str_args = String.valueOf(str_args) + ",";
            }
            ++i;
        }
        Class<?> t_c = m.getReturnType();
        t_str = String.valueOf(t_str) + str_args + ") :" + t_c.getName();
        return t_str;
    }
}

