/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.TestCaseRecord;
import java.text.NumberFormat;
import java.util.ArrayList;

public class TestLogger {
    private static String s_suiteName;
    private static int s_countCmds;
    private static int s_skipped;
    private static int s_disabled;
    private static int s_errors;
    private static int s_failures;
    private static int s_asserts;
    private static long s_milisec;
    private static NumberFormat s_formatsec;
    private static String s_curCaseName;
    private static ArrayList<String> s_results;
    private static String s_out;
    private static String s_err;
    private static boolean s_preparing;

    static {
        s_formatsec = NumberFormat.getNumberInstance();
        s_curCaseName = null;
        s_results = new ArrayList();
        s_out = null;
        s_err = null;
        s_preparing = true;
    }

    public void initLog() {
        s_formatsec.setMaximumIntegerDigits(3);
        s_formatsec.setMinimumIntegerDigits(3);
        s_formatsec.setMaximumFractionDigits(2);
        s_formatsec.setMinimumFractionDigits(2);
    }

    public static void beginTestSuite(TestCaseRecord carec) {
        s_results.clear();
        s_countCmds = 0;
        s_errors = 0;
        s_failures = 0;
        s_skipped = 0;
        s_disabled = 0;
        s_asserts = 0;
        s_out = "";
        s_err = "";
        s_milisec = 0L;
        s_suiteName = carec.name;
    }

    public static String endTestSuite() {
        String stime = s_formatsec.format((double)s_milisec / 1000.0);
        String t_result = "<testsuite name=\"" + s_suiteName + "\" tests=\"" + Integer.toString(s_countCmds) + "\" disabled=\"" + Integer.toString(s_disabled) + "\" skipped=\"" + Integer.toString(s_skipped) + "\" assertions=\"" + Integer.toString(s_asserts) + "\" errors=\"" + Integer.toString(s_errors) + "\" failures=\"" + Integer.toString(s_failures) + "\" time=\"" + stime + "\">\n";
        int i = 0;
        while (i < s_results.size()) {
            t_result = String.valueOf(t_result) + s_results.get(i);
            ++i;
        }
        t_result = String.valueOf(t_result) + "<system-out>" + s_out + "</system-out>\n";
        t_result = String.valueOf(t_result) + "<system-err>" + s_err + "</system-err>\n";
        t_result = String.valueOf(t_result) + "</testsuite>\n";
        return t_result;
    }

    public static void cmdPrepare(String name) {
        s_curCaseName = name;
        s_preparing = true;
    }

    public static void cmdBegin(String name) {
        ++s_countCmds;
        s_curCaseName = name;
        s_preparing = false;
    }

    public static String cmdName() {
        return String.valueOf(s_suiteName) + "(" + s_curCaseName + ")";
    }

    public static void cmdIsOK(long xtime, String inName, int nasserts) {
        String stime = s_formatsec.format((double)xtime / 1000.0);
        s_milisec += xtime;
        s_asserts += nasserts;
        String t_result = "<testcase classname=\"" + s_suiteName + "\" name=\"" + s_curCaseName + "\" assertions=\"" + Integer.toString(nasserts) + "\" time=\"" + stime + "\"/>\n";
        s_results.add(t_result);
    }

    public static void cmdFailed(long xtime, String msg, String inName, int nasserts) {
        if (s_preparing) {
            ++s_countCmds;
            s_preparing = false;
        }
        ++s_failures;
        String stime = s_formatsec.format((double)xtime / 1000.0);
        s_milisec += xtime;
        s_asserts += nasserts;
        String t_result = "<testcase classname=\"" + s_suiteName + "\" name=\"" + s_curCaseName + "\" assertions=\"" + Integer.toString(nasserts) + "\" time=\"" + stime + "\">\n";
        t_result = String.valueOf(t_result) + "<failure type=\"AssertionError\" message=\"test failed\">" + msg + "</failure>\n";
        t_result = String.valueOf(t_result) + "</testcase>\n";
        s_results.add(t_result);
    }

    public static void cmdCauseError(long xtime, String msg, String inName, Throwable ... excpts) {
        if (s_preparing) {
            ++s_countCmds;
            s_preparing = false;
        }
        ++s_failures;
        ++s_errors;
        String stime = s_formatsec.format((double)xtime / 1000.0);
        s_milisec += xtime;
        String t_result = "<testcase classname=\"" + s_suiteName + "\" name=\"" + s_curCaseName + "\" time=\"" + stime + "\">\n";
        String str_classes = "";
        int i = 0;
        while (i < excpts.length) {
            if (str_classes.length() > 0) {
                str_classes = String.valueOf(str_classes) + "|";
            }
            if (excpts[i] != null) {
                str_classes = String.valueOf(str_classes) + excpts[i].getClass().getName();
            }
            ++i;
        }
        t_result = String.valueOf(t_result) + "<error type=\"" + str_classes + "\" message=\"UnexpectedException\">" + msg + "</error>\n";
        t_result = String.valueOf(t_result) + "</testcase>\n";
        s_results.add(t_result);
    }

    public static void cmdSkipped(long xtime, String inName) {
        String t_result = "<testcase classname=\"" + s_suiteName + "\" name=\"" + s_curCaseName + "\"/>\n";
        s_results.add(t_result);
        s_results.add("<skipped/>\n");
        s_results.add("</testcase>");
        ++s_skipped;
        if (s_preparing) {
            s_preparing = false;
        }
    }

    public static void cmdDisabled(long xtime, String inName) {
        String t_result = "<testcase classname=\"" + s_suiteName + "\" name=\"" + s_curCaseName + "\"/>\n";
        s_results.add(t_result);
        s_results.add("<skipped/>\n");
        s_results.add("</testcase>");
        ++s_disabled;
        if (s_preparing) {
            s_preparing = false;
        }
    }

    public static void out(String str) {
        s_out = String.valueOf(s_out) + str + "\n";
    }

    public static void err(String str) {
        if (s_err != null) {
            s_err = String.valueOf(s_err) + str + "\n";
        }
    }
}

