############################################################
#
# ФˤRSSưɽޤ
# <pre>
# {{rss RSSURL}}
# </pre>
#
############################################################
package plugin::rss::RSS;
#use strict;
use LWP::UserAgent;
#===========================================================
# 󥹥ȥ饯
#===========================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#===========================================================
# ѥ饰
#===========================================================
sub paragraph {
	my $self = shift;
	my $wiki = shift;
	my $url  = shift;
	
	if($url eq ""){
		return &Util::paragraph_error("RSSURLꤵƤޤ");
	}
	# åեιå
	my $filename = $url;
	my $cache = $wiki->config('log_dir')."/".&Util::url_encode($filename).".rss";
	my $readflag = 0;
	if(-e $cache){
		my @status = stat($cache);
		if($status[9]+(60*60) > time()){
			$readflag = 1;
		}
	}
	
	my $content = "";
	if($readflag==0){
		# URLRSS
		$content = &Util::get_response($wiki,$url) or return &Util::paragraph_error($!);
		
		# EUCѴʽϤȤѴΤȡ
		#&Jcode::convert(\$content, "euc");
		
		# å
		open(RSS,">$cache") or return &Util::error($!);
		print RSS $content;
		close(RSS);
		
	} else {
		# 뤫RSS
		open(RSS,$cache) or return &Util::error($!);
		while(<RSS>){ $content .= $_; }
		close(RSS);
	}
	# XMLե뤫ɤå
	if(index($content,"<?xml version")!=0){
		return &Util::paragraph_error("XMLեǤϤޤ");
	}
	my @status = stat($cache);
	
	# ѡɽ
	return $self->parse_rss(\$content);
}
#===========================================================
# RSSѡHTML
#===========================================================
sub parse_rss {
	my $self    = shift;
	my $content = shift;
	my $buf  = "<ul>\n";
	
	my $version = "1.0";
	if(index($$content,"<rss version=\"0.91\">")!=-1){
		$version = "0.91";
	}
	
	if($version eq "1.0"){
		$$content =~ m#(/channel>|/language>)#gsi;
	}
	
	my $count=0;
	
	while ($$content =~ m|<item[ >](.+?)</item|gsi) {
		
		my $item = $1;
		
		my $link  = "";
		my $title = "";
		my $date  = "";
		
		$item =~ m#title>([^<]+)</#gs;
		$title = $1;
		
		$item =~ m#link>([^<]+)</#gs;
		$link = $1;
		$link =~ s/\s".*//g; # ֥륯ơʹߤڤȤ
		
		if ($version eq "1.0") {
			if ($item =~ m#(description|dc\:date)>([^<]+)</#gs) {
				$date = $2;
			}
		} elsif ($version eq "0.91") {
			if($item =~ m#description>([^<]+)</#gs){
				$date = $1;
			}
		}
		&Jcode::convert(\$title,'euc');
		&Jcode::convert(\$date ,'euc');
		$buf .= "<li><a href=\"$link\">$title</a>";
		if($date ne ""){
			$buf .= " - $date";
		}
		$buf .= "</li>\n";
		
		$count++;
		if($count>50){ last; }
	}
	
	return $buf."</ul>\n";
}

1;
