###############################################################################
#
# Wiki API
#
###############################################################################
package Wiki;
#use strict;
use Wiki::HTMLParser;
use Wiki::DefaultStorage;
use vars qw($VERSION $DEBUG);
$VERSION = '3.5.1';
$DEBUG   = 0;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	
	# 󥹥ѿ
	$self->{"handler"}            = {};
	$self->{"handler_permission"} = {};
	$self->{"plugin"}             = {};
	$self->{"title"}              = "";
	$self->{"menu"}               = [];
	$self->{"CGI"}                = shift;
	$self->{"hook"}               = {};
	$self->{"user"}               = ();
	$self->{"admin_menu"}         = ();
	$self->{"editform"}           = ();
	$self->{"edit"}               = 0;
	$self->{"parse_times"}        = 0;
	
	# ɤ߹
	my $setupfile = shift || 'setup.dat';
	$self->{"config"}  = &Util::load_config_hash(undef,$setupfile);
	die "setup file ${setupfile} not found" if scalar(%{$self->{"config"}}) == 0;
	$self->{"config"}->{"plugin_dir"} = "." unless exists($self->{"config"}->{"plugin_dir"});
	unshift(@INC, $self->{"config"}->{"plugin_dir"});
	
	# ȥ졼Υ󥹥󥹤
	if($self->{config}->{"storage"} eq ""){
		$self->{"storage"} = Wiki::DefaultStorage->new($self);
	} else {
		eval ("use ".$self->{config}->{"storage"}.";");
		$self->{"storage"} = $self->{config}->{"storage"}->new($self);
	}
	
	return bless $self,$class;
}

###############################################################################
#
# 桼طΥ᥽åɷ
#
###############################################################################
#==============================================================================
# 桼ɲäޤ
#==============================================================================
sub add_user {
	my $self = shift;
	my $id   = shift;
	my $pass = shift;
	my $type = shift;
	
	push(@{$self->{"user"}},{id=>$id,pass=>$pass,type=>$type});
}

#==============================================================================
# 桼¸ߤ뤫ɤǧޤ
#==============================================================================
sub user_exists {
	my $self = shift;
	my $id   = shift;
	foreach my $user (@{$self->{"user"}}){
		if($user->{id} eq $id){
			return 1;
		}
	}
	return 0;
}

#==============================================================================
# ޤ
#==============================================================================
sub get_login_info {
	my $self    = shift;
	my $cgi     = $self->get_CGI();
	my $session = $cgi->get_session($self);
	my $id   = $session->param("wiki_id");
	my $type = $session->param("wiki_type");
	my $path = $session->param("wiki_path");
	
	# PATH_INFOĴ٤
	my $path_info = $cgi->path_info();
	if(!defined($path_info)){ $path_info  = ""; }
	if(!defined($path     )){ $path       = ""; }
	if(!defined($id       )){ $id         = ""; }
	if(!defined($type     )){ $type       = ""; }
	
	if($path_info eq "" && $path ne ""){
		return undef;
	} elsif($path ne "" && !($path =~ /^$path_info($|\/)/)){
		return undef;
	}
	
	# ååȤƤʤ
	if($id eq "" ||  $type eq ""){
		return undef;
	}
	
	# 桼ֵ
	return {id=>$id,type=>$type,path=>$path};
}

#==============================================================================
# åԤޤ
#==============================================================================
sub login_check {
	my $self = shift;
	my $id   = shift;
	my $pass = shift;
	my $path = $self->get_CGI()->path_info();
	foreach(@{$self->{"user"}}){
		if($_->{id} eq $id && $_->{pass} eq $pass){
			return {id=>$id,pass=>$pass,type=>$_->{type},path=>$path};
		}
	}
	return undef;
}

###############################################################################
#
# ץ饰طΥ᥽åɷ
#
###############################################################################
#==============================================================================
# ԽեѤΥץ饰ɲäޤ
#==============================================================================
sub add_editform_plugin {
	my $self   = shift;
	my $plugin = shift;
	my $weight = shift;
	push(@{$self->{"editform"}},{class=>$plugin,weight=>$weight});
}

#==============================================================================
# ԽեѤΥץ饰νϤޤ
#==============================================================================
sub get_editform_plugin {
	my $self = shift;
	my $buf = "";
	foreach my $plugin (sort { $b->{weight}<=>$a->{weight} } @{$self->{"editform"}}){
		my $obj = $self->get_plugin_instance($plugin->{class});
		$buf .= $obj->editform($self)."\n";
	}
	return $buf;
}

#==============================================================================
# ѤΥ˥塼ɲäޤ
# ԥ桼󤷤ɽޤ
#==============================================================================
sub add_admin_menu {
	my $self   = shift;
	my $label  = shift;
	my $url    = shift;
	my $weight = shift;
	push(@{$self->{"admin_menu"}},{label=>$label,url=>$url,weight=>$weight});
}

#==============================================================================
# ѤΥ˥塼ޤ
#==============================================================================
sub get_admin_menu {
	my $self = shift;
	
	return sort { $b->{weight}<=>$a->{weight} } @{$self->{"admin_menu"}};
}

#==============================================================================
# ȥ졼ꤷޤ
# (3.5.1dev5setup.datǻꤹ褦ˤ)
#==============================================================================
#sub set_storage {
#	my $self = shift;
#	$self->{storage} = shift;
#}

#==============================================================================
# ץ饰򥤥󥹥ȡ뤷ޤ
#==============================================================================
sub install_plugin {
	my $self   = shift;
	my $plugin = shift;
	my $module = "plugin::${plugin}::Install";
	
	eval 'require &Util::get_module_file($module);'.$module.'::install($self);';
	
	return $@ ? $self->error("${plugin}ץ饰󤬥󥹥ȡǤޤ$@") : '';
}

#==============================================================================
# ˥塼ܤɲäޤ
#==============================================================================
sub add_menu {
	my $self   = shift;
	my $name   = shift;
	my $href   = shift;
	my $weight = shift;
	
	my $flag = 0;
	foreach(@{$self->{"menu"}}){
		if($_->{name} eq $name){
			$_->{href} = $href;
			$flag = 1;
			last;
		}
	}
	if($flag==0){
		push(@{$self->{"menu"}},{name=>$name,href=>$href,weight=>$weight});
	}
}

#===============================================================================
# եåϿ
#===============================================================================
sub add_hook {
	my $self = shift;
	my $name = shift;
	my $obj  = shift;
	
	push(@{$self->{"hook"}->{$name}},$obj);
}

#===============================================================================
# եåθƤӽФ
#===============================================================================
sub do_hook {
	my $self = shift;
	my $name = shift;
	
	foreach my $class (@{$self->{"hook"}->{$name}}){
		my $obj = $self->get_plugin_instance($class);
		$obj->hook($self,$name);
	}
}

#==============================================================================
# ϥɥɲ
#==============================================================================
sub add_handler {
	my $self = shift;
	my $action = shift;
	my $class = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 1;
}

#==============================================================================
# ѤΥϥɥɲ
#==============================================================================
sub add_admin_handler {
	my $self = shift;
	my $action = shift;
	my $class = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 0;
}
#==============================================================================
# 饤ץ饰ɲäޤ
#
# 3.4ϤȤθߴݻ뤿˻Ĥޤ
# 3.6ѻߤΤȤޤ
#==============================================================================
sub add_plugin {
	my $self   = shift;
	my $name   = shift;
	my $class  = shift;
	
	$self->add_inline_plugin($name,$class,"HTML");
}
#==============================================================================
# 饤ץ饰ɲ
#==============================================================================
sub add_inline_plugin {
	my $self   = shift;
	my $name   = shift;
	my $class  = shift;
	my $format = shift;
	
	if($format eq ""){
		$format = "HTML";
	} else {
		$format = uc($format);
	}
	
	$self->{"plugin"}->{$name} = {CLASS=>$class,TYPE=>'inline',FORMAT=>$format};
}

#==============================================================================
# ѥ饰եץ饰ɲ
#==============================================================================
sub add_paragraph_plugin {
	my $self   = shift;
	my $name   = shift;
	my $class  = shift;
	my $format = shift;
	
	if($format eq ""){
		$format = "HTML";
	}
	
	$self->{"plugin"}->{$name} = {CLASS=>$class,TYPE=>'paragraph',FORMAT=>$format};
}

#==============================================================================
# ץ饰ξޤ
#
# my $info = get_plugin_info("include");
# my $class  = $info->{CLASS};  # ץ饰Υ饹̾
# my $type   = $info->{TYPE};   # inlineޤparagraph
# my $format = $info->{FORMAT}; # HTMLޤWIKI
#==============================================================================
sub get_plugin_info {
	my $self = shift;
	my $name = shift;
	
	return $self->{plugin}->{$name};
}

#==============================================================================
# ϥɥưޤ
#==============================================================================
sub call_handler {
	my $self   = shift;
	my $action = shift;
	if(!defined($action)){ $action = ""; }
	
	my $obj = $self->get_plugin_instance($self->{"handler"}->{$action});
	
	if($self->{"handler_permission"}->{$action}==0){
		# ѤΥ
		my $login = $self->get_login_info();
		if(!defined($login)){
			return $self->error("󤷤Ƥޤ");
			
		} elsif($login->{type}!=0){
			return $self->error("Ը¤ɬפǤ");
		}
		return $obj->do_action($self).
		       "<div class=\"comment\"><a href=\"".$self->config('script_name')."?action=LOGIN\">˥塼</a></div>";
	
	} else {
		# ̤Υ
		return $obj->do_action($self);
	}
}

#===============================================================================
# Ϥ줿ʸWikiޤ
#===============================================================================
sub process_wiki {
	my $self    = shift;
	my $source  = shift;
	my $mainflg = shift;
	
	if($self->{parse_times} >= 50){
		return $self->error("Wiki::process_wikiθƤӽФ¤ۤޤ");
	}
	
	$self->{parse_times}++;
	my $parser = Wiki::HTMLParser->new($self,$mainflg);
	$parser->parse($source);
	$self->{parse_times}--;
	
	return $parser->{html};
}

#===============================================================================
# 饤ץ饰󡢥ѥ饰եץ饰θƤӽФѤδؿ
#===============================================================================
sub process_plugin {
	my $self   = shift;
	my $plugin = shift;
	my $parser = shift;
	
	if(defined($plugin->{error}) && $plugin->{error} ne ""){
		return "<font class=\"error\">".$plugin->{error}."</font>";
	}
	
	my $name = $plugin->{command};
	my @args = @{$plugin->{args}};
	my $info = $self->get_plugin_info($name);
	
	my $obj = $self->get_plugin_instance($info->{CLASS});
	
	if(!defined($obj)){
		return "<font class=\"error\">".&Util::escapeHTML($name)."ץ饰¸ߤޤ</font>";
		
	} else {
		if($info->{FORMAT} eq "WIKI"){
			$obj->{parser} = $parser; # ΢
			if($info->{TYPE} eq "inline"){
				return $parser->parse_line($obj->inline($self,@args));
			} else {
				$parser->parse($obj->paragraph($self,@args));
				return undef;
			}
		} else {
			if($info->{TYPE} eq "inline"){
				return $obj->inline($self,@args);
			} else {
				return $obj->paragraph($self,@args);
			}
		}
	}
}

#==============================================================================
# 顼ξ硢ƤӽФޤ
# ϥɥ餫饨顼𤹤ݤ˻ѤƤ
#==============================================================================
sub error {
	my $self    = shift;
	my $message = shift;
	
	$self->set_title("顼");
	$self->get_CGI->param("action","ERROR");
	
	return "<div class=\"error\">".Util::escapeHTML($message)."</div>";
}


#===============================================================================
# ץ饰Υ󥹥󥹤ޤ
#===============================================================================
sub get_plugin_instance {
	my $self  = shift;
	my $class = shift;
	
	if($class eq ""){
		return undef;
	}
	
	if(!defined($self->{instance}->{$class})){
		eval {
			require &Util::get_module_file($class);
		};
		return undef if $@;
		my $obj = $class->new();
		$self->{instance}->{$class} = $obj;
		
		return $obj;
	} else {
		return $self->{instance}->{$class};
	}
}

#===============================================================================
# 饤ץ饰ѡƥޥɤȰʬ
#===============================================================================
sub parse_inline_plugin {
	my $self = shift;
	my $text = shift;
	my ($cmd,@args_tmp) = split(/ /,$text);
	my $args_txt = &Util::trim(join(" ",@args_tmp));
	
	my @ret_args;
	my $tmp    = "";
	my $escape = 0;
	my $quote  = 0;
	
	for(my $i=0;$i<length($args_txt);$i++){
		my $c = substr($args_txt,$i,1);
		
		if($quote!=1 && $c eq ","){
			if($tmp ne ""){
				push(@ret_args,$tmp);
				$tmp = "";
				$quote = 0;
			}
		} elsif($quote==1 && $c eq "\\"){
			if($escape==0){
				$escape = 1;
			} else {
				$tmp .= $c;
				$escape = 0;
			}
		} elsif($quote==0 && $c eq '"'){
			if($tmp eq ""){
				$quote = 1;
			} else {
				$tmp .= $c;
			}
		} elsif($quote==1 && $c eq '"'){
			if($escape==1){
				$tmp .= $c;
				$escape = 0;
			} else {
				$quote = 2;
			}
		} elsif($quote==2){
			return {error=>"饤ץ饰ιʸǤ"};
		} else {
			$tmp .= $c;
		}
	}
	
	if($tmp ne ""){
		push(@ret_args,$tmp);
	}
	
	return {command=>$cmd,args=>\@ret_args};
}

###############################################################################
#
# ˴ؤ᥽åɷ
#
###############################################################################
#==============================================================================
# ڡ뤷ޤ
#==============================================================================
sub freeze_page {
	my $self = shift;
	$self->{"storage"}->freeze_page(@_);
}

#==============================================================================
# ڡޤ
#==============================================================================
sub un_freeze_page {
	my $self = shift;
	$self->{"storage"}->un_freeze_page(@_);
}

#==============================================================================
# ꥹȤ
#==============================================================================
sub get_freeze_list {
	my $self = shift;
	return $self->{"storage"}->get_freeze_list();
}

#==============================================================================
# Ϥڡ椫ɤ٤ޤ
#==============================================================================
sub is_freeze {
	my $self = shift;
	return $self->{storage}->is_freeze(@_);
}

#==============================================================================
# ڡԽǤ뤫ɤåޤ
#==============================================================================
sub can_modify_page {
	my $self = shift;
	my $page = shift;
	my $login = $self->get_login_info();
	if($self->config('accept_edit')==0 && !defined($login)){
		return 0;
	}
	if($self->is_freeze($page) && (!defined($login) || $login->{type}!=0)){
		return 0;
	}
	unless($self->can_show($page)){
		return 0;
	}
	return 1;
}

###############################################################################
#
# ȸ¤˴ؤ᥽åɷ
#
###############################################################################
#==============================================================================
# ڡλȥ٥ꤷޤ
# 0˸ 1桼˸ 2Ԥ˸
#==============================================================================
sub set_page_level {
	my $self  = shift;
	my $page  = shift;
	my $level = shift;
	
	$self->{"storage"}->set_page_level($page,$level);
}

#==============================================================================
# ڡλȥ٥ޤ
# ڡ̾ꤵƤʤ硢ƤΥڡλȥ٥
# ϥåե󥹤֤ޤ
# 0˸ 1桼˸ 2Ԥ˸
#==============================================================================
sub get_page_level {
	my $self  = shift;
	my $page  = shift;
	
	$self->{"storage"}->get_page_level($page);
}

#==============================================================================
# ڡȲǽɤޤ
#==============================================================================
sub can_show {
	my $self = shift;
	my $page = shift;
	my $login = $self->get_login_info();
	my $level = $self->get_page_level($page);
	
	if($level==1 && !defined($login)){
		return 0;
	} elsif($level==2 && (!defined($login) || $login->{type}!=0)){
		return 0;
	}
	return 1;
}

###############################################################################
#
# ¾Υ᥽åɷ
#
###############################################################################
#==============================================================================
# ȥ
#==============================================================================
sub set_title {
	my $self  = shift;
	my $title = shift;
	my $edit  = shift;
	$self->{"title"} = $title;
	$self->{"edit"}  = 1 if $edit;
}

#==============================================================================
# ȥ
#==============================================================================
sub get_title {
	my $self = shift;
	return $self->{"title"};
}

#==============================================================================
# ڡΰ
#==============================================================================
sub get_page_list {
	my $self = shift;
	return $self->{"storage"}->get_page_list();

}

#==============================================================================
# ڡΰʻȸ¤ΤΤΤߡˤ
#==============================================================================
sub get_page_list2 {
	my $self = shift;
	my @pages = $self->get_page_list();
	my @result;
	foreach my $page (@pages){
		if($self->can_show($page)){
			push(@result,$page);
		}
	}
	return @result;
}

#==============================================================================
# ڡκǽ
#==============================================================================
sub get_last_modified {
	my $self = shift;
	return $self->{"storage"}->get_last_modified(@_);
}

#==============================================================================
# ڡ
#==============================================================================
sub get_page {
	my $self = shift;
	return $self->{"storage"}->get_page(@_);
}

#==============================================================================
# Хååפ
#==============================================================================
sub get_backup {
	my $self = shift;
	return $self->{"storage"}->get_backup(@_);
}

#==============================================================================
# ڡ¸
#==============================================================================
sub save_page {
	my $self = shift;
	my $pagename = shift;
	my $content  = shift;
	$self->do_hook("save_before");
	
	$self->{"storage"}->save_page($pagename,$content);
	$self->get_CGI->param("page"   ,$pagename);
	$self->get_CGI->param("content",$content);
	
	if($content ne ""){
		$self->do_hook("save_after");
	} else {
		$self->do_hook("delete");
	}
}

#===============================================================================
# ڡ¸ߤ뤫ɤĴ٤
#===============================================================================
sub page_exists {
	my $self = shift;
	return $self->{"storage"}->page_exists(@_);
}

#===============================================================================
# CGI֥Ȥ
#===============================================================================
sub get_CGI {
	my $self = shift;
	return $self->{"CGI"};
}

#==============================================================================
# Υڡ˥쥯Ȥޤ
#==============================================================================
sub redirect {
	my $self = shift;
	my $page = shift;
	
	my $tmpl = HTML::Template->new(filename=>$self->config('tmpl_dir')."/redirect.tmpl",
	                               die_on_bad_params => 0);
	
	$tmpl->param(URL=>$self->config('script_name')."?page=".&Util::url_encode($page));
	
	print "Content-Type: text/html\n\n";
	print $tmpl->output();
	exit;
}

#==============================================================================
# Х⤷ѹޤ
#==============================================================================
sub config {
	my $self  = shift;
	my $name  = shift;
	my $value = shift;
	if(defined($value)){
		$self->{config}->{$name} = $value;
	} else {
		return $self->{config}->{$name};
	}
}

1;
