/**
 * Manage the courses view for the overview block.
 *
 * @copyright  2018 Bas Brands <bas@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_myoverview/view",["jquery","block_myoverview/repository","core/paged_content_factory","core/pubsub","core/custom_interaction_events","core/notification","core/templates","core_course/events","block_myoverview/selectors","core/paged_content_events","core/aria"],(function($,Repository,PagedContentFactory,PubSub,CustomEvents,Notification,Templates,CourseEvents,Selectors,PagedContentEvents,Aria){var SELECTORS_ACTION_HIDE_COURSE='[data-action="hide-course"]',SELECTORS_ACTION_SHOW_COURSE='[data-action="show-course"]',SELECTORS_ACTION_ADD_FAVOURITE='[data-action="add-favourite"]',SELECTORS_ACTION_REMOVE_FAVOURITE='[data-action="remove-favourite"]',SELECTORS_FAVOURITE_ICON='[data-region="favourite-icon"]',SELECTORS_ICON_IS_FAVOURITE='[data-region="is-favourite"]',SELECTORS_ICON_NOT_FAVOURITE='[data-region="not-favourite"]',TEMPLATES_COURSES_CARDS="block_myoverview/view-cards",TEMPLATES_COURSES_LIST="block_myoverview/view-list",TEMPLATES_COURSES_SUMMARY="block_myoverview/view-summary",TEMPLATES_NOCOURSES="core_course/no-courses",GROUPINGS_GROUPING_ALLINCLUDINGHIDDEN="allincludinghidden",NUMCOURSES_PERPAGE=[12,24,48,96,0],loadedPages=[],courseOffset=0,lastPage=0,lastLimit=0,namespace=null,getFilterValues=function(root){var courseRegion=root.find(Selectors.courseView.region);return{display:courseRegion.attr("data-display"),grouping:courseRegion.attr("data-grouping"),sort:courseRegion.attr("data-sort"),displaycategories:courseRegion.attr("data-displaycategories"),customfieldname:courseRegion.attr("data-customfieldname"),customfieldvalue:courseRegion.attr("data-customfieldvalue")}},DEFAULT_PAGED_CONTENT_CONFIG={ignoreControlWhileLoading:!0,controlPlacementBottom:!0,persistentLimitKey:"block_myoverview_user_paging_preference"},getFavouriteIconContainer=function(root,courseId){return root.find(SELECTORS_FAVOURITE_ICON+'[data-course-id="'+courseId+'"]')},getPagedContentContainer=function(root,index){return root.find('[data-region="paged-content-page"][data-page="'+index+'"]')},getCourseId=function(root){return root.attr("data-course-id")},getAddFavouriteMenuItem=function(root,courseId){return root.find('[data-action="add-favourite"][data-course-id="'+courseId+'"]')},getRemoveFavouriteMenuItem=function(root,courseId){return root.find('[data-action="remove-favourite"][data-course-id="'+courseId+'"]')},addToFavourites=function(root,courseId){var removeAction=getRemoveFavouriteMenuItem(root,courseId),addAction=getAddFavouriteMenuItem(root,courseId);setCourseFavouriteState(courseId,!0).then((function(success){success?(PubSub.publish(CourseEvents.favourited,courseId),removeAction.removeClass("hidden"),addAction.addClass("hidden"),function(root,courseId){var iconContainer=getFavouriteIconContainer(root,courseId),isFavouriteIcon=iconContainer.find(SELECTORS_ICON_IS_FAVOURITE);isFavouriteIcon.removeClass("hidden"),Aria.unhide(isFavouriteIcon);var notFavourteIcon=iconContainer.find(SELECTORS_ICON_NOT_FAVOURITE);notFavourteIcon.addClass("hidden"),Aria.hide(notFavourteIcon)}(root,courseId)):Notification.alert("Starring course failed","Could not change favourite state")})).catch(Notification.exception)},removeFromFavourites=function(root,courseId){var removeAction=getRemoveFavouriteMenuItem(root,courseId),addAction=getAddFavouriteMenuItem(root,courseId);setCourseFavouriteState(courseId,!1).then((function(success){success?(PubSub.publish(CourseEvents.unfavorited,courseId),removeAction.addClass("hidden"),addAction.removeClass("hidden"),function(root,courseId){var iconContainer=getFavouriteIconContainer(root,courseId),isFavouriteIcon=iconContainer.find(SELECTORS_ICON_IS_FAVOURITE);isFavouriteIcon.addClass("hidden"),Aria.hide(isFavouriteIcon);var notFavourteIcon=iconContainer.find(SELECTORS_ICON_NOT_FAVOURITE);notFavourteIcon.removeClass("hidden"),Aria.unhide(notFavourteIcon)}(root,courseId)):Notification.alert("Starring course failed","Could not change favourite state")})).catch(Notification.exception)},getHideCourseMenuItem=function(root,courseId){return root.find('[data-action="hide-course"][data-course-id="'+courseId+'"]')},getShowCourseMenuItem=function(root,courseId){return root.find('[data-action="show-course"][data-course-id="'+courseId+'"]')},setCourseHiddenState=function(courseId,status){return!1===status&&(status=null),Repository.updateUserPreferences({preferences:[{type:"block_myoverview_hidden_course_"+courseId,value:status}]})},hideElement=function(root,id){var pagingBar=root.find('[data-region="paging-bar"]'),jumpto=parseInt(pagingBar.attr("data-active-page-number")),reducedCourse=loadedPages[jumpto].courses.reduce((function(accumulator,current){return id!=current.id&&accumulator.push(current),accumulator}),[]);if(null!=loadedPages[jumpto+1]){var newElement=loadedPages[jumpto+1].courses.slice(0,1);loadedPages.forEach((function(courseList,index){if(index>jumpto){var popElement=[];null!=loadedPages[index+1]&&(popElement=loadedPages[index+1].courses.slice(0,1)),loadedPages[index].courses=$.merge(loadedPages[index].courses.slice(1),popElement)}})),reducedCourse=$.merge(reducedCourse,newElement)}if(lastPage==jumpto+1&&0==loadedPages[jumpto+1].courses.length){var pagedContentContainer=root.find('[data-region="paged-content-container"]');PagedContentFactory.resetLastPageNumber($(pagedContentContainer).attr("id"),jumpto)}loadedPages[jumpto].courses=reducedCourse,courseOffset--;var pagedContentPage=getPagedContentContainer(root,jumpto);renderCourses(root,loadedPages[jumpto]).then((function(html,js){return Templates.replaceNodeContents(pagedContentPage,html,js)})).catch(Notification.exception),loadedPages.forEach((function(courseList,index){index>jumpto&&getPagedContentContainer(root,index).remove()}))},setCourseFavouriteState=function(courseId,status){return Repository.setFavouriteCourses({courses:[{id:courseId,favourite:status}]}).then((function(result){return 0==result.warnings.length&&(loadedPages.forEach((function(courseList){courseList.courses.forEach((function(course,index){course.id==courseId&&(courseList.courses[index].isfavourite=status)}))})),!0)})).catch(Notification.exception)},renderCourses=function(root,coursesData){var filters=getFilterValues(root),currentTemplate="";if(currentTemplate="card"==filters.display?TEMPLATES_COURSES_CARDS:"list"==filters.display?TEMPLATES_COURSES_LIST:TEMPLATES_COURSES_SUMMARY,coursesData.courses=coursesData.courses.map((function(course){return course.showcoursecategory="on"==filters.displaycategories,course})),coursesData.courses.length)return Templates.render(currentTemplate,{courses:coursesData.courses});var nocoursesimg=root.find(Selectors.courseView.region).attr("data-nocoursesimg");return Templates.render(TEMPLATES_NOCOURSES,{nocoursesimg:nocoursesimg})},setLimit=function(limit){this.find(Selectors.courseView.region).attr("data-paging",limit)},registerPagedEventHandlers=function(root,namespace){var event=namespace+PagedContentEvents.SET_ITEMS_PER_PAGE_LIMIT;PubSub.subscribe(event,setLimit.bind(root))},initializePagedContent=function(root){namespace="block_myoverview_"+root.attr("id")+"_"+Math.random();var pagingLimit=parseInt(root.find(Selectors.courseView.region).attr("data-paging"),10),itemsPerPage=NUMCOURSES_PERPAGE.map((function(value){var active=!1;return value==pagingLimit&&(active=!0),{value:value,active:active}})),totalCourseCount=parseInt(root.find(Selectors.courseView.region).attr("data-totalcoursecount"),10);itemsPerPage=itemsPerPage.filter((function(pagingOption){return pagingOption.value<totalCourseCount||0===pagingOption.value}));var filters=getFilterValues(root),config=$.extend({},DEFAULT_PAGED_CONTENT_CONFIG);config.eventNamespace=namespace;var pagedContentPromise=PagedContentFactory.createWithLimit(itemsPerPage,(function(pagesData,actions){var promises=[];return pagesData.forEach((function(pageData){var currentPage=pageData.pageNumber,limit=pageData.limit>0?pageData.limit:0;if(lastLimit!=limit&&(loadedPages=[],courseOffset=0,lastPage=0),lastPage==currentPage)return actions.allItemsLoaded(lastPage),void promises.push(renderCourses(root,loadedPages[currentPage]));lastLimit=limit,null==loadedPages[currentPage+1]&&null==loadedPages[currentPage]&&(limit*=2);var pagePromise=function(filters,limit){return Repository.getEnrolledCoursesByTimeline({offset:courseOffset,limit:limit,classification:filters.grouping,sort:filters.sort,customfieldname:filters.customfieldname,customfieldvalue:filters.customfieldvalue})}(filters,limit).then((function(coursesData){var courses=coursesData.courses,nextPageStart=0,pageCourses=[];if(null!=loadedPages[currentPage]){var currentPageLength=(pageCourses=loadedPages[currentPage].courses).length;currentPageLength<pageData.limit&&(nextPageStart=pageData.limit-currentPageLength,pageCourses=$.merge(loadedPages[currentPage].courses,courses.slice(0,nextPageStart)))}else nextPageStart=pageData.limit||!1,pageCourses=pageData.limit>0?courses.slice(0,pageData.limit):courses;loadedPages[currentPage]={courses:pageCourses};var remainingCourses=!1!==nextPageStart?courses.slice(nextPageStart,courses.length):[];return remainingCourses.length&&(loadedPages[currentPage+1]={courses:remainingCourses}),loadedPages[currentPage].courses.length<pageData.limit||!remainingCourses.length?(lastPage=currentPage,actions.allItemsLoaded(currentPage)):null!=loadedPages[currentPage+1]&&loadedPages[currentPage+1].courses.length<pageData.limit&&(lastPage=currentPage+1),courseOffset=coursesData.nextoffset,renderCourses(root,loadedPages[currentPage])})).catch(Notification.exception);promises.push(pagePromise)})),promises}),config);pagedContentPromise.then((function(html,js){return registerPagedEventHandlers(root,namespace),Templates.replaceNodeContents(root.find(Selectors.courseView.region),html,js)})).catch(Notification.exception)},registerEventListeners=function(root){CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,SELECTORS_ACTION_ADD_FAVOURITE,(function(e,data){var favourite=$(e.target).closest(SELECTORS_ACTION_ADD_FAVOURITE),courseId=getCourseId(favourite);addToFavourites(root,courseId),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS_ACTION_REMOVE_FAVOURITE,(function(e,data){var favourite=$(e.target).closest(SELECTORS_ACTION_REMOVE_FAVOURITE),courseId=getCourseId(favourite);removeFromFavourites(root,courseId),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS_FAVOURITE_ICON,(function(e,data){data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS_ACTION_HIDE_COURSE,(function(e,data){var target=$(e.target).closest(SELECTORS_ACTION_HIDE_COURSE),courseId=getCourseId(target);!function(root,courseId){var hideAction=getHideCourseMenuItem(root,courseId),showAction=getShowCourseMenuItem(root,courseId),filters=getFilterValues(root);setCourseHiddenState(courseId,!0),filters.grouping!=GROUPINGS_GROUPING_ALLINCLUDINGHIDDEN&&hideElement(root,courseId),hideAction.addClass("hidden"),showAction.removeClass("hidden")}(root,courseId),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS_ACTION_SHOW_COURSE,(function(e,data){var target=$(e.target).closest(SELECTORS_ACTION_SHOW_COURSE),courseId=getCourseId(target);!function(root,courseId){var hideAction=getHideCourseMenuItem(root,courseId),showAction=getShowCourseMenuItem(root,courseId),filters=getFilterValues(root);setCourseHiddenState(courseId,null),filters.grouping!=GROUPINGS_GROUPING_ALLINCLUDINGHIDDEN&&hideElement(root,courseId),hideAction.removeClass("hidden"),showAction.addClass("hidden")}(root,courseId),data.originalEvent.preventDefault()}))},init=function(root){root=$(root),loadedPages=[],lastPage=0,courseOffset=0,initializePagedContent(root),root.attr("data-init")||(registerEventListeners(root),root.attr("data-init",!0))};return{init:init,reset:function(root){loadedPages.length>0?loadedPages.forEach((function(courseList,index){var pagedContentPage=getPagedContentContainer(root,index);renderCourses(root,courseList).then((function(html,js){return Templates.replaceNodeContents(pagedContentPage,html,js)})).catch(Notification.exception)})):init(root)}}}));

//# sourceMappingURL=view.min.js.map