<?php
// FileSystem CharacterSet Converter(fs_converter.php) for moodle1.8/1.9
// Progammed by T.Shirai (Suzuka National College of Technology, Japan).
// http://www.suzuka-ct.ac.jp/mech/~shirai/index.html
// mailto:shirai@mech.suzuka-ct.ac.jp

// FS_DISABLE_ / FS_ENABLE_系の動作切り替えスイッチを判定する共用の関数
// 定義以外の条件によってenable/disableを判断する必要がある場合は専用の関数を用いること．
// 使用時には fs_function_enable('FS_DISABLE_FORCEPASSWORDCHANGE_FILTER')のように文字列で渡すこと！
function fs_function_enable($defname = '')
{
    if (($defname == '') || (is_string($defname) != true)) {
        echo '<br />';
        echo '<B>致命的なエラー： fs_function_enable()の引数が文字列ではありません！</B><br />';
        echo '直ぐに管理者に報告して下さい．<br />';
        die;
    }
    if (strncasecmp($defname, 'FS_ENABLE_', 10) == 0) {
        if (defined($defname) && constant($defname)) return true;
        return false;
    } else if (strncasecmp($defname, 'FS_DISABLE_', 11) == 0) {
        if (defined($defname) && constant($defname)) return false;
        return true;
    }
    return false;
}

// スイッチが宣言され，かつ有効かどうかをチェックする（FS_DISABLE_がfalseの場合もtrue）
function fs_function_defined_and_enable($defname = '')
{
    if (($defname == '') || (is_string($defname) != true)) {
        echo '<br />';
        echo '<B>致命的なエラー： fs_function_enable()の引数が文字列ではありません！</B><br />';
        echo '直ぐに管理者に報告して下さい．<br />';
        die;
    }
    if (strncasecmp($defname, 'FS_ENABLE_', 10) == 0) {
        if (defined($defname) && constant($defname)) return true;
        return false;
    } else if (strncasecmp($defname, 'FS_DISABLE_', 11) == 0) {
        if (defined($defname) && !constant($defname)) return true;
        return true;
    }
    return false;
}

// ワーニング（値の範囲が不適切）をセットし，初期値を設定する
function fscfg_notvalid($cfgname)
{
    global $fsCFG;
    $fsCFG->notvalid = $cfgname;
    set_fs_cfg_default($cfgname);
}

// エラー（値が未設定）をセットする
function set_novariable($cfgname, $SwitchName = false)
{
    global $fsCFG;
    if (!empty($SwitchName) and !fs_function_enable($SwitchName)) return;
    $fsCFG->novariable = $cfgname;
}

function check_fscfg_set_warning()
{
    global $fsCFG, $fs_cfg_strings, $CFG;
    foreach ($fs_cfg_strings as $cfgname => $fs_cfg_string) {
        // 設定値の妥当性
        if (isset($fsCFG->$cfgname)) {
            $val = $fsCFG->$cfgname;
            switch ($cfgname) {
              case 'rssCryptKeyA' :
              case 'rssCryptKeyB' :
                if (!is_string($val)) fscfg_notvalid($cfgname);
                break;
              case 'chatName' :
                if (($val <= 0) || ($val > 6)) fscfg_notvalid($cfgname);
                break;
              case 'email_detaillog_filenameformat' :
                if (empty($fsCFG->email_detaillog_filenameformat)) {
                    if (fs_function_enable('FS_ENABLE_EMAIL_DETAILLOG')) fscfg_notvalid($cfgname);
                }
              case 'email_detaillog_errorfilenameformat' :
                if (empty($val)) {
                    if (fs_function_enable('FS_ENABLE_EMAIL_DETAILLOG')) fscfg_notvalid($cfgname);
                }
                break;
              case 'email_wordwrapwidth' :
                if (($val > 998) || ($val < 0)) {
                    fscfg_notvalid($cfgname);
                 } else if (($val != false) && ($val < MIN_WORDWRAPWIDTH)) {
                    $fsCFG->notvalid = $cfgname;
                    $fsCFG->$cfgname = MIN_WORDWRAPWIDTH;
                }
                break;
              case 'gsDisplayTokenLevel' :
                if (fs_function_enable('FS_ENABLE_GS_DISPLAY_TOKENIZED_WORDS')) {
                    switch ($val) {
                      case 1: case 2: case 4: case 8:
                        break;
                      default:
                         fscfg_notvalid($cfgname);
                    }
                }
                break;
              case 'gsDisplayTokenLength' :
              case 'gsDisplayTokenNumber' :
                if (fs_function_enable('FS_ENABLE_GS_DISPLAY_TOKENIZED_WORDS')) {
                    if ($val == 0)  fscfg_notvalid($cfgname);
                }
                break;
              case 'blogexport_capability' :
                if (fs_function_enable('FS_ENABLE_BLOGEXPORT')) {
                    if (($val < 0) || ($val > 3)) fscfg_notvalid($cfgname);
                }
                break;
              case 'publicwwwroot' :
                if (fs_function_enable('FS_ENABLE_USEPUBLICWWWROOT')) {
                    if (!is_string($val)) fscfg_notvalid($cfgname);
                }
                break;
              case 'm2b_host' :
              case 'm2b_user' :
              case 'm2b_pass' :
              case 'm2b_log_filenameformat' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    if (!is_string($val) || (strlen($val) < 1)) fscfg_notvalid($cfgname);
                }
                break;
              case 'm2b_codeseparator' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    if (!is_string($val) || (strlen($val) < 3)) fscfg_notvalid($cfgname);
                }
                break;
              case 'm2b_port' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    if (!is_integer($val) || ($val < 0) || ($val > 65535)) {
                        fscfg_notvalid($cfgname);
                    }
                }
                break;
              case 'm2b_confirmlevel' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    if (($val < 1) || ($val > 5)) fscfg_notvalid($cfgname);
                }
                break;
              case 'm2b_replytiming' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    if (($val < 0) || ($val > 3)) fscfg_notvalid($cfgname);
                }
                break;
              case 'm2b_pubstate' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    if (!is_string($val) || (($val != 'draft') and ($val != 'site') and ($val != 'public'))) {
                        fscfg_notvalid($cfgname);
                    }
                }
                break;
              case 'm2b_textformat' :
                if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
                    switch ($val) {
                        case '0':
                        case '1':
                        case '2':
                        case '4':
                        case '9':
                            break;
                        default :
                            fscfg_notvalid($cfgname);
                            break;
                    }
                }
                break;
//            case 'm2b_maxfilesize' :
//              if (fs_function_enable('FS_ENABLE_MAIL2BLOGFUNCTION')) {
//                  if (!is_integer($val)) {
//                      $fsCFG->notvalid = $cfgname;
//                      $fsCFG->$cfgname = get_fs_cfg_default($cfgname);
//                  }
//              }
//              break;
              case 'blogimagemax_x' :
              case 'blogimagemax_y' :
              case 'forumimagemax_x' :
              case 'forumimagemax_y' :
                if (fs_function_enable('FS_ENABLE_RESTRICT_IMAGESIZE')) {
                    if (($val < 100) and ($val > 0)) fscfg_notvalid($cfgname);
                }
                break;
              case 'userpict_level' :
                if (fs_function_enable('FS_ENABLE_PRINTUSERPICTURELEVEL')) {
                    switch ($val) {
                        case 1: case 2: case 3: case 4: case 5:
                        case 12: case 13: case 14: case 15: case 99:
                        break;
                        default :
                            fscfg_notvalid($cfgname);
                    }
                }
                break;
              case 'ra_link_customattribute' :
                if (strlen(trim($val)) < 1) fscfg_notvalid($cfgname);
                break;
              case 'ra_wiki_numberofdays' :
                if (fs_function_enable('FS_DISABLE_RA_WIKI')) {
                    if ($val <= 0) fscfg_notvalid($cfgname);
                }
                break;
              case 'ra_wiki_maxnum' :
                if (fs_function_enable('FS_DISABLE_RA_WIKI')) {
                    if ($val < 1) fscfg_notvalid($cfgname);
                }
                break;
              case 'ra_glossary_numberofdays' :
                if (fs_function_enable('FS_DISABLE_RA_GLOSSARY')) {
                    if ($val <= 0) fscfg_notvalid($cfgname);
                }
                break;
              case 'ra_glossary_maxnum' :
                if (fs_function_enable('FS_DISABLE_RA_GLOSSARY')) {
                    if ($val < 1) fscfg_notvalid($cfgname);
                }
                break;
              case 'gradingnotificationcommentlength' :
                if (fs_function_enable('FS_ENABLE_ADDCOMMENT2GRADINGNOTIFICATIONEMAIL')) {
                    if (($val < 10) and ($val != 0)) fscfg_notvalid($cfgname);
                }break;
            }
        } else {
        // 未設定
            set_fs_cfg_default($cfgname);
            switch ($cfgname) {
              case 'gsexec' :
                set_novariable($cfgname, 'FS_ENABLE_PDF2JPEG');
                break;
              case 'email_report_lowlevel_log' :
                set_novariable($cfgname, 'FS_ENABLE_EMAIL_DETAILLOG');
                break;
              case 'email_detaillog_filenameformat' :
                set_novariable($cfgname, 'FS_ENABLE_EMAIL_DETAILLOG');
                break;
              case 'email_detaillog_errorfilenameformat' :
                set_novariable($cfgname, 'FS_ENABLE_EMAIL_DETAILLOG');
                break;
              case 'email_detaillog_includingaddress' :
                set_novariable($cfgname, 'FS_ENABLE_EMAIL_DETAILLOG');
                break;
              case 'gsDisplayTokenLevel' :
              case 'gsDisplayTokenLength' :
              case 'gsDisplayTokenNumber' :
                set_novariable($cfgname, 'FS_ENABLE_GS_DISPLAY_TOKENIZED_WORDS');
                break;
              case 'blogexport_capability' :
                set_novariable($cfgname, 'FS_ENABLE_BLOGEXPORT');
                break;
              case 'publicwwwroot' :
                set_novariable($cfgname, 'FS_ENABLE_USEPUBLICWWWROOT');
                break;
              case 'm2b_host' :
              case 'm2b_user' :
              case 'm2b_pass' :
              case 'm2b_confirmlevel' :
              case 'm2b_pubstate' :
              case 'm2b_textformat' :
              case 'm2b_codeseparator' :
              case 'm2b_maxfilesize' :
                set_novariable($cfgname, 'FS_ENABLE_MAIL2BLOGFUNCTION');
                break;
              case 'm2b_replytiming' :
                set_novariable($cfgname, 'FS_ENABLE_MAIL2BLOGFUNCTION');
                break;
              case 'm2b_log_filenameformat' :
                set_novariable($cfgname, 'FS_ENABLE_MAIL2BLOGFUNCTION');
                break;
              case 'blogimagemax_x' :
              case 'blogimagemax_y' :
              case 'forumimagemax_x' :
              case 'forumimagemax_y' :
                set_novariable($cfgname, 'FS_ENABLE_RESTRICT_IMAGESIZE');
                break;
              case 'userpict_level' :
                set_novariable($cfgname, 'FS_ENABLE_PRINTUSERPICTURELEVEL');
                break;
              case 'ra_link_customattribute' :
                set_novariable($cfgname, 'FS_ENABLE_RA_LINK_CUSTOMATTRIBUTE');
                break;
              case 'ra_wiki_numberofdays' :
              case 'ra_wiki_maxnum'  :
                set_novariable($cfgname, 'FS_DISABLE_RA_WIKI');
                break;
              case 'ra_glossary_numberofdays' :
              case 'ra_glossary_maxnum'  :
                set_novariable($cfgname, 'FS_DISABLE_RA_GLOSSARY');
                break;
              case 'gradingnotificationcommentlength' :
                set_novariable($cfgname, 'FS_ENABLE_ADDCOMMENT2GRADINGNOTIFICATIONEMAIL');
                break;
              default:
                set_novariable($cfgname);
                break;
            }
        }
    }
}

?>
