<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_messageUserSettings()
{
    global $CFG, $USER, $fsCFG;

    print_section_header('メッセージ（Ｅメール）に関する設定：ユーザ寄りの内容');
    print_subsection_header_fs_switch('FS_ENABLE_SECONDADDRESS');
    echo '　ＰＣ用と携帯電話用など，二つの電子メールアドレスにメールを送信することができるようになります．';
    echo '標準のMoodleは一つのユーザアカウントに対して一つの電子メールアドレスを登録できます．';
    echo 'メッセージ機能やフォーラム投稿の通知メールなどはこの電子メールアドレスに対して送信されます．';
    echo '本機能を有効にすると，この電子メールアドレスとは別の電子メールアドレスを各ユーザに対して一つだけ追加できるようになり，';
    echo 'Moodleから送信される電子メールは両方の電子メールアドレス宛に同一の内容が送信されます．';
    newline();
    echo '　追加する電子メールアドレス（以下，セカンドメールアドレス）は'.color_blue('ユーザプロファイルフィールド').'にユーザ毎に登録可能です．';
    echo '追加登録したセカンドメールアドレスを有効にするか無効にするか，も，ユーザ単位でチェックボックスで変更可能です．';
    print_fs_switch_condition('FS_ENABLE_SECONDADDRESS');
    print_subsubsection_header('ユーザプロファイルのチェック');
    echo '　チェックボックス(enablesecondaddress)は';
    if (get_userProfileField_value($USER->id, 'enablesecondaddress')) {
        echo '追加されており，あなたは'.color_blue('[有効]').'に設定しています．';
    } else {
        echo '追加されていないか，あなたは'.color_blue('[無効]').'に設定しています．';
    }
    newline();
    echo '同時送信メールアドレス(secondaddress)は';
    $secondaddress = get_userProfileField_value($USER->id, 'secondaddress');
    $secondaddress = trim(stripslashes($secondaddress));
    if (strlen($secondaddress)) {
        echo '追加されており，あなたは['.color_blue($secondaddress).']を入力しています．';
    } else {
        echo '追加されていないか，あなたは値を入力していません．';
    }
    newline();
    newline();
    print_notice_message('注意', 'Ｅメールアドレスの正当性のチェックは全く行っていません．もし不適切なＥメールアドレスを同時送信メールアドレスに設定した場合，Moodleに設定した第１のメールアドレスにもメールが送信されなくなるリスクがあることを理解し，ユーザに対しても啓蒙を行って下さい．');
    print_notice_message('注意', color_blue('enablesecondaddress').'と'.color_blue('secondaddress').'のユーザプロフィールド項目の追加は管理者がサイト管理ブロックの「ユーザ」－「アカウント」－「ユーザプロファイルフィールド」で手作業で行う必要があります．詳しくは'.link2fs_switch('FS_ENABLE_SECONDADDRESS').'および'.link2fs_wiki('Shirai099', 'Shirai099').'をご覧下さい．');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header('電子メール送信時の自動ワードラップ処理に関する設定');
    echo '　オリジナルのMoodleのワードラップ処理は英文のような半角空白文字による分かち書きを前提としています．';
    echo 'その結果，日本語と英文が混ざったような文章をメール送信する場合，予想とは異なる位置で改行が入り，';
    echo 'かなり見栄えが悪くなります．';
    echo '理解しなくてはならないのは，ワードラップ処理とは「指定した文字数に達したら改行を挿入する処理」ではないことです．';
    echo '指定された文字数に達した位置に”単語”が存在した場合，その単語を次の行頭に送るために';
    echo '単語の前に改行を挿入する処理です．';
    echo '（オリジナルのMoodleでは文字数は79文字(79byte)に固定されています）．';
    echo 'ここでいう単語とは”半角空白文字で区切られた文字列”です．';
    echo 'したがって分かち書きを行わない日本語文章の場合は望みどおりにワードラップは行われません．';
    echo 'それどころか，日本語文章に半角空白記号を含む（たとえば2008年 1月 1日，など）と';
    echo 'その箇所で改行されてしまう恐れがあります．';
    newline();
    echo '　以下２つはこの問題に対する改良のための設定です．';
    newline();
    newline();

    print_subsubsection_header_fs_switch('FS_DISABLE_MULTIBYTE_WORDWRAP');
    echo '　オリジナルのワードラップ処理は文字数をstrlen()関数でカウントしています．';
    echo 'ISO-2022-JPで符号化されたメール本文は見た目の文字数よりも多くカウントされるため，';
    echo '早い段階で改行されてしまいます．';
    print_fs_switch_condition('FS_DISABLE_MULTIBYTE_WORDWRAP');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('email_wordwrapwidth');
    echo '　電子メール送信時のワードラップ処理の幅を'.color_blue('$fsCFG->email_wordwrapwidth').'で指定できます．';
    echo '指定した文字数に達した位置が単語の場合，その単語を次の行の行頭へ送るために改行文字を挿入します．';
    echo '（これはPHPmailerの標準的な機能です．）';
    newline();
    echo '　しかし，特別な事情が無い限り現在のネットワーク環境ではオリジナルの文章を勝手に改行する';
    echo 'ワードラップ処理を行う必要は無いでしょう．';
    echo 'ワードラップ処理を無効にするには'.color_blue('$fsCFG->email_wordwrapwidth = false;').'（あるいは0）を設定して下さい．';
    echo 'この機能はオリジナルの79文字（byte）という折り返し位置が狭すぎるのを緩和する目的で追加しましたが，';
    echo '日本語を主として使うユーザが大半のサイトではワードラップ処理自体が悪影響を与える場合が多いので，';
    echo '”ワードラップを無効にできる”のが最大のご利益です．';
    echo 'なお，本設定値はユーザ毎に変更することはできません．';
    newline();
    echo '　fs_moodleでは最小値として定数MIN_WORDWRAPWIDTHに'.color_blue(MIN_WORDWRAPWIDTH).'をfs_index.phpで設定しています．';
    echo 'この値よりも小さな値を設定した場合，自動的に設定値はMIN_WORDWRAPWIDTHに変更されます．';
    echo 'また，998よりも大きな値を設定した場合はワードラップ処理を行わないようにfalseに自動的に変更されます．';
    newline();
    newline();
    echo '　現在，'.color_blue('$fsCFG->email_wordwrapwidth').'には';
    if ($fsCFG->email_wordwrapwidth) {
        echo color_blue($fsCFG->email_wordwrapwidth).'が設定されています．';
        if ($fsCFG->email_wordwrapwidth >= 998) {
            echo '998以上の値ですのでワードラップ処理を行いません．';
        } else if ($fsCFG->email_wordwrapwidth >= MIN_WORDWRAPWIDTH) {
            echo 'MIN_WORDWRAPWIDTH以上の値ですので指定された文字数でワードラップ処理を行います．';
        } else {
            echo 'MIN_WORDWRAPWIDTHよりも小さな値ですのでワードラップ処理は行いません．';
        }
    } else {
        echo color_blue('false').'(あるいは0）が設定されていますので，ワードラップ処理は行いません．';
    }
    print_fs_cfg_condition('email_wordwrapwidth');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_DISABLE_MESSAGESUBJECT');
    echo '　オリジナルのMoodleのメッセージ機能で電子メールを送信する際，Subjectは入力されたテキストから自動的に生成される．';
    echo '最低30byte以上であり，その後に存在する半角ピリオドか半角空白までである．';
    echo '改行文字は半角空白文字に置換される．';
    echo 'もし１行目が30byte未満であり，２行目に非常に長い文章が記述されていた場合，Subjectは２行目も含む非常に長い文章になってしまう（上限998byte）．';
    newline();
    echo '　いっそのこと，１行目は電子メールのSubjectになる，というルールの方が利用者にとっては理解しやすい．';
    echo '本機能を有効にするとメッセージの１行目のみがSubjectとなる．';
    echo '万が一，１行目が空行（半角空白含む）の場合は(No Subject)をSubjectとする．';
    print_fs_switch_condition('FS_DISABLE_MESSAGESUBJECT');
    print_subsection_footer();

    print_section_footer();
}

function fsconfig_check_messageServerSettings()
{
    global $CFG, $USER, $fsCFG;

    print_section_header('メッセージ（Ｅメール）に関する設定：サーバ寄りの内容');

    print_subsection_header_fs_switch('FS_ENABLE_EMAIL_DETAILLOG');
    echo '　Moodleサイトからユーザに送信するメールの送信記録をログに残す機能です．';
    echo 'このログはmoodledata/logフォルダ（オリジナルでは存在しません）に記録されます．';
    echo 'このログは'.color_red('非常に重要な個人情報').'ですので取り扱いに注意が必要です．';
    echo 'メール送信に関する障害の原因究明時以外は無効にすることを勧めます．';
    print_fs_switch_condition('FS_ENABLE_EMAIL_DETAILLOG');

    print_subsubsection_header_fs_cfg('email_report_lowlevel_log');
    echo '　'.color_blue('簡易ログ').'と'.color_blue('詳細ログ').'の２つの選択肢があります．';
    echo '詳細ログではメール送信サーバからのレスポンスまで記録されますのでログファイルは大きくなります．';
    echo '単に電子メール送信の履歴のみを残したいのであれば簡易ログで良いでしょう．';
    newline();
    newline();
    echo '　現在，'.color_blue('$fsCFG->email_report_lowlevel_log').'が';
    if ($fsCFG->email_report_lowlevel_log) {
        echo '真（=true）ですので，'.color_blue('詳細ログモード').'です．';
    } else {
        echo '偽（=false）ですので，'.color_blue('簡易ログモード').'です．';
    }
    print_fs_cfg_condition('email_report_lowlevel_log');
    print_subsubsection_footer();

    echo '　メール送信時の送信ログファイルはmoodledata/logフォルダに追記モードでテキストファイルに保存します．';
    echo '送信ログファイルは二種類あります．';
    echo '通常のログは'.color_blue('送信ログファイル').'，エラー発生時のログは'.color_blue('送信エラーログファイル').'に追記されます．';
    echo '送信ログファイルのファイル名は'.color_blue('$fsCFG->email_detaillog_filenameformat').'，';
    echo '送信エラーログのファイル名は'.color_blue('$fsCFG->email_detaillog_errorfilenameformat').'を変更することで自由に設定できます．';
    newline();
    echo '　例えば，'.color_blue('$fsCFG->email_detaillog_filenameformat'." = \"'email'.date('Ymd').'.log'\";").'ならば，';
    echo color_blue('email20081212.log').'のような一日単位のファイルに保存されます．';
    echo color_blue('$fsCFG->email_detaillog_filenameformat').'はeval()によってPHPのコードとして実行されます．';
    echo '具体的には，頭に"return "，お尻に";"が追加されます．このことを理解して自由なコードを記述して結構です．';
    echo 'なお，月単位，年単位，固定ファイル名の例はを以下に示します．';
    echo '<dl>';
    echo '<dt>月単位</dt><dd> $fsCFG->email_detaillog_filenameformat = "'."'email'.date('Ym').'.log'".'";</dd>';
    echo '<dt>年単位</dt><dd> $fsCFG->email_detaillog_filenameformat = "'."'email'.date('Y').'.log'".'";</dd>';
    echo '<dt>固定ファイル名</dt><dd> $fsCFG->email_detaillog_filenameformat = "'."email.log".'";</dd>';
    echo '</dl>';
    echo '　現在の各ファイルのファイル名は以下の通りです，';
    print_subsubsection_header_fs_cfg('email_detaillog_filenameformat');
    echo '　現在の設定値は，'.color_blue('$fsCFG->email_detaillog_filenameformat = "'.$fsCFG->email_detaillog_filenameformat.'"').'なので，';
    echo '送信ログファイル名は'.color_blue(get_detaillog_filename('email_detaillog_filenameformat')).'です．';
    newline();
    print_fs_cfg_condition('email_detaillog_filenameformat');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('email_detaillog_errorfilenameformat');
    echo '　現在の設定値は，'.color_blue('$fsCFG->email_detaillog_errorfilenameformat = "'.$fsCFG->email_detaillog_errorfilenameformat.'"').'なので，';
    echo '送信エラーログファイル名は'.color_blue(get_detaillog_filename('email_detaillog_errorfilenameformat')).'です．';
    newline();
    print_fs_cfg_condition('email_detaillog_errorfilenameformat');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('email_detaillog_includingaddress');
    echo '　ログファイルに個人情報である電子メールを含める場合は，';
    echo color_blue('$fsCFG->email_detaillog_includingaddress').'を'.color_blue('true').'に設定して下さい．';
    echo 'もしfalseを設定した場合は電子メールアドレスの頭一文字だけを残し，後の英数字文字はアスタリスク記号に置き換えて記録します．';
    echo '完全に電子メールアドレスを記録したくない場合は，'.color_blue('-1').'（負の数字）を設定して下さい．';
    newline();
    echo '　現在，'.color_blue('$fsCFG->email_detaillog_includingaddress').'は';
    if (!$fsCFG->email_detaillog_includingaddress) {
        echo color_blue('false').'ですので，ログファイルに電子メールアドレスの頭一文字以外はアスタリスクに置き換えて記録します．';
    } else if ($fsCFG->email_detaillog_includingaddress < 0) {
        echo color_blue($fsCFG->email_detaillog_includingaddress.'< 0').'ですので，';
        echo 'ログファイルに電子メールアドレスは一切記録されません．';
    } else {
        echo '負でもfalseでもありません（'.color_blue($fsCFG->email_detaillog_includingaddress).'）ので，';
        echo 'ログファイルに電子メールアドレスは正確に記録されます．';
    }
    print_fs_cfg_condition('email_detaillog_includingaddress');
    print_subsubsection_footer();

    print_subsubsection_header_fs_switch('FS_ENABLE_MESSAGE2ADMIN_EMAILFAILED');
    echo '　メール送信に失敗した際にMoodleのmessage機能を使って管理者に警告を出力する機能です．';
    echo 'この場合のメール送信の失敗も，メールアドレスのミスなどによるメール不達のことではありません．';
    echo 'ログへの記録だけですと定期的に管理者はログをチェックしなくてはなりませんが，本機能を有効にすることで．';
    echo '管理者の負担がかなり軽減されます．';
    echo 'ただし，確実にメッセージが送信されるという保障はありませんので，定期的なログのチェックは必要です．';
    echo '（そもそもメッセージ機能によるメール送信に失敗しているのですから）';
    print_fs_switch_condition('FS_ENABLE_MESSAGE2ADMIN_EMAILFAILED');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_SMTP_CONNECT_CHECKandRETRY');
    echo '　オリジナルのPHPmailerライブラリはSMTPサーバとの通信に脆弱な可能性があります（PHPの実装に依存するのかも知れません）．';
    echo 'もしメール送信が正常に行われていない可能性が疑われる場合には，まず'.color_blue(title_fs_switch('FS_ENABLE_EMAIL_DETAILLOG')).link2fs_switch('FS_ENABLE_EMAIL_DETAILLOG').'を用いて長期的にログを記録して調べて下さい．';
    echo 'ここでいうメール送信の失敗とは送信アドレスのミス等によるメールの不達のことではなく，';
    echo 'MoodleサーバとSMTPサーバとの間の通信に不具合が生じた結果，処理は一見正常に終了するが，';
    echo '実際にはメールが送出されていない場合のことです．';
    newline();
    echo '　本機能でチェックを厳密化するのは以下の現象です．';
    echo 'メール送信時には，まずMoodleサーバとSMTPサーバの間のソケットをfsockopen()で開きます．';
    echo 'オープンに失敗した場合はリソースが得られないはずですが，ごく稀に，SMTPサーバから応答が得られないにも関わらず，';
    echo 'オープンに成功したと振舞う場合があります．';
    echo '正しくソケットが接続された場合はSMTPサーバから応答220が戻ってくるはずですが，失敗した場合には何も返ってきません．';
    echo '本機能を有効にすると，この応答のチェックを厳密に行います．';
    echo 'もし正常な応答が得られなかった場合はソケットを閉じ，もう一度だけConnectを試みます．';
    print_fs_switch_condition('FS_ENABLE_SMTP_CONNECT_CHECKandRETRY');
    print_notice_message('注意', 'この現象は当方（鈴鹿高専）のネットワーク環境下でのみ確認された現象です．発生頻度もきわめて低い現象です．電子メール送信時の詳細なログを残す機能でメール送信失敗の現象が確認され，Connect()に対する応答が220ではないことが確認された場合にのみ有効にして下さい．');
    print_subsection_footer();

    print_section_footer();
}

fsconfig_check_messageUserSettings();
fsconfig_check_messageServerSettings();

?>