/*
YUI 3.13.0 (build 508226d)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/axis-category-base/axis-category-base.js']) {
   __coverage__['build/axis-category-base/axis-category-base.js'] = {"path":"build/axis-category-base/axis-category-base.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":30},"end":{"line":1,"column":49}}},"2":{"name":"CategoryImpl","line":22,"loc":{"start":{"line":22,"column":0},"end":{"line":23,"column":0}}},"3":{"name":"(anonymous_3)","line":60,"loc":{"start":{"line":60,"column":17},"end":{"line":61,"column":4}}},"4":{"name":"(anonymous_4)","line":97,"loc":{"start":{"line":97,"column":22},"end":{"line":98,"column":4}}},"5":{"name":"(anonymous_5)","line":112,"loc":{"start":{"line":112,"column":18},"end":{"line":113,"column":4}}},"6":{"name":"(anonymous_6)","line":140,"loc":{"start":{"line":140,"column":18},"end":{"line":141,"column":4}}},"7":{"name":"(anonymous_7)","line":162,"loc":{"start":{"line":162,"column":24},"end":{"line":163,"column":4}}},"8":{"name":"(anonymous_8)","line":181,"loc":{"start":{"line":181,"column":24},"end":{"line":182,"column":4}}},"9":{"name":"(anonymous_9)","line":208,"loc":{"start":{"line":208,"column":19},"end":{"line":209,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":235,"column":42}},"2":{"start":{"line":9,"column":0},"end":{"line":9,"column":20}},"3":{"start":{"line":22,"column":0},"end":{"line":24,"column":1}},"4":{"start":{"line":26,"column":0},"end":{"line":26,"column":35}},"5":{"start":{"line":28,"column":0},"end":{"line":50,"column":2}},"6":{"start":{"line":52,"column":0},"end":{"line":218,"column":2}},"7":{"start":{"line":62,"column":8},"end":{"line":62,"column":19}},"8":{"start":{"line":99,"column":8},"end":{"line":99,"column":69}},"9":{"start":{"line":100,"column":8},"end":{"line":100,"column":30}},"10":{"start":{"line":114,"column":8},"end":{"line":118,"column":30}},"11":{"start":{"line":119,"column":8},"end":{"line":122,"column":9}},"12":{"start":{"line":121,"column":12},"end":{"line":121,"column":31}},"13":{"start":{"line":123,"column":8},"end":{"line":128,"column":9}},"14":{"start":{"line":125,"column":12},"end":{"line":125,"column":26}},"15":{"start":{"line":126,"column":12},"end":{"line":126,"column":26}},"16":{"start":{"line":127,"column":12},"end":{"line":127,"column":33}},"17":{"start":{"line":129,"column":8},"end":{"line":129,"column":36}},"18":{"start":{"line":130,"column":8},"end":{"line":130,"column":22}},"19":{"start":{"line":142,"column":8},"end":{"line":145,"column":9}},"20":{"start":{"line":144,"column":12},"end":{"line":144,"column":29}},"21":{"start":{"line":146,"column":8},"end":{"line":146,"column":33}},"22":{"start":{"line":147,"column":8},"end":{"line":150,"column":9}},"23":{"start":{"line":149,"column":12},"end":{"line":149,"column":31}},"24":{"start":{"line":151,"column":8},"end":{"line":151,"column":20}},"25":{"start":{"line":164,"column":8},"end":{"line":164,"column":39}},"26":{"start":{"line":183,"column":8},"end":{"line":185,"column":23}},"27":{"start":{"line":186,"column":8},"end":{"line":196,"column":9}},"28":{"start":{"line":188,"column":12},"end":{"line":188,"column":30}},"29":{"start":{"line":189,"column":12},"end":{"line":189,"column":38}},"30":{"start":{"line":190,"column":12},"end":{"line":190,"column":56}},"31":{"start":{"line":191,"column":12},"end":{"line":191,"column":45}},"32":{"start":{"line":195,"column":12},"end":{"line":195,"column":29}},"33":{"start":{"line":197,"column":8},"end":{"line":197,"column":26}},"34":{"start":{"line":210,"column":8},"end":{"line":211,"column":36}},"35":{"start":{"line":212,"column":8},"end":{"line":215,"column":9}},"36":{"start":{"line":214,"column":12},"end":{"line":214,"column":37}},"37":{"start":{"line":216,"column":8},"end":{"line":216,"column":21}},"38":{"start":{"line":220,"column":0},"end":{"line":220,"column":30}},"39":{"start":{"line":232,"column":0},"end":{"line":232,"column":85}}},"branchMap":{"1":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":8},"end":{"line":119,"column":8}},{"start":{"line":119,"column":8},"end":{"line":119,"column":8}}]},"2":{"line":142,"type":"if","locations":[{"start":{"line":142,"column":8},"end":{"line":142,"column":8}},{"start":{"line":142,"column":8},"end":{"line":142,"column":8}}]},"3":{"line":147,"type":"if","locations":[{"start":{"line":147,"column":8},"end":{"line":147,"column":8}},{"start":{"line":147,"column":8},"end":{"line":147,"column":8}}]},"4":{"line":147,"type":"binary-expr","locations":[{"start":{"line":147,"column":11},"end":{"line":147,"column":15}},{"start":{"line":147,"column":19},"end":{"line":147,"column":30}}]},"5":{"line":186,"type":"if","locations":[{"start":{"line":186,"column":8},"end":{"line":186,"column":8}},{"start":{"line":186,"column":8},"end":{"line":186,"column":8}}]},"6":{"line":212,"type":"if","locations":[{"start":{"line":212,"column":8},"end":{"line":212,"column":8}},{"start":{"line":212,"column":8},"end":{"line":212,"column":8}}]},"7":{"line":212,"type":"binary-expr","locations":[{"start":{"line":212,"column":11},"end":{"line":212,"column":20}},{"start":{"line":212,"column":24},"end":{"line":212,"column":40}}]}},"code":["(function () { YUI.add('axis-category-base', function (Y, NAME) {","","/**"," * Provides functionality for the handling of category axis data for a chart."," *"," * @module charts"," * @submodule axis-category-base"," */","var Y_Lang = Y.Lang;","","/**"," * CategoryImpl contains logic for managing category data. CategoryImpl is used by the following classes:"," * <ul>"," *      <li>{{#crossLink \"CategoryAxisBase\"}}{{/crossLink}}</li>"," *      <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>"," *  </ul>"," *"," * @class CategoryImpl"," * @constructor"," * @submodule axis-category-base"," */","function CategoryImpl()","{","}","","CategoryImpl.NAME = \"categoryImpl\";","","CategoryImpl.ATTRS = {","    /**","     * Determines whether and offset is automatically calculated for the edges of the axis.","     *","     * @attribute calculateEdgeOffset","     * @type Boolean","     */","    calculateEdgeOffset: {","        value: true","    }","","    /**","     * Method used for formatting a label. This attribute allows for the default label formatting method to overridden.","     * The method use would need to implement the arguments below and return a `String` or `HTMLElement`.","     * <dl>","     *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>","     *      <dt>format</dt><dd>Template for formatting label. (optional)</dd>","     * </dl>","     *","     * @attribute labelFunction","     * @type Function","     */","};","","CategoryImpl.prototype = {","    /**","     * Formats a label based on the axis type and optionally specified format.","     *","     * @method formatLabel","     * @param {Object} value","     * @return String","     */","    formatLabel: function(val)","    {","        return val;","    },","","    /**","     * Object storing key data.","     *","     * @property _indices","     * @private","     */","    _indices: null,","","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"yuicategoryaxis\",","","    /**","     * Type of data used in `Data`.","     *","     * @property _dataType","     * @readOnly","     * @private","     */","    _type: \"category\",","","    /**","     * Calculates the maximum and minimum values for the `Data`.","     *","     * @method _updateMinAndMax","     * @private","     */","    _updateMinAndMax: function()","    {","        this._dataMaximum = Math.max(this.get(\"data\").length - 1, 0);","        this._dataMinimum = 0;","    },","","    /**","     * Gets an array of values based on a key.","     *","     * @method _getKeyArray","     * @param {String} key Value key associated with the data array.","     * @param {Array} data Array in which the data resides.","     * @return Array","     * @private","     */","    _getKeyArray: function(key, data)","    {","        var i = 0,","            obj,","            keyArr = [],","            labels = [],","            len = data.length;","        if(!this._indices)","        {","            this._indices = {};","        }","        for(; i < len; ++i)","        {","            obj = data[i];","            keyArr[i] = i;","            labels[i] = obj[key];","        }","        this._indices[key] = keyArr;","        return labels;","    },","","    /**","     * Returns an array of values based on an identifier key.","     *","     * @method getDataByKey","     * @param {String} value value used to identify the array","     * @return Array","     */","    getDataByKey: function (value)","    {","        if(!this._indices)","        {","            this.get(\"keys\");","        }","        var keys = this._indices;","        if(keys && keys[value])","        {","            return keys[value];","        }","        return null;","    },","","    /**","     * Returns the total number of majorUnits that will appear on an axis.","     *","     * @method getTotalMajorUnits","     * @param {Object} majorUnit Object containing properties related to the majorUnit.","     * @param {Number} len Length of the axis.","     * @return Number","     */","    getTotalMajorUnits: function()","    {","        return this.get(\"data\").length;","    },","","    /**","     * Returns a coordinate corresponding to a data values.","     *","     * @method _getCoordFromValue","     * @param {Number} min The minimum for the axis.","     * @param {Number} max The maximum for the axis.","     * @param {length} length The distance that the axis spans.","     * @param {Number} dataValue A value used to ascertain the coordinate.","     * @param {Number} offset Value in which to offset the coordinates.","     * @param {Boolean} reverse Indicates whether the coordinates should start from","     * the end of an axis. Only used in the numeric implementation.","     * @return Number","     * @private","     */","    _getCoordFromValue: function(min, max, length, dataValue, offset)","    {","        var range,","            multiplier,","            valuecoord;","        if(Y_Lang.isNumber(dataValue))","        {","            range = max - min;","            multiplier = length/range;","            valuecoord = (dataValue - min) * multiplier;","            valuecoord = offset + valuecoord;","        }","        else","        {","            valuecoord = NaN;","        }","        return valuecoord;","    },","","    /**","     * Returns a value based of a key value and an index.","     *","     * @method getKeyValueAt","     * @param {String} key value used to look up the correct array","     * @param {Number} index within the array","     * @return String","     */","    getKeyValueAt: function(key, index)","    {","        var value = NaN,","            keys = this.get(\"keys\");","        if(keys[key] && keys[key][index])","        {","            value = keys[key][index];","        }","        return value;","    }","};","","Y.CategoryImpl = CategoryImpl;","","/**"," * CategoryAxisBase manages category data for an axis."," *"," * @class CategoryAxisBase"," * @constructor"," * @extends AxisBase"," * @uses CategoryImpl"," * @param {Object} config (optional) Configuration parameters."," * @submodule axis-category-base"," */","Y.CategoryAxisBase = Y.Base.create(\"categoryAxisBase\", Y.AxisBase, [Y.CategoryImpl]);","","","}, '3.13.0', {\"requires\": [\"axis-base\"]});","","}());"]};
}
var __cov_TfK6OFh2BYyMHxhA$Njz7g = __coverage__['build/axis-category-base/axis-category-base.js'];
__cov_TfK6OFh2BYyMHxhA$Njz7g.s['1']++;YUI.add('axis-category-base',function(Y,NAME){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['1']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['2']++;var Y_Lang=Y.Lang;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['3']++;function CategoryImpl(){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['2']++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['4']++;CategoryImpl.NAME='categoryImpl';__cov_TfK6OFh2BYyMHxhA$Njz7g.s['5']++;CategoryImpl.ATTRS={calculateEdgeOffset:{value:true}};__cov_TfK6OFh2BYyMHxhA$Njz7g.s['6']++;CategoryImpl.prototype={formatLabel:function(val){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['3']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['7']++;return val;},_indices:null,GUID:'yuicategoryaxis',_type:'category',_updateMinAndMax:function(){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['4']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['8']++;this._dataMaximum=Math.max(this.get('data').length-1,0);__cov_TfK6OFh2BYyMHxhA$Njz7g.s['9']++;this._dataMinimum=0;},_getKeyArray:function(key,data){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['5']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['10']++;var i=0,obj,keyArr=[],labels=[],len=data.length;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['11']++;if(!this._indices){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['1'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['12']++;this._indices={};}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['1'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['13']++;for(;i<len;++i){__cov_TfK6OFh2BYyMHxhA$Njz7g.s['14']++;obj=data[i];__cov_TfK6OFh2BYyMHxhA$Njz7g.s['15']++;keyArr[i]=i;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['16']++;labels[i]=obj[key];}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['17']++;this._indices[key]=keyArr;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['18']++;return labels;},getDataByKey:function(value){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['6']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['19']++;if(!this._indices){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['2'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['20']++;this.get('keys');}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['2'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['21']++;var keys=this._indices;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['22']++;if((__cov_TfK6OFh2BYyMHxhA$Njz7g.b['4'][0]++,keys)&&(__cov_TfK6OFh2BYyMHxhA$Njz7g.b['4'][1]++,keys[value])){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['3'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['23']++;return keys[value];}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['3'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['24']++;return null;},getTotalMajorUnits:function(){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['7']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['25']++;return this.get('data').length;},_getCoordFromValue:function(min,max,length,dataValue,offset){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['8']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['26']++;var range,multiplier,valuecoord;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['27']++;if(Y_Lang.isNumber(dataValue)){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['5'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['28']++;range=max-min;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['29']++;multiplier=length/range;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['30']++;valuecoord=(dataValue-min)*multiplier;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['31']++;valuecoord=offset+valuecoord;}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['5'][1]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['32']++;valuecoord=NaN;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['33']++;return valuecoord;},getKeyValueAt:function(key,index){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['9']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['34']++;var value=NaN,keys=this.get('keys');__cov_TfK6OFh2BYyMHxhA$Njz7g.s['35']++;if((__cov_TfK6OFh2BYyMHxhA$Njz7g.b['7'][0]++,keys[key])&&(__cov_TfK6OFh2BYyMHxhA$Njz7g.b['7'][1]++,keys[key][index])){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['6'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['36']++;value=keys[key][index];}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['6'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['37']++;return value;}};__cov_TfK6OFh2BYyMHxhA$Njz7g.s['38']++;Y.CategoryImpl=CategoryImpl;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['39']++;Y.CategoryAxisBase=Y.Base.create('categoryAxisBase',Y.AxisBase,[Y.CategoryImpl]);},'3.13.0',{'requires':['axis-base']});
