<?php

// $tmpfolder = moodledata/temp/blogexport/(UNIQUEID)
// $tmpfolder/blogdata/single       : HTML（単一）版
//                    /table        : HTML（表）版
//                    /textdata     : テキストデータ版
//                    /movabletype  : Movable Type版（未実装）
//                    /attachments  : もし”独立した単一のフォルダ”が選択された場合

// データフォルダの作成
function generate_temp_folder($conf)
{
    global $CFG;

    // ルートフォルダの作成
    $tmpfolder = $CFG->dataroot.'/temp';
    if (!fs_file_exists($tmpfolder)) {
        if (! @fs_mkdir($tmpfolder, $CFG->directorypermissions)) return false;
    }
    $tmpfolder .= '/blogexport';
    $pathdata->root = $tmpfolder;
    if (!fs_file_exists($tmpfolder)) {
        if (! @fs_mkdir($tmpfolder, $CFG->directorypermissions)) return false;
    }
    $uniqid = md5(uniqid(rand(), true));
    $tmpfolder .= "/$uniqid";
    $pathdata->unique = $tmpfolder;
    if (!fs_file_exists($tmpfolder)) {
        if (! @fs_mkdir($tmpfolder, $CFG->directorypermissions)) return false;
    } else {
        return false;
    }

    // 出力用フォルダの作成
    $datafolder = $tmpfolder.'/blogdata';
    $pathdata->blogdata = $datafolder;
    if (!fs_file_exists($datafolder)) {
        if (! @fs_mkdir($datafolder, $CFG->directorypermissions)) return false;
    }
    // HTML形式（単一ページ形式，表形式）
    $pathdata->shtmlroot = $shtmlroot = $datafolder.'/single';
    $pathdata->thtmlroot = $thtmlroot = $datafolder.'/table';
    if ($conf->singlehtml) {
        if (!fs_file_exists($shtmlroot)) {
            if (! @fs_mkdir($shtmlroot, $CFG->directorypermissions)) return false;
        }
    }
    if ($conf->tablehtml) {
        if (!fs_file_exists($thtmlroot)) {
            if (! @fs_mkdir($thtmlroot, $CFG->directorypermissions)) return false;
        }
    }
    // テキストデータ形式
    $pathdata->textroot = $textroot = $datafolder.'/textdata';
    if ($conf->textdata) {
        if (!fs_file_exists($textroot)) {
            if (! @fs_mkdir($textroot, $CFG->directorypermissions)) return false;
        }
    }
/*
    // MovableType形式
    $pathdata->movableroot = $movableroot = $datafolder.'/movabletype';
    if ($conf->movabletype) {
        if (!fs_file_exists($movableroot)) {
            if (! @fs_mkdir($movableroot, $CFG->directorypermissions)) return false;
        }
    }
*/

    // 添付ファイル
    $pathdata->attroot = $attroot = $conf->attfolder ? $pathdata->blogdata.'/attachments' : '';
    if ($conf->attfolder) {
        if (!fs_file_exists($attroot)) {
            if (! @fs_mkdir($attroot, $CFG->directorypermissions)) return false;
        }
    }

    return $pathdata;
}

// 基本クラス
class export_format
{
    var $path;
    var $fname;
    var $error;
    var $fp;
    var $count;
    var $type;  // single, table, textdata, movabletype

    function export_format($datapath, $fname, $type)
    {
        global $CFG;
        $this->count = 0;
        $this->error = 0;
        $this->fp;
        $this->fname = $fname;
        // ルートフォルダのセットと確認
        $this->path = $datapath;
        if (!fs_file_exists($this->path)) {
            if (!fs_mkdir($this->path, $CFG->directorypermissions)) {
                $this->error = 1;
                return;
            }
        }
        $this->type = $type;
    }
    // Copy from blog/lib.php and modify
    function copy_blog_attachments($blogentry, $conf) {

        global $CFG;

        // 戻り値初期化
        $urlreturn = $imagereturn = '';
        $ffurlreturn = array();
        // 添付ファイルのコピーと情報取得
        $filearea = blog_file_area_name($blogentry);
        if ($basedir = blog_file_area($blogentry)) {
            if ($files = get_directory_list($basedir)) {
                include_once($CFG->libdir.'/filelib.php');
                // コピー先と相対URLの設定
                switch ($this->type) {
                  // 単一ページ（HTML）
                  case 'single':
                    if ($conf->attfolder) {
                        $attachmentdir = $conf->pd->attroot;
                        $ffurl         = '../attachments/';
                    } else {
                        $attachmentdir = $this->path;
                        $ffurl         = '';
                    }
                    if ($conf->idnumber) {
                        $attachmentdir .= '/'.$blogentry->id;
                        $ffurl         .= $blogentry->id;
                    } else {
                        $attachmentdir .= '/'.$conf->cnt;
                        $ffurl         .= $conf->cnt;
                    }
                    break;
                  // 表形式（HTML）
                  case 'table' :
                  // テキストデータ
                  case 'textdata':
                    if ($conf->attfolder) {
                        $attachmentdir = $conf->pd->attroot;
                        $ffurl         = '../../attachments';
                        if ($conf->idnumber) {
                            $attachmentdir .= '/'.$blogentry->id;
                            $ffurl         .= '/'.$blogentry->id;
                        } else {
                            $attachmentdir .= '/'.$conf->cnt;
                            $ffurl         .= '/'.$conf->cnt;
                        }
                    } else {
                        $attachmentdir = $this->path.'/attachments';
                        $ffurl         = 'attachments';
                    }
                    break;
                  case 'movabletype':
                  default:
                    error('No function!');
                    break;
                }
                if (!empty($ffurl)) $ffurl .= '/';
                if (!fs_file_exists($attachmentdir)) {
                    if (! @fs_mkdir($attachmentdir, $CFG->directorypermissions)) return false;
                }
                foreach ($files as $file) {
                    // すでに他のタイプによりblogdata/attachmentsに添付ファイルがコピーされている場合はコピー不要
                    if (!fs_file_exists($attachmentdir.'/'.$file)) {
                        if (! @fs_copy($basedir.'/'.$file, $attachmentdir.'/'.$file)) return false;
                    }
                    $type = mimeinfo("type", $file);
                    $ffurl .= $file;
                    if (in_array($type, array('image/gif', 'image/jpeg', 'image/png'))) {    // Image attachments don't get printed as links
                        $imagereturn .= "<br /><img src=\"$ffurl\" alt=\"\" />";
                    } else {
                        $urlreturn .= "<a href=\"$ffurl\">$file</a><br />";
                    }
                    $ffurlreturn[] = $ffurl;
                }
            } else return false;
        } else return false;
        $returnobj->url   = $urlreturn;
        $returnobj->image = $imagereturn;
        $returnobj->ffurl = $ffurlreturn; // 非HTML形式用
        return $returnobj;
    }
}

// 単一ページ形式（HTML）
class single_format extends export_format
{
    function output_header($user, $title)
    {
        // ファイルオープン
        if (!($this->fp = fopen($this->path.'/'.$this->fname, 'w'))) {
            $this->error = 2;
            return;
        }
        $lang = str_replace('_', '-', str_replace('_utf8', '', $user->lang));
        fwrite($this->fp, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        fwrite($this->fp, "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"".$lang."\">\n");
        fwrite($this->fp, " <head>\n");
        fwrite($this->fp, "  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
        fwrite($this->fp, "  <title>$title</title>\n");
        fwrite($this->fp, " </head>\n");
        fwrite($this->fp, " <body>\n");
        return true;
    }
    function output_footer()
    {
        fwrite($this->fp, " </body>\n");
        fwrite($this->fp, "</html>\n");
        fclose($this->fp);
        $this->fp = false;
    }
    function output_data($str)
    {
        return fwrite($this->fp, $str);
    }
    function generate_html_single_entry($blogdata, $conf)
    {
        global $CFG;

        $output = '';
        $output .= "<div align=\"left\">\n";
        $output .= '<table border="1" cellspacing="1" cellpading="10" width=80%>'."\n";
        // 見出し
        $output .= '  <tr style="background:#d3d3d3">'."\n";
        $output .= '    <td align=left><b>'.$blogdata->subject."</b><br />\n";
        $output .= '    '.userdate($blogdata->created)."\n";
        $output .= "    </td>\n";
        $output .= "  </tr>\n";
        $output .= "  <tr>\n";
        $output .= "    <td>\n";
        // 添付ファイル
        if ($blogdata->attachment) {
            $output .= "<p align=\"right\">\n";
            $ret = $this->copy_blog_attachments($blogdata, $conf);
            if (!empty($ret->url)) $output .= $ret->url;
            $output .= "</p>\n";
        }
        // 本文
        $output .= format_text($blogdata->summary, $blogdata->format);
        // 画像
        if (!empty($ret->image)) $output .= $ret->image;
        $output .= "    </td>\n";
        $output .= "  </tr>\n";
        $output .= "</table>\n";
        $output .= "</div>\n";
        $output .= "<br />\n";

        // 特例（表形式）
        if ($this->type == 'table' and !($conf->target_blank)) {
            $output .= '<a href="../'.$conf->indexfname.'">'.get_string('backtolist', 'fs_moodle')."</a>\n";
        }
        return $output;
    }
}

// 表形式（HTML）
class table_format extends single_format
{
    function start_main_table()
    {
        $output = '';
        $output .= "<div align=\"left\">\n";
        $output .= '<table border="1" cellspacing="1" cellpading="10" width=80%>'."\n";
        // 見出し
        $output .= '  <tr style="background:#d3d3d3">'."\n";
        $output .= "    <th align=center> No. </th>\n";
        $output .= "    <th align=center> Subject </th>\n";
        $output .= "    <th align=center> Date </th>\n";
        $output .= "  </tr>\n";
        $this->output_data($output);
        return $output;
    }
    function end_main_table()
    {
        $output = '';
        $output .= "</table>\n";
        $output .= "</div>\n";
        $output .= "<br />\n";
        $this->output_data($output);
        return $output;
    }
    function add_row($subject, $date, $conf)
    {
        $this->count++;
        $output = '';
        $output .= "  <tr>\n";
        $output .= "    <td align=center> {$this->count} </td>\n";
        $output .= "    <td> <a href=\"{$subject->url}\" ";
        if ($conf->target_blank) $output .= 'target="_blank"';
        $output .= ">{$subject->text}</a> </td>\n";
        $output .= "    <td> $date </td>\n";
        $output .= "  </tr>\n";
        $this->output_data($output);
        return $output;
    }
}

// テキストデータ形式
class textdata_format extends export_format
{
    function output_header($title)
    {
        // ファイルオープン
        if (!($this->fp = fopen($this->path.'/'.$this->fname, 'w'))) {
            $this->error = 2;
            return false;
        }
        if (!empty($title)) fwrite($this->fp, $title."\n\n");
        return true;
    }
    function output_footer()
    {
        fclose($this->fp);
        $this->fp = false;
    }
    function output_data($str)
    {
        return fwrite($this->fp, $str);
    }
    function add_row($subject, $date)
    {
        $this->count++;
        $output = $this->count."\t".$subject->text."\t".$date."\t".$subject->url."\n";
        $this->output_data($output);
        return $output;
    }
    function generate_textdata_single_entry($blogdata, $conf)
    {
        global $CFG;

        $output = '';
        // ヘッダー（２行）
        $output .= $blogdata->subject."\n";
        $output .= $blogdata->created."\t".userdate($blogdata->created)."\n";
        // 添付ファイル（複数行の可能性あり）
        if ($blogdata->attachment) {
            $ret = $this->copy_blog_attachments($blogdata, $conf);
            foreach ($ret->ffurl as $ffurl) {
                $output .= $ffurl."\n";
            }
        }
        // 空行
        $output .= "\n";
        // 本文
        $output .= format_text($blogdata->summary, $blogdata->format);
        return $output;
    }
}

?>
