<?php
// 【書式】
// [0]: 説明文
// [1]: 有効時コメント
// [2]: 無効時コメント
// [3]: ヘルプ（Wiki）のインデックス，もしfalseならばスイッチ名と同一と判断する
// [4]: 有効/無効の判定に特別な関数を使用する場合に関数名を．特に無いならばfalse.
// [5]: 属性（array)

// 【属性】
// yetMoodle2    : Moodle2への対応が未完
// readyMoodle2  : Moodle2以降も対応
// afterMoodle2  : Moodle2以降のみ対応
// afterMoodle24 : Moodle2.4以降のみ対応
// afterMoodle25 : Moodle2.5以降のみ対応

////////////////////////////////////////////
// 拡張機能無効化スイッチ（デフォルトで有効）

// (Shirai020): 評定の出力でIDナンバーの代わりにユーザー名を表示し，ソートに利用する機能 (Moodle1.9以降のみ)
$fs_switch_strings['FS_DISABLE_GRADE_ID2USERNAME'] = 
    array(
        '評定一覧／小テストのレポートの表示／出力においてIDナンバーの代わりにユーザー名を用いる機能 (Moodle1.9以降のみ)',
        'IDナンバーをユーザー名に置き換えて出力します．',
        'IDナンバーをユーザー名に置き換えません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai054): モバイルモード機能の追加
$fs_switch_strings['FS_DISABLE_MOBILEMODE'] = 
    array(
        'モバイルモード機能の追加（fs_moodleオリジナル機能）',
        'モバイルモードは利用可能です．',
        'モバイルモードは利用できません．',
        false,
        'enable_mobilemode',
        array('yetMoodle2')
        );

// (Shirai080): フォーラム未読をクリアしないで投稿を閲覧する”チョイ読み”機能の追加
$fs_switch_strings['FS_DISABLE_FORUM_TRIALREADING'] = 
    array(
        'フォーラム未読をクリアしないで投稿を閲覧する”チョイ読み”機能',
        'チョイ読み機能は利用可能です．',
        'チョイ読み機能は利用できません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai084): 写真をクリックすると，このフォーラムで，このユーザが投稿した投稿の検索結果を表示する機能の追加 (2008/08/19)
$fs_switch_strings['FS_DISABLE_FORUMSEARCHBYPICTURE'] =
    array(
        '写真をクリックすると，このフォーラムで，このユーザが投稿した投稿の検索結果を表示する機能',
        '写真をクリックするとフォーラム検索します．',
        '写真をクリックするとユーザプロファイルが表示されます．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai088): フォーラムのスレッドをZIPファイルで出力するフォーラムダンプ機能の追加 (2008/08/29)
$fs_switch_strings['FS_DISABLE_FORUMDUMP'] =
    array(
        'フォーラムのスレッドをZIPファイルで出力するフォーラムダンプ機能',
        'フォーラムダンプ機能は利用可能です．',
        'フォーラムダンプ機能は利用できません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai095): 小テストのタイマー表示位置を画面四隅に動かすボタンの追加(2008/09/13)
$fs_switch_strings['FS_DISABLE_TIMERPOSITION'] =
    array(
        '小テストのタイマー表示位置を画面四隅に動かすボタンの追加の設定',
        'タイマーの位置を移動可能です．',
        'ボタンは表示されず，オリジナル同様に左上の位置にタイマーは表示されます．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai098): 提出された課題の明白な手抜きを見抜く機能 (2008/10/28)
$fs_switch_strings['FS_DISABLE_ASSIGNMENT_BONENEADCHECK'] =
    array(
        '提出された課題の明白な手抜きを見抜く機能',
        '明白な手抜きを見抜く機能を教師は利用できます．',
        'この機能は利用できません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai104): 電子メールの送信時のワードラップ処理がマルチバイトを考慮していない問題の改善 (2008/12/10)
$fs_switch_strings['FS_DISABLE_MULTIBYTE_WORDWRAP'] =
    array(
        '電子メールの送信時のワードラップ処理がマルチバイトを考慮していない問題',
        'マルチバイト対応のワードラップ処理を行います．', 
        'オリジナル通りのワードラップ処理を行います．'.
        '　オリジナルの挙動よりもマルチバイト対応の方が悪くなることはありませんので，この機能はマルチバイト対応に設定することを勧めます．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai109): メッセージによる電子メール送信時のSubjectを入力欄第１行目の文章のみとする改良 (2008/12/19)
$fs_switch_strings['FS_DISABLE_MESSAGESUBJECT'] =
    array(
        'メッセージによる電子メール送信時のSubjectを入力欄第１行目の文章のみとする',
        'メッセージ入力欄の１行目を電子メールのSubjectとします．',
        'オリジナルのルールにしたがって電子メールのSubjectとします．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai118): フォーラム投稿のサーチ機能を強化するいくつかの機能拡張 (2009/02/12)
$fs_switch_strings['FS_DISABLE_FORUM_EXSEARCH'] =
    array(
        'フォーラム投稿のサーチ機能を強化するいくつかの機能拡張',
        'サーチ機能を強化するいくつかの機能拡張は有効です．',
        'サーチ機能を強化するいくつかの機能拡張は無効です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai132): パスワード変更の強制がOnのままのユーザを発見するためのフィルタをユーザリストの表示に追加 (2009/05/08)
$fs_switch_strings['FS_DISABLE_FORCEPASSWORDCHANGE_FILTER'] =
    array(
        'パスワード変更の強制がOnのままのユーザを発見するためのフィルタをユーザリストの表示に追加',
        'このフィルタは利用可能です．',
        'このフィルタは利用できません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai134): iPod touch（多分，iPhoneも含む）ではフォーラムに貼付されたテキストファイルなど（mimetypeがtext/plain）が表示できない問題の改善
$fs_switch_strings['FS_DISABLE_DISPLAYATTACHEDFILEiPods'] =
    array(
        'iPod touch/iPhoneでフォーラム投稿などの添付ファイルを閲覧可能とする設定',
        'iPod touch/iPhoneユーザも添付ファイルを閲覧可能です．',
        'iPod touch/iPhoneユーザは添付ファイルを閲覧不可です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai005): 未送信の要約メールをいつでもユーザプロフィール画面で表示可能（HTML形式）とする改良
$fs_switch_strings['FS_DISABLE_DISPLAYUNMAILEDFORUMLIST'] =
    array(
        '未送信の要約メールをいつでもユーザプロフィール画面で表示可能（HTML形式）とする設定',
        '未送信の要約メールの内容をいつでも閲覧することができます．',
        '未送信の要約メールの内容をいつでも閲覧可能な機能は無効です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai157): ”このコンテンツを電子メール送信するボタン”機能の追加 (2009/07/04)
$fs_switch_strings['FS_DISABLE_SENDTHISCONTENTS2ME'] =
    array(
        '”このコンテンツを電子メール送信するボタン”機能',
        '”このコンテンツを電子メール送信ボタン”機能は有効です．',
        '”このコンテンツを電子メール送信ボタン”機能は無効です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai158): fs_moodleでページフッターに追加したボタン類を隠す機能の追加 (2009/07/07)
$fs_switch_strings['FS_DISABLE_FSADVMENUDISPLAY'] =
    array(
        'fs_moodleでページフッターに追加したボタン類を隠す機能',
        'fs_moodleで拡張したフッターメニューは表示されます．',
        'fs_moodleで拡張したフッターメニューは一切表示されません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai163): ブログに返信機能を追加 (2009/08/26)
$fs_switch_strings['FS_DISABLE_BLOGREPLY'] =
    array(
        'ブログに返信機能を追加する機能',
        'ブログの返信機能が利用可能です．',
        'ブログの返信機能は利用できません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai178): グループのユーザを追加/削除するにおいてユーザ名などでソーティング可能（＋表示）とする改良 (2010/01/22)
$fs_switch_strings['FS_DISABLE_GROUPMEMBERSORTBY'] =
    array(
        'グループの”ユーザを追加/削除する”においてユーザ名などでソーティング可能とする機能',
        '$fsCFG->groupmembersortbyで選択した項目でソートします．',
        '標準どおり姓でソートします．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai165): 課題提出（複数ファイルのアップロード）においてファイル一覧表示をリッチにする改良 (2009/09/04)
$fs_switch_strings['FS_DISABLE_ASSIGNUPLOAD_RICHDISPLAY'] =
    array(
        '課題提出（複数ファイルのアップロード）においてファイル一覧表示をリッチにする機能',
        'リッチなファイル情報の表示機能が有効です．',
        '標準に近い地味な画面表示です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai181): 携帯電話でログインする時にユーザ名入力フォームで入力モードを自動的にアルファベットに変更する機能の追加 (2010/02/10)
$fs_switch_strings['FS_DISABLE_KEITAIHANKAKUINPUT'] =
    array(
        '携帯電話でログインする時にユーザ名入力フォームで入力モードを自動的にアルファベットに変換する機能',
        '携帯電話の入力モードを半角英字モードに切り替えます．',
        '標準通りに入力モードを制御しません．',
        false,
        false,
        array('yetMoodle2')
        );

////////////////////////////////////////////
// 拡張機能有効化スイッチ（デフォルトで無効）
////////////////////////////////////////////

// (Shirai076): PDF2JPEG変換出力機能
$fs_switch_strings['FS_ENABLE_PDF2JPEG'] =
    array('PDF2JPEG変換出力機能',
        'PDF2JPEG変換出力機能をユーザは利用可能です．',
        'PDF2JPEG変換出力機能をユーザは選択不可です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai078): ログイン時のユーザ名自動入力機能を抑制する改良 (2008/08/06)
$fs_switch_strings['FS_ENABLE_VOIDLOGINNAME'] =
    array(
        'ログイン時のユーザ名自動入力機能を抑制する機能',
        '自動入力は抑制されるので安全です．',
        'オリジナル同様に自動入力されます．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai092): ”新しいアカウントを作成する（Signup）”をサブネット内のPCからしか利用できないように制限する機能の追加 (2008/09/02)
$fs_switch_strings['FS_ENABLE_SIGNUPINSUBNETONLY'] =
    array(
        '許可された領域外のコンピュータからは新しいアカウントの作成を行えない機能',
        '$CFG-subnetで指定したサブネット内の端末以外からは新規アカウントの作成は行えません．',
        '世界中どの端末からでも新規アカウントの作成ができてしまいます．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai099): 同時送信する第２のメールアドレスを指定可能とする改良(2008/11/02)
$fs_switch_strings['FS_ENABLE_SECONDADDRESS'] =
    array(
        '同時送信する第２のメールアドレスを指定可能とする機能',
        '同時送信メールアドレスを設定し，チェックボックスがチェックされているならば二つのメールアドレスにメールが送信されます．',
        'Ｅメールの同時送信機能は無効です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai105): 電子メール送信時の詳細なログを残す機能を追加（デフォルトで無効） (2008/12/11)
$fs_switch_strings['FS_ENABLE_EMAIL_DETAILLOG'] =
    array(
        '電子メール送信時の詳細なログを残す機能',
        '電子メール送信時の詳細なログを保存します．',
        '電子メール送信時の詳細なログを残す機能は無効です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai108): ユーザプロファイルフィールドの各項目の説明をポップアップ表示可能とする(2008/12/18)
$fs_switch_strings['FS_ENABLE_POPUP_USERPROFILEDESCRIPTION'] =
    array(
        'ユーザプロファイルフィールドの編集画面においてフィールドの説明を表示可能とする機能',
        'フィールド名にマウスカーソルを合わせると説明がポップアップ表示されます．',
        'フィールド名の説明は表示されません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai111): SMTPサーバとの接続のチェックの強化とリトライ (2008/12/25)
$fs_switch_strings['FS_ENABLE_SMTP_CONNECT_CHECKandRETRY'] =
    array(
        'SMTPサーバとの接続のチェックの強化とリトライ機能',
        'SMTPサーバとの接続を厳密にチェックし，失敗時はリトライを行います．',
        'オリジナル通りにSMTPサーバとの接続は厳密にチェックしません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai114): 小型携帯端末での表示を可能な限り改善するための改良 (2009/01/17)
$fs_switch_strings['FS_ENABLE_MOBILE_DISPLAY'] =
    array(
        '小型携帯端末での表示を可能な限り改善する機能',
        '小型携帯端末での表示を可能な限り改善します．',
        'ＰＣ向けと同じ内容を小型携帯端末に対しても送信します．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai116): バックアップ時に生成されるZIPファイルをコースのbackupフォルダに高速かつ安全（2GB以上でもOK）に移動するための改良 (2009/02/06) 
$fs_switch_strings['FS_ENABLE_COPY2RENAME_BACKUP'] =
    array(
        'バックアップファイルをコースのbackupフォルダに高速かつ安全に移動する機能',
        'バックアップファイルの書き戻しにrename()を用いて高速に行います．',
        '標準のMoodleと同じくバックアップファイルの書き戻しにcopy()を用います．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai117): メッセージ（メール）の送信に失敗した場合にmessage機能で管理者に警告を出力する機能の追加 (2009/02/11)
$fs_switch_strings['FS_ENABLE_MESSAGE2ADMIN_EMAILFAILED'] =
    array(
        'メッセージ（メール）の送信に失敗した場合にmessage機能で管理者に警告を出力する機能',
        'メール送信失敗時に管理者にmessageを送出します．',
        'メール送信失敗時に管理者にmessageを送出しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai121): サイトに登録されていないユーザであっても認証プラグインでログインが認証された場合にはユーザが自動作成されるのを抑制可とする改良 (2009/02/24)
$fs_switch_strings['FS_ENABLE_AVOID_AUTOUSERCREATION'] =
    array(
        'サイトに登録されていないユーザであっても認証プラグインでログインが認証された場合にはユーザが自動作成されるのを防ぐ機能',
        '本サイトに存在しないユーザが認証プラグインによって認識されても新規ユーザ登録を行いません．',
        '標準と同様に認証プラグインで認証されたユーザが本サイトに存在しない場合は自動的にユーザ登録します．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai130): 少々不正なEmailアドレス（@の前に複数のピリオドの連続を含む）を許す改善 (2009/04/20)
$fs_switch_strings['FS_ENABLE_ALLOWINVALIDEMAILADDRESS'] =
    array(
        '少々不正なEmailアドレス（@の前に複数のピリオドの連続を含む）も許す設定',
        '少々不正なＥメールアドレスでもユーザ登録を受け付けます．', 
        '正式なＥメールアドレスでなくてはユーザ登録を受け付けません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai150): グローバルサーチにおいて検索キーワードがどのようにトークン化されたのかを表示する機能の追加 (2009/06/18)
$fs_switch_strings['FS_ENABLE_GS_DISPLAY_TOKENIZED_WORDS'] =
    array(
        'グローバルサーチにおいて検索キーワードがどのようにトークン化されたのかを表示する機能',
        '検索キーワードがどのようにトークン化されるのかを表示します．', 
        'オリジナル同様に，検索キーワードがどのようにトークン化されるのか表示しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai152): グローバルサーチでフォーラムの添付ファイルにも対応する改良 (2009/06/26)
$fs_switch_strings['FS_ENABLE_GS_INDEXFORUMATTACHMENTS'] =
    array(
        'グローバルサーチでフォーラムの添付ファイルにも対応する設定',
        'フォーラム投稿の添付ファイルをインデックス化します．', 
        'フォーラム投稿の添付ファイルをオリジナル同様にインデックス化しません．',
        'Shirai152',
        false,
        array('yetMoodle2')
        );

// (Shirai156): 数式（TeXフィルタ）をHTMLareaで容易に入力可能とするDragMath Equation Editorを組み込む改良 (2009/07/01)
$fs_switch_strings['FS_ENABLE_DRAGMATHEQUATIONEDITOR'] =
    array(
        '数式を容易に入力可能とするDragMath Equation Editorを組み込む設定',
        'HTMLエディタのツールバーにDragMath Equation Editorのアイコンを表示します．',
        'HTMLエディタのツールバーにDragMath Equation Editorのアイコンを表示しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Debug023): HTMLエディタ(HTMLarea)のボタンがツールバー右端にはみ出すバグ (2009/07/15)
$fs_switch_strings['FS_ENABLE_MODIFYHTMLAREATOOLBUTTONDISPLAY'] =
    array(
        'HTMLエディタのボタンがハミ出す場合に関する設定',
        'HTMLエディタのツールバーからボタンがハミ出さないように対策を行います．',
        'HTMLエディタのツールバーからボタンがハミ出さないように対策を行いません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai161): ブログをエクスポートする機能の追加 (2009/07/25)
$fs_switch_strings['FS_ENABLE_BLOGEXPORT'] =
    array(
        'ブログをダウンロード（エクスポート）する機能',
        'ブログエクスポート機能が有効です．',
        'ブログエクスポート機能は無効です．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai166): パスワード忘失時の再発行要求時にアカウント名とメールアドレスの両方を入力しないと受け付けない制限の追加 (2009/09/11)
$fs_switch_strings['FS_ENABLE_NEEDBOTHINFO2REQUESTPASSWORD'] =
    array(
        'パスワード忘失時の再発行要求時にアカウント名とメールアドレスの両方を入力しないと受け付けない制限',
        'ユーザ名とメールアドレスを正確に入力する必要があります．',
        '標準のMoodle同様にユーザ名かメールアドレスいずれか一方を入力するだけで良いです．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai171): 特定の拡張子や指定したサイズ以上のファイルをバックアップしない機能の追加 (2009/10/08)
$fs_switch_strings['FS_ENABLE_BACKUP_EXCEPTION'] =
    array(
        '指定した条件に合致するファイルやフォルダをコースバックアップしない機能',
        'バックアップ制限条件に合致するファイル（やフォルダ）のバックアップを行いません．',
        '標準のMoodle同様に全てのファイルをバックアップします．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai172): フッターにバナーなどを表示可能とする機能の追加 (2009/10/22)
$fs_switch_strings['FS_ENABLE_FOOTER_BANNER'] =
    array(
        'フッターにバナーなどを表示可能とする機能',
        '画面下のフッターに管理者が追加したバナーなどを表示します．',
        '画面下のフッターにバナーなどを表示しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai174): 指定されたコースのみゲストでのオートログインを可能とする機能の追加 (2009/11/05)
$fs_switch_strings['FS_ENABLE_AUTOLOGINGUESTS'] =
    array(
        '指定されたコースのみゲストでのオートログインを可能とする機能',
        color_blue('ゲストでオートログインが有効かどうか').'に対して例外を認めます．',
        '標準のとおりに'.color_blue('ゲストでオートログインが有効かどうか').'に全コースが従います．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai182): 二つのURLから一つのMoodleにアクセスしているシステムにおいて外部に供給するURLのベースアドレス（通常は$CFG->wwwroot）を統一できる改良 (2010/03/21) : Moodle1.9まで
// (Shirai018): プロキシを利用しているコース（wwwrootと実際のURLが異なる）で発生する諸問題への対処 (2014/04/21) : Moodle2.5以降
$fs_switch_strings['FS_ENABLE_USEPUBLICWWWROOT'] =
    array(
        '複数のURLを持つMoodleサイトにおいてリンクとして外部に供給するURLを一つに統一する機能',
        color_blue('$fsCFG->publicwwwroot').'に設定されたURLをベースアドレスとして用います．',
        '標準の'.color_blue('$CFG=>wwwroot').'をベースアドレスとして用います．',
        false,
        false,
        array('afterMoodle25')
        );

// (Shirai183): カレンダーの土日と祝日に文字色を付ける改良 (2010/04/01)
$fs_switch_strings['FS_DISABLE_CALENDARCOLOREDWEEKEND'] =
    array(
        'カレンダーの土日の文字に色を付ける改良',
        'カレンダーの土日の文字に色を付けます．',
        '標準のMoodle同様に色は付けません．',
        false,
        false,
        array('yetMoodle2')
        );

$fs_switch_strings['FS_DISABLE_CALENDARCOLOREDSPECIAL'] =
    array(
        'カレンダーの特別なイベント（休日など）の文字に好きな色を付ける改良',
        'カレンダーイベントの記述の頭の文字に応じて文字の色を変え，識別用の接頭辞を取り除きます．',
        '標準のMoodle同様に色は付けませんし，識別用の接頭辞を取り除きません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai184): カレンダーの終了日の時刻の初期値を２３時５５分に変更する改良 (2010/04/07)
$fs_switch_strings['FS_DISABLE_CALENDARENDTIME2355'] =
    array(
        'カレンダー入力／編集時の終了日の時刻の初期値を２３時５５分に変更する改良',
        '終了日の時刻の初期値を２３時５５分に変更します．',
        '終了日の時刻の初期値は標準のMoodleと同様に００時００分のままです．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai185): モジュールの追加／更新時の「保存してコースに戻る」時と，画面下のジャンプボタンを押してモジュールからコースに戻る際に，ページトップではなくモジュールの属するセクションへジャンプする機能の追加 (2010/04/08)
$fs_switch_strings['FS_DISABLE_BACKTOSECTION'] =
    array(
        'モジュールからコースに戻る際にモジュールの属するセクションに戻る改良',
        'モジュールから戻る際に属するセクションに戻る．',
        'モジュールから戻る際に標準のMoodle同様にページトップに戻る．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai186): iCalendar出力を終日イベントに対応させる改良 (2010/04/09)
$fs_switch_strings['FS_DISABLE_EXTENDEDICALEXPORT'] =
    array(
        'MoodleカレンダーのiCalendar出力を終日イベントに対応させる改良',
        'iCalendar出力を終日イベントに対応させる．',
        '標準のMoodle同様に終日イベントには対応しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Debug034): get_string()の親言語（parentanguage）の処理が正しくないバグ (2010/05/11)
$fs_switch_strings['FS_ENABLE_MODIFIEDPARENTLANGUAGE'] =
    array(
        '言語パックの親言語機能がサードパーティ製モジュールに対して正常に機能しないバグ',
        '修正版のget_string()関数を利用してバグに対処する．',
        '標準のget_string()関数を利用し，バグには対処しない．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
// (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
$fs_switch_strings['FS_ENABLE_MAIL2BLOGFUNCTION'] =
    array(
        '電子メールでブログを投稿する機能',
        '電子メールでブログを投稿する機能が利用可能です．',
        '電子メールでブログを投稿する機能が利用できません．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_ENABLE_MAIL2BLOGREPLYMAIL'] =
    array(
        '電子メールによるブログ投稿の結果をメールで投稿者に返信する機能',
        '投稿結果を投稿者にメールで通知する',
        '投稿結果を一切，メールで通知しない．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_ENABLE_MAIL2BLOGLOG'] =
    array(
        'ブログ投稿結果をログファイルに記録する機能',
        'ブログ投稿結果をログファイルに記録する．',
        'ブログ投稿結果をログファイルに記録しない．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_ENABLE_MAIL2BLOGRESIZEPICTURE'] =
    array(
        '電子メールで投稿されたブログの添付画像をリサイズする機能',
        '添付画像のサイズが制限を越えたらリサイズする．',
        '添付画像のサイズが制限を越えてもリサイズしない．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai188): ブログの貼付画像のサイズを制限する機能の追加 (2010/05/20)
// (Shirai189): フォーラムの貼付画像のサイズを制限する機能の追加 (2010/05/20)
$fs_switch_strings['FS_ENABLE_RESTRICT_IMAGESIZE'] =
    array(
        'ブログとフォーラム投稿の添付画像の最大サイズを制限して縮小表示する機能',
        '添付画像のサイズが制限を越えたら縮小表示する．',
        '添付画像のサイズが制限を越えても縮小表示しない．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai190): ユーザ画像の表示範囲を制限可能とする機能の追加 (2010/06/01)
$fs_switch_strings['FS_ENABLE_PRINTUSERPICTURELEVEL'] =
    array(
        'ユーザ画像の表示範囲を制限する機能',
        'ユーザ画像の表示範囲を制限する．',
        'ユーザ画像の表示範囲を制限しない．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai192): Wikiなどのコンテンツに更新があったことをコースの画面上に表示する機能を追加 (2010/08/03)
$fs_switch_strings['FS_DISABLE_RA_LINK_JAVASCRIPT'] =
    array(
        'リソース更新のリスト一覧を表示するのにJavaScriptを一切使用しない設定',
        'JavaScriptを使った高度な表示を基本的に使用する．',
        'HTMLのみを用いた古風な表示のみを使用する．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_ENABLE_RA_LINK_CUSTOMATTRIBUTE'] =
    array(
        'Wikiなどの更新情報をコースに表示する文字列の書式をカスタマイズ可能とするスイッチ',
        '$fsCFG->ra_link_customattributeで指定した属性を用いて表示する．',
        '標準の属性（未読と同じ）を用いて表示する．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_DISABLE_RA_WIKI'] =
    array(
        'Wikiのリソースに更新があったことを通知する機能',
        'Wikiの更新を通知する．',
        'Wikiの更新を通知しない．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_DISABLE_RA_GLOSSARY'] =
    array(
        '用語集（Glossary）に更新があったことを通知する機能',
        '用語集（Glossary）の更新を通知する．',
        '用語集（Glossary）の更新を通知しない．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai195): Safari, ChromeなどIEとFirefox以外でもHTMLエディタを利用可能とする改良 (2010/09/17) 
$fs_switch_strings['FS_DISABLE_USEHTMLEDITOR_SAFARI'] =
    array(
        'SafariでもHTMLエディタを利用可能とするスイッチ',
        'SafariでもHTMLエディタの利用を可能とします．',
        '標準通り，SafariではHTMLエディタを利用できません．',
        false,
        false,
        array('yetMoodle2')
        );
$fs_switch_strings['FS_DISABLE_USEHTMLEDITOR_CHROME'] =
    array(
        'ChromeでもHTMLエディタを利用可能とするスイッチ',
        'ChromeでもHTMLエディタの利用を可能とします．',
        '標準通り，ChromeではHTMLエディタを利用できません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai198): 課題の通知メールにコメントを挿入する改善 (2010/09/25)
$fs_switch_strings['FS_ENABLE_ADDCOMMENT2GRADINGNOTIFICATIONEMAIL'] =
    array(
        '課題の通知メールにフィードバックのコメントを挿入する機能',
        '通知メールにコメントを挿入します．',
        '標準通り，通知メールにコメントを挿入しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai199): ”すべてのユーザに私のメールアドレスを公開する”に設定していない場合，ユーザプロファイル画面で自分自身の電子メールアドレスが表示されない問題の改良 (2010/09/25)
$fs_switch_strings['FS_DISABLE_DISPLAYMAILADDRESSOWN'] =
    array(
        '自分自身のユーザプロファイル画面には無条件でメールアドレスを表示する改良',
        '自分自身のメールアドレスならば表示します．',
        '標準通り，”すべてのユーザに私のメールアドレスを公開する”時以外は表示しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai200): ユーザプロファイル画面のメールアドレスの右横にテストメールを送信するボタンを追加する (2010/09/25)
$fs_switch_strings['FS_DISABLE_SENDTESTMAILBUTTON'] =
    array(
        'ユーザプロファイル画面のメールアドレスの横にテストメール送信ボタンを追加する改良',
        'テストメール送信ボタンを追加します．',
        'テストメール送信ボタンは追加しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai201): 登録キーが登録されているコースからユーザ自ら登録抹消する際に登録キーの入力を要求する機能の追加 (2010/11/18)
$fs_switch_strings['FS_DISABLE_NEEDPASSWORD2COURSEENROLE'] =
    array(
        '登録キーが登録されているコースからユーザ自ら登録抹消する際に登録キーの入力を要求する機能',
        '登録キーの入力を要求します．',
        '登録キーの入力を要求しません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai202): PHPでは取り扱えない2GBを越えるファイルを取り扱えるようにする改良 (2010/12/02)
$fs_switch_strings['FS_ENABLE_MANIPULATEOVER2GBFILE'] =
    array(
        'PHPでは取り扱えない2GBを越えるファイルを取り扱えるようにする改良',
        '外部コマンドを利用して2GBを超えるファイルも扱えるようにします．',
        '標準の機能を用いるので2GBを超えるファイルは扱えません．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai214): Webブラウザベースで音声の録音／再生を行うNanoGongを利用可能とする改良 (2011/05/21)
$fs_switch_strings['FS_ENABLE_NANOGONG'] =
    array(
        'Webブラウザベースで音声の録音／再生を行うNanoGongを利用可能とする改良',
        'NanoGongを利用可能とします．',
        'NanoGongを利用不可とします（NanoGongをインストール済みかつ利用可能な状態から変更するとエラーが発生する危険性があります）．',
        false,
        false,
        array('yetMoodle2')
        );

// (Shirai216): トピックスフォーマットにおいて「コースの特定のトピックだけを表示するアイコン□を間違って押して混乱する」のを防ぐために非表示にする機能の追加 (2011/10/27)
$fs_switch_strings['FS_ENABLE_NOSHOW_SHOWONLYTOPICBUTTON'] =
    array(
        'トピックスフォーマットにおいて「コースの特定のトピックだけを表示するアイコン□を間違って押して混乱する」のを防ぐために非表示にする機能',
        'コースの特定のトピックだけを表示するアイコン□を表示しません．',
        'コースの特定のトピックだけを表示するアイコン□を表示します．',
        false,
        false,
        array('yetMoodle2')
        );

// 以下，fs_moodle5.00.04より番号を振り直した新番号

// (Shirai003): Backup/Restoreの際のログを記録してデバッグを助ける機能の追加 (2013/10/12)
$fs_switch_strings['FS_ENABLE_DETAILLOG_BACKUPRESTORE'] =
    array(
        'バックアップ及びリストアにおいて詳細なログをmoodledata/temp/backupに出力する機能',
        'バックアップ及びリストアにおいて詳細なログを記録します．',
        'バックアップ及びリストアにおいて詳細なログを記録しません．',
        false,
        false,
        array('afterMoodle24')
        );
// (Shirai004): バックアップ終了後にmbzファイルをtemp/backupフォルダから削除しない機能の追加 (2013/04/29)
// 当初，ファイルストレージへのコピーも省略できるようにしようと思ったが，副作用が怖いので削除のみ省略
$fs_switch_strings['FS_ENABLE_DONOT_DELETE_BMZ'] =
    array(
        'バックアップ終了後にmbzファイルをtemp/backupフォルダから削除しない機能',
        'バックアップ終了後にmbzファイルをtemp/backupフォルダから削除しません．',
        '通常通りにバックアップ終了後にmbzファイルをtemp/backupフォルダから削除します．',
        false,
        false,
        array('afterMoodle24')
        );
// (Shirai005): サイトの”ユーザ一覧を表示する”とコースの"登録ユーザ"の一覧においてユーザ名の表示とソーティングを可能とする改良(2013/10/14)
$fs_switch_strings['FS_DISABLE_DISPLAYandSORT_BY_USERNAME'] =
    array(
        'サイトの”ユーザ一覧を表示する”とコースの"登録ユーザ"の一覧においてユーザ名の表示とソーティングを可能とする機能',
        'ユーザ名の表示とユーザ名によるソーティングが可能です．',
        '通常通りにユーザ名は表示しません．',
        false,
        false,
        array('afterMoodle24')
        );
// (Shirai017): コースバックアップファイルをダウンロードではなくmoodledata/temp/backupへ直接コピーする機能 (2013/10/15)
$fs_switch_strings['FS_ENABLE_COPY_MBZ_DIRECTLY2MOODLEDATA'] =
    array(
        'コースバックアップファイルをダウンロードではなくmoodledata/temp/backupへ直接コピーする機能（ダイレクトコピー）',
        'ダイレクトコピー機能を有効とする．',
        'ダイレクトコピー機能は無効です．',
        false,
        false,
        array('afterMoodle25')
        );

// ----------------------- Library ---------------------------

function print_section_header_fs_switch($defname)
{
    print_section_header(title_fs_switch($defname, false), link2fs_switch($defname));
}

function print_subsection_header_fs_switch($defname)
{
    print_subsection_header(title_fs_switch($defname, false), link2fs_switch($defname));
}

function print_subsubsection_header_fs_switch($defname)
{
    print_subsubsection_header(title_fs_switch($defname, false), link2fs_switch($defname));
}

function link2fs_switch($defname)
{
    global $fs_switch_strings;
    if (empty($fs_switch_strings[$defname])) return '(No link)';
    $switch_string = $fs_switch_strings[$defname];
    if (empty($switch_string[3])) $linkname = $defname; else $linkname = $switch_string[3];
    return link2fs_wiki($linkname, $switch_string[0]);
}

// 設定値の説明の頭に追加する属性に基づく文字列を返す
function attribute_strings_fs_switch($switch_string)
{
    // 属性未設定
    if (!isset($switch_string[5])) return '';
    $attribute = $switch_string[5];

    return attribute_strings($attribute);
}

// セクション等に設定値の説明を表示するための文字列を返す
function title_fs_switch($defname, $notag = true)
{
    global $titleonly, $page, $CFG;
    global $fs_switch_strings;

    if (empty($fs_switch_strings[$defname])) return '(No Title)';
    $switch_string = $fs_switch_strings[$defname];

    // 整形出力の場合はリンクを生成しない
    if ($notag) return $switch_string[0].'('.$defname.')';

    // 属性に基づいて文字列を頭に追加する
    $title  = attribute_strings_fs_switch($switch_string);
    if (!empty($title)) $title .= ':';
    $title .= $switch_string[0].'<a name="'.$defname.'"></a>';

    // タイトル一覧表示の場合はタイトルにダイレクトリンクを設定する
    if (empty($titleonly)) {
//      $title .= '('.$defname.')';
    } else {
        $title .= '<a href="'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/index.php?page='.$page.'#'.urlencode($defname).'">'.'('.$defname.')'.'</a>';
    }
    return $title;
}

function get_fs_switch_default($defname)
{
    // FS_ENABLE系は宣言しないと有効，FS_DISABLE系は宣言しないと無効
    if (($h_defname = substr($defname, 0, 10)) == 'FS_ENABLE_') $fs_enable_switch = true;
      else                                                      $fs_enable_switch = false;
    return !$fs_enable_switch;
}

// FS_ENABLE_/FS_DISABLE_系共用
// 動的にメッセージが生成される場合は引数を用いる
function print_fs_switch_condition($defname, $enablestr = '', $disablestr = '')
{
    global $fs_switch_strings;
    global $SESSION;

    // $defnameのチェック
    if (($h_defname = substr($defname, 0, 10)) == 'FS_ENABLE_') $fs_enable_switch = true;
      else if ($h_defname == 'FS_DISABLE')                      $fs_enable_switch = false;
      else {
        echo '<br /><b>システムエラー</b>：';
        echo $defname.'がFS_ENABLE_, FS_DISABLEで始まっていません！<br />'; die;
    }
    // fs_switch_strings.phpのチェック
    if (empty($fs_switch_strings[$defname])) {
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_switch_strings.php中に$fs_switch_strings['.$defname.']の記述がありません．<br />'; 
        die;
    }
    if (($cnt = count($switch_string = $fs_switch_strings[$defname])) < 6) {
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_switch_strings.phpの記述が正しくありません．<br />'; 
        die;
    }
    $strenable  = (empty($enablestr)  ? $switch_string[1] : $enablestr);
    $strdisable = (empty($disablestr) ? $switch_string[2] : $disablestr);
    $funcname   = (empty($switch_string[4]) ? 'fs_function_enable' : $switch_string[4]);
    // $funcnameのチェック
    if (($funcname == 'fs_function_enable') or (!function_exists($funcname))) {
        if (!function_exists($funcname)) {
            echo '<br /><b>システムエラー</b>：';
            echo $funcname.'は存在しません！<br />'; die;
        }
        $func = "return fs_function_enable('$defname');";
    } else {
        $func = "return $funcname();";
    }

    // 出力および変更メニュー
    echo  '<hr size="2" style="color: #e0c4b0; border-style:dashed" />';
    $out  = '';
    $out .= '　この機能は';
    $out .= color_blue('標準で'.($fs_enable_switch ? '無効' : '有効'));
    $out .= 'です．';
    $out .= ($fs_enable_switch ? '有効化' : '無効化');
    $out .= 'するには'.color_blue("define('".$defname."',true)").'を有効にする必要があります．';
    echo $out;
    newline();
    $out = '';
    $out .= '　現在，"'.$defname.'"は';
    if ($fs_enable_switch) {
        if (defined($defname)) {
            $out .= color_blue('定義されています').'．';
            if (eval($func)) {
                $out .= 'したがって，'.$strenable;
                $enable = true;
            } else {
                $out .= 'しかし，'.color_blue('無効（=false）').'なので，'.$strdisable;
                $enable = false;
            }
        } else {
            $out .= color_blue('定義されていない').'ので，'.$strdisable;
            $enable = false;
        }
    } else {
        if (defined($defname)) {
            $out .= color_blue('定義されています').'．';
            if (eval($func)) {
                $out.= 'しかし，'.color_blue('無効（=false）').'なので，'.$strenable;
                $enable = true;
            } else {
                $out .= 'したがって，'.$strdisable;
                $enable = false;
            }
        } else {
            $out .= color_blue('定義されていない').'ので，'.$strenable;
            $enable = true;
        }
    }
    $out .= newline(false);
    echo $out;

    // 変更されている場合
    $out = '';
    if (isset($SESSION->fscfg->$defname)) {
        $out .= '　なお，';
        $out .= color_blue('設定は変更されています').'．';
        $out .= '「更新＋上書き保存」後は，';
        if ($fs_enable_switch) $out .= $strdisable;
            else               $out .= $strenable;
        $out .= newline(false);
    }
    echo $out;

    // 編集モードではない場合はここまで
    if (empty($SESSION->fscfgedit)) {
        echo '<hr size="2" style="color:#e0c4b0; border-style:dashed" />';
        return $enable;
    }

    // スイッチの変更メニュー
    $out = $tbl = $frm = '';
    $out .= '<div style="padding-left:1em; padding-top:5px; padding-bottom:5px;">';
    $tbl .= '<table ';
    if (isset($SESSION->fscfg->$defname)) $tbl .= 'bordercolor="#ff0000"';
        else                              $tbl .= 'bordercolor="#ccccff"';
    $tbl .= ' cellpadding="6" style="border:solid 1px">';
    $tbl .= '<tr bgcolor="#ccccff">';
    $tbl .= '<th>';
    $tbl .= attribute_strings_fs_switch($switch_string);
    $tbl .= '［スイッチ変更メニュー］';
    $tbl .= '</th>';
    $tbl .= '</tr>';
    $tbl .= '<tr><td>';
    if (isset($SESSION->fscfg->$defname)) {
        $tbl .= '　変更された設定値は';
        $tbl .= color_blue($SESSION->fscfg->$defname ? '有効' : '無効');
        $tbl .= 'です．';
    }
    $out .= $tbl;

    // 設定値の変更
    $nowenable = $enable;
    if (isset($SESSION->fscfg->$defname)) {
        $nowenable = $SESSION->fscfg->$defname;
    }

    $frm = '';
    $frm .= '<form method="POST" action="#'.$defname.'">';
    $frm .= '　設定の変更：';
    $frm .= '<input type="radio" name="'.$defname.'" value="1"';
    if ($nowenable) $frm .= ' checked';
    $frm .= ' /> 有効';
    $frm .= '&nbsp;';
    $frm .= '<input type="radio" name="'.$defname.'" value="0"';
    if (!$nowenable) $frm .= ' checked';
    $frm .= ' /> 無効';
    $frm .= '&nbsp;&nbsp;';
    $frm .= '<input type="hidden" name="defname" value="'.$defname.'" />';
    $frm .= '<input type="submit" value="更新" />';
    if (isset($SESSION->fscfg->$defname)) {
        $frm .= '<input type="submit" name="clear" value="変更取消" />';
    }
    $frm .= '</form>';
    $out .= $frm;
    
    $tbl  = '';
    $tbl .= '</tr></td>';
    $tbl .= '</table>';
    $out .= $tbl;
    $out .= '</div>';
    $out .= '<hr size="2" style="color:#e0c4b0; border-style:dashed" />';
    echo $out;
    return $enable;
}

?>
