<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_user_registration()
{
    global $CFG, $fsCFG;

    print_section_header('ユーザアカウント（管理）に関する設定');

    // 【許可された領域外のコンピュータからは新しいアカウントの作成を行えない機能】 (Shirai092)
    print_subsection_header_fs_switch('FS_ENABLE_SIGNUPINSUBNETONLY');
    echo '　この機能はサブネット内のコンピュータ以外からのユーザによる新規アカウント作成を制限する機能です．';
    newline();
    echo '　本サーバのIPアドレスは'.color_blue($_SERVER["SERVER_ADDR"]).'，';
    echo 'あなたの端末のIPアドレスは'.color_blue(getremoteaddr()).'です．';
    if (isset($CFG->subnet)) {
        newline();
        echo '　config.phpに設定されているサブネットアドレスは'.color_blue($CFG->subnet).'です．';
        if (isset($_SERVER["SERVER_ADDR"])) {
            echo '本サーバはサブネットに';
            if (address_in_subnet($_SERVER["SERVER_ADDR"], $CFG->subnet)) echo color_blue('含まれています').'．';
                else                                                      echo color_red('含まれていません').'．';
            echo 'あなたの端末はサブネットに';
            if (address_in_subnet(getremoteaddr(), $CFG->subnet))         echo color_blue('含まれています').'．';
                else                                                      echo color_red('含まれていません').'．';
        }
    }
    if (!isset($CFG->subnet)) {
        newline();
        newline();
        echo color_red('（注意）').'なお，'.color_red('$CFG->subnetが設定されていません').'ので，';
        echo 'もしこの機能を有効に設定してしまうと，';
        echo '実際にはどの端末からも新規アカウントの作成が'.color_red('不可能です！');
        echo '　意図的に行っているのでなければ，config.phpに$CFG->subnetを追加して下さい．';
        echo 'サブネットはlib/moodlelib.phpのfunction address_in_subnet()を参照して正しく設定して下さい．';
    }
    print_fs_switch_condition('FS_ENABLE_SIGNUPINSUBNETONLY');
    print_subsection_footer();

    // 【ユーザプロファイルフィールドの編集画面においてフィールドの説明を表示可能とする機能】 (Shirai108)
    print_subsection_header_fs_switch('FS_ENABLE_POPUP_USERPROFILEDESCRIPTION');
    echo '　ユーザプロファイルフィールドはサイト管理者によって自由に追加可能なユーザ情報の項目です．';
    echo 'ユーザプロファイルフィールドの追加画面では”フィールドの説明”を入力可能であるにも関わらず，';
    echo 'その情報は一般利用者には公開されません．';
    echo '非標準のフィールドですのでヘルプファイルは存在せず，ユーザは追加されたフィールドにどのような値を入力すれば良いのか分からないでしょう．';
    echo 'この機能を有効にすることで，そのフィールドに何をどのように設定すれば良いのかを説明する手間を省くことができます．';
    newline();
    print_notice_message('注意',
        'ユーザプロファイルフィールドの説明領域を管理者がメモ代わりに使っている場合，'.
        'その内容が一般ユーザに見えてしまいます．'.
        '便利な機能ではありますが，安全のために標準では無効にしてあります．');
    print_fs_switch_condition('FS_ENABLE_POPUP_USERPROFILEDESCRIPTION');
    print_subsection_footer();

    // 【少々不正なEmailアドレス（@の前に複数のピリオドの連続を含む）も許す設定】 (Shirai130)
    print_subsection_header_fs_switch('FS_ENABLE_ALLOWINVALIDEMAILADDRESS');
    echo '　標準のMoodleは正式なEmailアドレスフォーマットに則らないEmailアドレスをユーザ編集画面で登録できません．';
    echo 'ところが国内の携帯電話キャリア各社は'.color_blue('@の前に複数の連続するピリオドを含むようなEmailアドレス');
    echo 'の利用を許しています．';
    echo 'このようなEmailアドレスをユーザプロファイルの編集画面で入力して保存しようとしても，';
    echo color_blue('「不正なメールアドレスです」').'のエラー表示が出力されて受け付けられません．';
    newline();
    echo '　この機能を有効にすると，shirai..tatsuya@moodle.comのようにアットマークの前に連続するピリオドがあってもOKとします．';
    echo '情報リテラシーの観点からはこのようなEmailアドレスを許すべきではないのですが，';
    echo '社会一般で通用してしまっている以上，入力を受け付けないと業務に支障が生じます．';
    print_fs_switch_condition('FS_ENABLE_ALLOWINVALIDEMAILADDRESS');
    print_subsection_footer();

// (Shirai199): ”すべてのユーザに私のメールアドレスを公開する”に設定していない場合，ユーザプロファイル画面で自分自身の電子メールアドレスが表示されない問題の改良(2010/09/25)
    print_subsection_header_fs_switch('FS_DISABLE_DISPLAYMAILADDRESSOWN');
    echo '　標準のMoodleでは，管理者や教師以外のユーザが自分自身のプロファイルフィールドを表示した際に，';
    echo 'もし'.color_blue('メール公開').'の設定が'.color_blue('”すべてのユーザに私のメールアドレスを公開する"').'になっていない場合，';
    echo 'メールアドレスが表示されません．';
    echo '　つまりちょっと自分の登録したメールアドレスを確認したいだけなのに，';
    echo 'プロファイル編集のタブを開かなくてはならない．';
    newline();
    echo '　本機能は自分自身のユーザプロファイルであれば'.color_blue('メール公開').'の設定によらず常にメールアドレスを表示する改良です．';
    echo 'なぜ表示しないのか，あまり積極的な理由が思い付かないのでデフォルトで表示するように設定してあります．';
    print_fs_switch_condition('FS_DISABLE_DISPLAYMAILADDRESSOWN');
    print_subsection_footer();

// (Shirai200): ユーザプロファイル画面のメールアドレスの右横にテストメールを送信するボタンを追加する (2010/09/25)
    print_subsection_header_fs_switch('FS_DISABLE_SENDTESTMAILBUTTON');
    echo '　学生はよく携帯電話のメールアドレスを変更します．';
    echo '新規ユーザ登録の際ならば良いのですが，学生が変更するたびにアドレスの入力が間違っていないかどうかを確認するわけにはいきません．';
    echo '学生が容易に自分の入力したメールアドレスが正しいかどうかをチェックできるように，';
    echo 'ユーザプロファイル画面のメールアドレスの右横に'.color_blue('テストメール送信').'ボタンを追加しました．';
    echo 'このボタンをクリックすれば定型のメッセージが登録したメールアドレス（セカンドメールアドレスが登録されているならばそちらにも）へ送信されます．';
    echo 'このメールが届けば入力したアドレスは正しいことが学生本人だけで確認できます．';
    echo '勿論，メッセージの機能を使って貰っても同じことは可能ですが，かなり敷居が高いでしょう．';
    echo 'また，メールアドレスをクリックすればメーラーが起動しますが，メーラーから送信するのとMoodleから送信するのとでは';
    echo 'メールの送信プロセスが全く異なります．';
    print_fs_switch_condition('FS_DISABLE_SENDTESTMAILBUTTON');
    print_subsection_footer();

    // 【パスワード変更の強制がOnのままのユーザを発見するためのフィルタをユーザリストの表示に追加】 (Shirai132)
    print_subsection_header_fs_switch('FS_DISABLE_FORCEPASSWORDCHANGE_FILTER');
    echo '　ユーザ登録時に仮のパスワードを設定し，後日，ユーザがログインした際にパスワードの変更を強制することが可能です．';
    echo 'ところがなかなかログインしない，中にはそのままログインしないまま卒業してしまう学生もいます．';
    echo 'あまり難しい初期パスワードを設定すると，該当者全員に印刷した仮パスワードを渡す必要がありますし，';
    echo '入力を失敗してログインできない学生が続出するのを恐れ，';
    echo '管理者の中にはユーザの仮パスワードに非常に簡単に推測可能なパスワードを設定する場合があります．';
    echo 'パスワードの変更を行わないユーザを放置すると，そのアカウントが登用される恐れがありますし，';
    echo 'いつまでもログインできずに問題を先送りするルーズな学生の存在は教師にとっても授業運営上の障害となります．';
    newline();
    echo '　このフィルタを追加すると，'.color_blue('サイト管理メニュー').'の'.color_blue('ユーザリスト').'のフィルタに，';
    echo color_blue('パスワード変更の強制').'というフィルタが追加されます．';
    print_fs_switch_condition('FS_DISABLE_FORCEPASSWORDCHANGE_FILTER');
    print_notice_message('注意',
        'この機能はMoodle1.9以降でのみ有効です．');
    print_subsection_footer();

    // 【パスワード忘失時の再発行要求時にアカウント名とメールアドレスの両方を入力しないと受け付けない制限】 (Shirai166)
    print_subsection_header_fs_switch('FS_ENABLE_NEEDBOTHINFO2REQUESTPASSWORD');
    echo '　Moodleには，ユーザがパスワード亡失時に新しいパスワードの再発行を電子メールを用いて行う手続きが用意されています．';
    echo 'ログイン画面において'.color_blue('「はい，ログイン情報を教えてください」').'のボタンを押すことで，ユーザ名とメールアドレスを入力するフォームが表示されます．';
    echo '標準のMoodleではユーザ名かメールアドレスのどちらか一方を入力すると，そのユーザが登録した電子メールアドレスに向けて';
    echo '新しいパスワードを発行するためのURIを含む電子メールが送信されます．';
    newline();
    echo '　本機能を有効にすると，ユーザ名と電子メールアドレスの両方を正しく入力しないとパスワード変更手続きを記載した案内メールは送信されなくなります．';
    echo 'イタズラを抑止できる一方で，メールアドレスも一字一句間違わずに入力しなくてはならないため，';
    echo 'パスワードの再設定を行うためのハードルが高くなってしまいます．';
    print_fs_switch_condition('FS_ENABLE_NEEDBOTHINFO2REQUESTPASSWORD');
    print_subsection_footer();

    // 【サイトに登録されていないユーザであっても認証プラグインでログインが認証された場合にはユーザが自動作成されるのを防ぐ機能】 (Shirai121)
    print_subsection_header_fs_switch('FS_ENABLE_AVOID_AUTOUSERCREATION');
    echo '　Moodleは本サイトに手動ユーザ登録などでユーザ登録されていない（＝詳細なユーザプロファイルが登録されていない）';
    echo 'ユーザが認証プラグイン（POS3やLDAPなど）で認証されてログインした際に，自動的に本サイト上にもユーザ登録を行います．';
    echo 'ログインしたユーザはまずユーザプロファイルの編集画面にジャンプし，詳細情報の上の入力を促されます．';
    echo 'この機構自体は有益なものですが，認証機構のポリシー設定によっては悪影響が生じる場合があります．';
    print_fs_switch_condition('FS_ENABLE_AVOID_AUTOUSERCREATION');
    print_subsection_footer();

    // 【グループのユーザを追加/削除するにおいてユーザ名などでソーティング可能（＋表示）とする改良】 (Shirai178)
    print_subsection_header_fs_switch('FS_DISABLE_GROUPMEMBERSORTBY');
    echo '　この機能を使うには'.color_blue('FS_DISABLE_GROUPMEMBERSORTBY').'と'.color_blue('$fsCFG->groupmembersortby').'を正しく設定する必要があります．';
    newline();
    echo '　グループの”ユーザを追加/削除する”のユーザ一覧は，標準のMoodleでは姓（lastname）によってソーティングされます．';
    echo 'これは日本語圏において，ほとんど意味がありません．';
    echo '本機能を有効にすると，ログイン時のユーザ名，ユーザID，登録された電子メールアドレス，市町村，姓，名によって';
    echo 'ソーティングされると同時に，ユーザのリストにその項目の内容が表示されます．';
    print_fs_switch_condition('FS_DISABLE_GROUPMEMBERSORTBY');
    echo 'どの項目でソーティングするかは以下の'.color_blue('$fsCFG->groupmembersortby').'によって指定します．';
    if (fs_function_enable('FS_DISABLE_GROUPMEMBERSORTBY') and empty($fsCFG->groupmembersortby)) {
        print_notice_message('警告', '$fsCFG->groupmembersortbyが設定されていないため，この機能は無効です．');
    }
    newline();
    newline();
    print_subsubsection_header_fs_cfg('groupmembersortby');
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('groupmembersortby');
    echo '　現在，'.color_blue('$fsCFG->groupmembersortby').'には，';
    if (empty($fsCFG->groupmembersortby)) {
        echo color_red('何も設定されていません（異常）．');
    } else {
        echo color_blue($fsCFG->groupmembersortby).'が設定されていますので，';
        echo 'ユーザプロファイル中の'.color_blue($fsCFG->groupmembersortby).'によってユーザ一覧はソーティングされます．';
        if (!fs_function_enable('FS_DISABLE_GROUPMEMBERSORTBY')) {
            echo 'しかし，'.color_blue('FS_DISABLE_GROUPMEMBERSORTBY').'が有効（この場合は宣言しないこと）ではないので，';
            echo 'ソーティングは標準のMoodle同様に'.color_blue('姓（lastname）').'によって行われます．';
        }
    }
    print_fs_cfg_condition('groupmembersortby');
    print_subsubsection_footer();
    print_subsection_footer();

    print_section_footer();
}

function fsconfig_check_user_login()
{
    global $CFG, $fsCFG;

    print_section_header('ユーザアカウント（ログイン）に関する設定');

    // 【ログイン時のユーザ名自動入力機能を抑制する機能】 (Shirai078)
    print_subsection_header_fs_switch('FS_ENABLE_VOIDLOGINNAME');
    echo '　この機能はセキュリティ向上のために追加した機能です．';
    echo 'Moodleはログイン画面のユーザ名の欄に，自動的に最後にログオフしたユーザのユーザ名を入力します．';
    echo 'この機能は多人数で１台の端末を共有する環境ではユーザ名が漏洩するという点では問題です．';
    echo 'ただ，１ユーザが１端末を用いる環境においては便利な機能のため，デフォルトではこの機能は無効化されています．';
    newline();
    echo '　なお，'.color_blue('Shiboleth認証プラグイン').'を（例え実際には使用していなくても）有効にしている場合は';
    echo 'このMoodle標準のログイン時のユーザ名自動入力機能は強制的に無効化されます．';
    if (get_moodle_cookie() === 'nobody') {
        print_notice_message('注意', 'Cookieにユーザ名が登録されていません（==nobody）．これはログイン時に'.color_blue('$CFG->nolastloggedin').'がtrueに設定されていたためです．したがって，'.color_blue('FS_ENABLE_VOIDLOGINNAME').'の設定に関係なく，ログイン時のユーザ名自動入力機能は働きません．Shiboleth認証プラグインを有効化していませんか？');
    }
    print_fs_switch_condition('FS_ENABLE_VOIDLOGINNAME');
    print_subsection_footer();

    // 【指定されたコースのみゲストでのオートログインを可能とする機能】 (Shirai174)
    print_subsection_header_fs_switch('FS_ENABLE_AUTOLOGINGUESTS');
    echo '　サイト管理ブロックの「ユーザ」－「認証」－「認証の管理」で”ゲストログインボタンを表示”をYesにし，';
    echo 'さらに「ユーザ」－「パーミッション」－「ユーザポリシー」の”ゲストのオートログイン”もYesに設定すると，';
    echo 'ログイン画面を表示することなくゲストの入室を許可されたコース（およびフロントページ）にダイレクトにログインできます．';
    echo 'ゲストのオートログイン”をNoに設定するとそれらのコースに（未ログイン状態で）アクセスした場合，';
    echo 'ログイン画面が表示されます．';
    echo 'ユーザアカウントを持つならば入力し，アカウントを持たないならば「ゲストでログイン」ボタンをクリックする必要があります．';
    newline();
    echo '　この機能を有効にすると，例外的にログイン画面を表示しない／表示するコースを設定できます．';
    echo '特例とするコースの設定は'.color_blue('fsconfig_option.php').'にサイト管理者が手作業で設定を追加する必要があります．';
    print_fs_switch_condition('FS_ENABLE_AUTOLOGINGUESTS');
    echo '　現在，'.color_blue('$CFG->autologin_guests').'は';
    if (!empty($CFG->autologin_guests)) {
        echo color_blue('Yes').'です．';
        echo 'したがって，ゲスト入室可のコースはログイン画面を表示しないで入室できますので，';
        echo 'ゲスト以外のユーザは意識的に画面右上などの「ログイン」をクリックしてログインする必要があります．';
        if (empty($CFG->guestloginbutton)) {
            echo 'ただし，'.color_red('$CFG->guestloginbutton（ゲストログインボタンを表示する）がNo').'なので，';
            echo 'このままではゲスト入室可のコースであってもオートログインは行えません．';
            echo '（つまり，ゲストによる入室をサイト全体で認めない）．';
        }
    } else {
        echo color_blue('No').'です．';
        echo 'したがって，ゲスト入室可のコースに入室する際もログイン画面が表示されますので，';
        echo 'ゲストでログインして貰うには「ゲストとしてログインする」ボタンをクリックして貰う必要があります．';
    }
    newline();
    if (fs_function_enable('FS_ENABLE_AUTOLOGINGUESTS')) {
        newline();
        echo '<a href="'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/guestlogincoursecheck.php" target="_blank">';
        echo '[ゲストログイン可能なコースとfsconfig_option.phpで設定された例外コースの設定一覧を表示 (Link)]';
        echo '</a>';
        newline();
        newline();
        echo '例外コース指定の書式は'.color_blue('fs_add_autologin_guests($courseid = SITEID, $enable = true);').'です．';
        echo '詳しくはドキュメント（Wiki）をご覧下さい．';
        echo 'この設定は複数個，記述が可能です．なお，'.color_blue('$CFG->autologinguests').'の設定によって挙動が異なりますのでご注意下さい．';
    }
    notice_fsconfig2fsconfig_option();
    print_subsection_footer();

    // 【携帯電話でログインする時にユーザ名入力フォームで入力モードを自動的にアルファベットに変更する機能】 (Shirai181)
    print_subsection_header_fs_switch('FS_DISABLE_KEITAIHANKAKUINPUT');
    echo '　携帯電話でログイン画面でユーザ名を入力する際の入力フォームは日本語入力モードです．';
    echo 'パスワード入力欄はFORMのINPUTのTYPEがpasswordなので半角英字モードに切り替わるのに対して不便です．';
    newline();
    echo '　多くのサイトではユーザ名を半角アルファベットと数字としているでしょう．';
    echo 'ログインの際に入力モードを切り替える必要があることに多くの学生はイラつくはずです．';
    echo '本機能を有効にすることでMoodleを携帯電話で使用する際にユーザ名を入力する操作を少しだけ助けます．';
    echo 'なお，'.color_blue('ログイン時のユーザ名自動入力機能を抑制する機能(FS_ENABLE_VOIDLOGINNAME)').'が無効の場合は';
    echo '前回ログイン時のユーザ名が自動的に入力されるので，あまりこの機能は必要ではないでしょう．';

    print_fs_switch_condition('FS_DISABLE_KEITAIHANKAKUINPUT');
    print_notice_message('注意', 'この機能を有効にするとFORMのINPUTに属性としてistyleとmodeの二つを追加します．これは日本国内の携帯電話用ブラウザのための特殊な属性であるため，HTML Validatorなどの正当性をチェックする機能は不正な属性と判断してしまいます．もしサイトのHTMLの正当性をチェックして認証する機能を利用している場合は無効にして下さい．');

    print_subsection_footer();

    print_section_footer();
}

function fsconfig_check_user_othersettings()
{
    global $CFG, $fsCFG;

    print_section_header('ユーザに関するその他の設定');
    print_subsection_header('ユーザ画像の表示範囲に関する設定');
    echo '　標準のMoodleではたとえログインしていない状態でもユーザの顔写真を取得できてしまいます．';
    echo '本機能を有効にすることで顔画像を表示可能とする条件を制限できます．';
    echo 'なお，ここで制限によって表示できない場合はデフォルトの黄色い顔アイコンを表示します．';

    print_subsubsection_header_fs_switch('FS_ENABLE_PRINTUSERPICTURELEVEL');
    echo '　このスイッチを有効にすると顔画像を表示できるユーザの権限に制限を設けることが可能になります．';
    print_fs_switch_condition('FS_ENABLE_PRINTUSERPICTURELEVEL');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('userpict_level');
    echo '　この変数には以下の選択肢があります．';
    newline();
    table_of_select_data('userpict_level');
    echo '　99を指定した場合は全てのユーザ画像を誰に対しても表示しません．つまりユーザ画像を使用しない設定です．';
    newline();
    newline();
    echo '　現在，'.color_blue('$fsCFG->userpict_level').'には';
    if (empty($fsCFG->userpict_level)) {
        echo color_red('何も設定されていません（異常）．');
    } else {
        echo color_blue($fsCFG->userpict_level).'が設定されていますので，';
        echo color_blue(get_fs_cfg_select_description('userpict_level', $fsCFG->userpict_level));
        echo 'です．';
        newline();
        if (!fs_function_enable('FS_ENABLE_PRINTUSERPICTURELEVEL')) {
            echo '　しかし，'.color_blue('FS_ENABLE_PRINTUSERPICTURELEVEL').'が有効ではないので，';
            echo 'ユーザ画像の制限は行いません．';
        }
    }
    print_fs_cfg_condition('userpict_level');
    newline();
    echo '　学生か，学生ではないかを判断するのは，実はあまり簡単ではありません．';
    echo 'Moodleがバージョンアップを重ねる内に，単純なお仕着せのロールからユーザのロールを選択する方式から';
    echo '独自のロールを定義できるように発展していった結果です(Moodle1.8)．';
    newline();
    echo '　古いMoodleには，';
    echo color_blue('<span title="moodle/legacy:admin">admin</span>').'，';
    echo color_blue('<span title="moodle/legacy:coursecreator">coursecreator</span>').'，';
    echo color_blue('<span title="moodle/legacy:editingteacher">editingteacher</span>').'，';
    echo color_blue('<span title="moodle/legacy:teacher">teacher</span>').'，';
    echo color_blue('<span title="moodle/legacy:student">student</span>').'，';
    echo color_blue('<span title="moodle/legacy:guest">guest</span>').'，';
    echo color_blue('<span title="moodle/legacy:user">user</span>');
    echo 'の７種のロールがありました（userはMoodle1.8から）．なお，以下，'.color_blue('レガシーロール').'と呼びます．';
    echo '新しいMoodleでは独自のロールを作成可能ですが，ベースとなるロールをこの７種から選び，';
    echo 'ロールの亜流を派生させる方式です．';
    echo 'この'.color_blue('レガシーロール').'を用いて学生かどうかを判断します．';
    newline();
    echo '　もう一つユーザの種別を単純に判別できない理由があります．';
    echo 'Moodleのロールは各ユーザに単一ではありません．つまりこのユーザはどのコースでも学生なのかと言えば';
    echo'そうではなく，あるコースでは教師であるかも知れません．';
    echo 'Moodleではユーザのロールをいま現在，ユーザが存在する”位置”によって自動的に変更できます．';
    echo color_blue('システムロール').'はユーザがログインした状態で割り当てられるロールです．';
    echo 'もしユーザにシステムロールが割り当てられている場合，以下のロール割り当てがなされていない場合は';
    echo 'システムロールがそのユーザに適用されます．';
    echo 'もしシステムロールが割り当てられていない場合は，サイト管理ブロックの［ユーザ］-［パーミッション］-［ユーザポリシー］の'.color_blue('すべてのユーザのデフォルトロール').'（デフォルト：認証済みユーザ）が適用されます．';
    echo 'システムロールの次に強いロール設定が'.color_blue('コースカテゴリロール').'です．';
    echo 'コースカテゴリを選択した際に画面右上に表示される'.color_blue('ロールの割り当て').'というリンクをクリックすると割り当てが可能になります．';
    echo 'このカテゴリーロールをユーザに割り当てると，そのユーザはそのカテゴリ内の全てのコースにおいて特に明示しなくても，コースカテゴリロールが適用されます．';
    echo 'このロール設定はシステムロールよりも優先度が上です．';
    echo 'さらに各コース内で'.color_blue('管理ブロック').'の'.color_blue('ロールの割り当て').'で指定できる'.color_blue('コースロール').'はカテゴリロールよりも優先度が上です．';
    echo 'そして最後．各モジュールやブロックにもロールを設定できます．';
    newline();
    newline();
    echo '　イメージとして以下のような感じでしょうか．';
    newline();
    echo '　　（システムロール）＜（カテゴリロール）＜（コースロール）＜（コンテンツのロール）';
    newline();
    newline();
    echo '　本機能ではシステムロールによってユーザが学生か否かを判断します．';
    echo 'したがって，システムロールが設定されていない場合はそのユーザの種別を判断できません．';
    echo '本機能を正しく利用するには全ユーザのシステムロールを設定して下さい．';
    echo 'なお，本機能を有効にした場合，ユーザのプロファイルを表示する際に画面下にその学生に割り当てられているレガシーロールの種類を示す表を表示するようになりますので活用下さい．';
    print_notice_message('注意','ユーザの顔写真はブラウザやプロキシサーバがキャッシュしてしまう場合があります．変更が正しく適用できるか確認する際にはブラウザのリロードを行うことを勧めます．ブラウザのリロードだけでは駄目な場合もあります．その場合はブラウザのキャッシュをクリアしたり，一旦ブラウザを閉じるなどの作業を行ってみて下さい．');

    print_subsubsection_footer();



    print_subsection_footer();
    print_section_footer();
}

fsconfig_check_user_registration();
fsconfig_check_user_login();
fsconfig_check_user_othersettings();

?>