/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;

public class CreateAdditionalHolidayEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4667694082936530048L;
    Project project;
    Calendar newCalendar;
    int row;

    public CreateAdditionalHolidayEdit(Project project, Calendar calendar, int row) {
        this.project = project;
        this.newCalendar = (Calendar)calendar.clone();
        this.row = row;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().removeAdditionalHoliday(this.row);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().addAdditionalHoliday(this.newCalendar, this.row);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.newCalendar = null;
    }
}

