/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.controller;

import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.util.Calendar;
import java.util.List;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.data.undo.CreateAdditionalHolidayEdit;
import jp.sourceforge.freegantt.data.undo.CreateMemberEdit;
import jp.sourceforge.freegantt.data.undo.CreateRestrictionEdit;
import jp.sourceforge.freegantt.data.undo.CreateTaskEdit;
import jp.sourceforge.freegantt.data.undo.InsertTaskEdit;
import jp.sourceforge.freegantt.data.undo.RemoveAdditionalHolidayEdit;
import jp.sourceforge.freegantt.data.undo.RemoveMemberEdit;
import jp.sourceforge.freegantt.data.undo.RemoveRestrictioinEdit;
import jp.sourceforge.freegantt.data.undo.RemoveTaskEdit;
import jp.sourceforge.freegantt.data.undo.UpdateAdditionalHolidayEdit;
import jp.sourceforge.freegantt.data.undo.UpdateFixedHolidayEdit;
import jp.sourceforge.freegantt.data.undo.UpdateMemberEdit;
import jp.sourceforge.freegantt.data.undo.UpdateModifiedEdit;
import jp.sourceforge.freegantt.data.undo.UpdatePrintCellSizeEdit;
import jp.sourceforge.freegantt.data.undo.UpdateProjectNameEdit;
import jp.sourceforge.freegantt.data.undo.UpdateProjectSummaryEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskTableWidthEdit;
import jp.sourceforge.freegantt.data.undo.UpdateViewTaskTableColumnsEdit;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class ProjectController {
    Project project;

    public ProjectController(Project project) {
        this.project = project;
    }

    private UndoManager getUndoManager() {
        return this.project.getUndoManager();
    }

    public void setModified(boolean flag) {
        if (this.project.isModified() == flag) {
            return;
        }
        this.project.getUndoManager().addEdit(new UpdateModifiedEdit(this.project, flag));
        this.project.setModified(flag);
        this.project.getProjectModifiedModel().fireProjectModifiedEment();
    }

    public void removeRow(int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            Task targetTask = this.project.getTaskAtRow(row);
            this.removeDestRestrictions(targetTask);
            compound.addEdit(new RemoveTaskEdit(this.project, row));
            if (targetTask != null) {
                this.project.getTasks().remove(targetTask);
            }
        }
        finally {
            compound.end();
            this.project.update();
            this.project.getTaskTableModel().fireTableChanged();
        }
    }

    public void insertTaskAtRow(Task newTask, int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            this.getUndoManager().addEdit(new InsertTaskEdit(this.project, newTask, row));
            this.project.getTasks().add(this.project.getIndexFromRow(row), newTask);
        }
        finally {
            compound.end();
            this.project.update();
            this.project.getTaskTableModel().fireTableChanged();
        }
    }

    public void setTaskAtRow(Task newTask, int row) {
        if (newTask == null) {
            newTask = new Task();
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            this.fillNewTaskAtRow(row);
            int index = this.project.getIndexFromRow(row);
            Task oldTask = this.project.getTaskAtIndex(index);
            for (Task task : this.project.getTasks()) {
                if (!task.getRestrictions().remove(oldTask)) continue;
                task.getRestrictions().add(newTask);
            }
            compound.addEdit(new UpdateTaskEdit(this.project, newTask, row));
            this.project.getTasks().set(index, newTask);
        }
        finally {
            compound.end();
        }
    }

    public Task fillNewTaskAtRow(int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            int index = this.project.getIndexFromRow(row);
            while (this.project.getTasks().size() <= index) {
                Task fillTask = new Task();
                compound.addEdit(new CreateTaskEdit(this.project, fillTask));
                this.project.getTasks().add(fillTask);
            }
        }
        finally {
            compound.end();
        }
        return this.project.getTaskAtRow(row);
    }

    public void addRestriction(Task src, Task dst) {
        CompoundEdit compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new CreateRestrictionEdit(this.project, this.project.getRowByTask(src), this.project.getRowByTask(dst)));
            src.addRestriction(dst);
        }
        finally {
            compound.end();
        }
    }

    public void removeDestRestrictions(Task task) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            for (Task src : this.project.getTasks()) {
                if (!src.getRestrictions().contains(task)) continue;
                compound.addEdit(new RemoveRestrictioinEdit(this.project, this.project.getRowByTask(src), this.project.getRowByTask(task)));
                src.getRestrictions().remove(task);
            }
        }
        finally {
            compound.end();
            this.project.update();
        }
    }

    public void removeSrcRestrictions(Task task) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            for (Task dst : task.getRestrictions()) {
                compound.addEdit(new RemoveRestrictioinEdit(this.project, this.project.getRowByTask(task), this.project.getRowByTask(dst)));
            }
            task.getRestrictions().clear();
        }
        finally {
            compound.end();
            this.project.update();
        }
    }

    public void levelUpTask(Task task) {
        if (task == null) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            int row = this.project.getRowByTask(task);
            int index = this.project.getIndexByTask(task);
            Task newTask = task.clone();
            newTask.setLevel(task.getLevel() + 1);
            compound.addEdit(new UpdateTaskEdit(this.project, newTask, row));
            this.project.getTasks().set(index, newTask);
        }
        finally {
            compound.end();
        }
    }

    public void levelDownTask(Task task) {
        if (task == null) {
            return;
        }
        if (task.getLevel() <= 0) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            int row = this.project.getRowByTask(task);
            int index = this.project.getIndexByTask(task);
            Task newTask = task.clone();
            newTask.setLevel(task.getLevel() - 1);
            compound.addEdit(new UpdateTaskEdit(this.project, newTask, row));
            this.project.getTasks().set(index, newTask);
        }
        finally {
            compound.end();
        }
    }

    public void setPrintCellSize(Dimension newPrintCellSize) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdatePrintCellSizeEdit(this.project, newPrintCellSize));
            this.project.getPrint().setPrintCellSize(newPrintCellSize);
        }
        finally {
            compound.end();
        }
    }

    public void setFixedHoliday(int week, boolean value) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateFixedHolidayEdit(this.project, week, value));
            if (value) {
                this.project.getFixedHolidays().remove(new Integer(week));
                this.project.getFixedHolidays().add(new Integer(week));
            } else {
                this.project.getFixedHolidays().remove(new Integer(week));
            }
        }
        finally {
            compound.end();
            this.project.update();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void addAdditionalHoliday(Calendar calendar, int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new CreateAdditionalHolidayEdit(this.project, calendar, row));
            this.project.getAdditionalHolidays().add(row, calendar);
        }
        finally {
            compound.end();
            this.project.update();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void addAdditionalHoliday(Calendar calendar) {
        this.addAdditionalHoliday(calendar, this.project.getAdditionalHolidays().size());
    }

    public void removeAdditionalHoliday(int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new RemoveAdditionalHolidayEdit(this.project, row));
            this.project.getAdditionalHolidays().remove(row);
        }
        finally {
            compound.end();
            this.project.update();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void removeAdditionalHoliday(Calendar calendar) {
        List<Calendar> holidays = this.project.getAdditionalHolidays();
        int i = 0;
        while (i < holidays.size()) {
            if (CalendarUtil.dateEquals(calendar, holidays.get(i))) {
                this.removeAdditionalHoliday(i);
                return;
            }
            ++i;
        }
    }

    public void setAdditionalHoliday(Calendar calendar, int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateAdditionalHolidayEdit(this.project, calendar, row));
            this.project.getAdditionalHolidays().get(row).setTime(calendar.getTime());
        }
        finally {
            compound.end();
            this.project.update();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void addMember(Member member, int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            compound.addEdit(new CreateMemberEdit(this.project, member, row));
            this.project.getMembers().add(row, member);
        }
        finally {
            compound.end();
            this.project.getMemberTableModel().fireTableChanged();
            this.project.getTaskMemberComboBoxModel().fireListDataListener();
        }
    }

    public void removeMember(int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new RemoveMemberEdit(this.project, row));
            Member oldMember = this.project.getMembers().get(row);
            for (Task task : this.project.getTasks()) {
                if (task.getMember() != oldMember) continue;
                task.setMember(null);
            }
            this.project.getMembers().remove(row);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getMemberTableModel().fireTableChanged();
            this.project.getTaskMemberComboBoxModel().fireListDataListener();
        }
    }

    public void setMember(Member member, int row) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateMemberEdit(this.project, member, row));
            Member oldMember = this.project.getMembers().get(row);
            for (Task task : this.project.getTasks()) {
                if (task.getMember() != oldMember) continue;
                task.setMember(member);
            }
            this.project.getMembers().set(row, member);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getMemberTableModel().fireTableChanged();
            this.project.getTaskMemberComboBoxModel().fireListDataListener();
        }
    }

    public void setName(String text) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateProjectNameEdit(this.project, text));
            this.project.setName(text);
        }
        finally {
            compound.end();
            this.project.getProjectInfoModel().fireProjectInfoChangedEvent();
        }
    }

    public void setSummary(String text) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateProjectSummaryEdit(this.project, text));
            this.project.setSummary(text);
        }
        finally {
            compound.end();
            this.project.getProjectInfoModel().fireProjectInfoChangedEvent();
        }
    }

    public void setPageFormat(Project project, PageFormat pageFormat) {
        project.getPrint().setPageFormat(pageFormat);
        project.setModified(true);
    }

    public void setTaskTableWidth(Project project, int oldDividerLocation, int dividerLocation) {
        if (oldDividerLocation == dividerLocation) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateTaskTableWidthEdit(project, oldDividerLocation, dividerLocation));
            project.getView().setTaskTableWidth(dividerLocation);
        }
        finally {
            compound.end();
            project.getProjectViewModel().fireProjectViewChangedEvent();
        }
    }

    public void setViewTaskTableColumns(Project project, List<Column> oldColumns, List<Column> newColumns) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateViewTaskTableColumnsEdit(project, oldColumns, newColumns));
            project.getView().setColumns(newColumns);
        }
        finally {
            compound.end();
            project.getProjectViewModel().fireProjectViewChangedEvent();
        }
    }
}

