/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.HeaderChangedListener;
import jp.sourceforge.freegantt.swing.TaskLineDataPane;
import jp.sourceforge.freegantt.swing.TaskListTableModel;
import jp.sourceforge.freegantt.swing.TaskMemberCellEditor;
import jp.sourceforge.freegantt.swing.TaskMemberCellRenderer;
import jp.sourceforge.freegantt.swing.TaskNameCellRenderer;

public class TaskListTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = -2059641956588584594L;
    Application app;
    Project project;
    TaskListTableModel tableModel;
    TaskNameCellRenderer taskNameCellRenderer;
    List<HeaderChangedListener> headerChangedListeners = new ArrayList<HeaderChangedListener>();
    boolean initialized = false;
    Color borderColor = new Color(192, 192, 192);

    public TaskListTableModel getTaskListTableModel() {
        return this.tableModel;
    }

    public void addHeaderChangedListener(HeaderChangedListener l) {
        this.headerChangedListeners.add(l);
    }

    public void removeHeaderChangedListener(HeaderChangedListener l) {
        this.headerChangedListeners.remove(l);
    }

    public void fireHeaderChangedEvent() {
        for (HeaderChangedListener listener : this.headerChangedListeners) {
            listener.headerChanged(new HeaderChangedListener.HeaderChangedEvent(this));
        }
    }

    public TaskListTable(Application app) {
        this.app = app;
        this.project = app.getProject();
        this.setGridColor(this.borderColor);
        this.setAutoResizeMode(4);
        this.addMouseListener(this);
        this.getTableHeader().addMouseListener(new HeaderMouseListener());
        this.tableModel = this.project.getTaskTableModel();
        this.setModel(this.tableModel);
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.addColumnModelListener(new ColumnModelChangedListener());
        String[] columnKeys = this.tableModel.getColumnKeys();
        int i = 0;
        while (i < columnKeys.length) {
            TableColumn column = columnModel.getColumn(i);
            column.setIdentifier(columnKeys[i]);
            column.setMinWidth(0);
            column.addPropertyChangeListener(new ColumnSizeChangeListener());
            ++i;
        }
        this.updateColumnArrangement();
        columnModel.getColumn(2).setCellRenderer(new TaskMemberCellRenderer());
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(new TaskMemberCellEditor(this.project)));
        this.taskNameCellRenderer = new TaskNameCellRenderer(this.project);
        columnModel.getColumn(0).setCellRenderer(this.getTableHeader().getDefaultRenderer());
        columnModel.getColumn(0).setMaxWidth(30);
        columnModel.getColumn(0).setMinWidth(30);
        columnModel.getColumn(1).setCellRenderer(this.taskNameCellRenderer);
        this.initialized = true;
    }

    private void updateColumnArrangement() {
        List<Column> columns = this.project.getView().getColumns();
        int index = 1;
        for (Column column : columns) {
            this.getColumnModel().moveColumn(this.getColumnModel().getColumnIndex(column.getKey()), index);
            TableColumn tableColumn = this.getColumn(column.getKey());
            tableColumn.setPreferredWidth(column.getWidth());
            tableColumn.setWidth(column.getWidth());
            ++index;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.app == null) {
            return;
        }
        TaskLineDataPane taskLineDataPane = this.app.getTaskLineDataPane();
        if (taskLineDataPane != null) {
            taskLineDataPane.setSize(new Dimension(taskLineDataPane.getWidth(), this.getTaskListTableModel().getRowCount() * 16));
            taskLineDataPane.setPreferredSize(new Dimension(taskLineDataPane.getWidth(), this.getTaskListTableModel().getRowCount() * 16));
            System.out.println("DataPane setPreferredSize: " + taskLineDataPane.getWidth() + "," + this.getTaskListTableModel().getRowCount() * 16);
        }
        if (this.app.getTaskListRootPane() != null) {
            this.app.getTaskListRootPane().getViewport().validate();
        }
        if (this.app.getTaskLineDataPane() != null) {
            this.app.getTaskLineDataPane().repaint();
        }
        if (this.app.getTaskListPane() != null) {
            this.app.getTaskListPane().repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
            return;
        }
        if (this.handleFoldOperation(e)) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
            return;
        }
    }

    private void triggerPopup(MouseEvent e) {
        Task task;
        int[] selectedRows;
        int row = this.rowAtPoint(e.getPoint());
        if (row < 0) {
            return;
        }
        boolean found = false;
        int[] nArray = selectedRows = this.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (s == row) {
                found = true;
            }
            ++n2;
        }
        if (!found) {
            this.setRowSelectionInterval(row, row);
            this.repaint();
        }
        boolean isAvailableLevelUp = (task = this.project.findTaskByRow(row)) != null;
        boolean isAvailableLevelDown = task != null && task.getLevel() > 0;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Resource.get("listRemoveTask"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                int deleted = 0;
                int[] nArray = selectedRows = TaskListTable.this.getSelectedRows();
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    TaskListTable.this.project.removeRow(s - deleted);
                    ++deleted;
                    ++n2;
                }
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("listInsertTask"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                int inserted = 0;
                int chained = 0;
                int preSelected = -2;
                int[] nArray = selectedRows = TaskListTable.this.getSelectedRows();
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    chained = preSelected + 1 == s ? ++chained : 0;
                    TaskListTable.this.project.insertRow(s + inserted - chained);
                    ++inserted;
                    preSelected = s;
                    ++n2;
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("listLevelUp"));
        item.setEnabled(isAvailableLevelUp);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                task.setLevel(task.getLevel() + 1);
                TaskListTable.this.project.update();
                TaskListTable.this.tableModel.fireTableChanged();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("listLevelDown"));
        item.setEnabled(isAvailableLevelDown);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                task.setLevel(task.getLevel() - 1);
                TaskListTable.this.project.update();
                TaskListTable.this.tableModel.fireTableChanged();
            }
        });
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void doLayout() {
        JTableHeader header = this.getTableHeader();
        TableColumn resizingColumn = header.getResizingColumn();
        if (resizingColumn != null) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        TableColumnModel model = this.getColumnModel();
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn column = model.getColumn(i);
            column.setWidth(column.getPreferredWidth());
            ++i;
        }
    }

    private boolean handleFoldOperation(MouseEvent e) {
        TableColumnModel columnModel = this.getColumnModel();
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        int columnIndex = columnModel.getColumnIndexAtX(e.getX());
        Object columnKey = columnModel.getColumn(columnIndex).getIdentifier();
        if (!columnKey.equals("name")) {
            return false;
        }
        Rectangle cellRect = this.getCellRect(row, column, false);
        Point cellPoint = new Point(e.getX() - cellRect.x, e.getY() - cellRect.y);
        this.taskNameCellRenderer.getTableCellRendererComponent(this, "", true, true, row, column);
        Border border = this.taskNameCellRenderer.getBorder();
        if (!(border instanceof TaskNameCellRenderer.FoldBorder)) {
            return false;
        }
        Rectangle foldRect = ((TaskNameCellRenderer.FoldBorder)border).getFoldRect();
        if (foldRect == null) {
            return false;
        }
        if (!foldRect.contains(cellPoint)) {
            return false;
        }
        this.project.toggleTaskFold(row);
        this.project.getTaskTableModel().fireTableChanged();
        return true;
    }

    class ColumnModelChangedListener
    implements TableColumnModelListener {
        ColumnModelChangedListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (!TaskListTable.this.initialized) {
                return;
            }
            this.updateProjectView();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        protected void updateProjectView() {
            ArrayList<Column> columns = new ArrayList<Column>();
            int i = 1;
            while (i < TaskListTable.this.getColumnModel().getColumnCount()) {
                TableColumn column = TaskListTable.this.getColumnModel().getColumn(i);
                String key = (String)column.getIdentifier();
                columns.add(new Column(key, column.getWidth()));
                ++i;
            }
            TaskListTable.this.project.getView().setColumns(columns);
        }
    }

    class ColumnNameActionListener
    implements ActionListener {
        int index;

        public ColumnNameActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = TaskListTable.this.tableModel.getColumnKey(this.index);
            Column column = TaskListTable.this.project.getView().getColumn(key);
            if (column == null) {
                return;
            }
            column.setWidth(column.getWidth() == 0 ? TaskListTable.this.project.getView().getDefaultColumn(key).getWidth() : 0);
            TaskListTable.this.updateColumnArrangement();
            TaskListTable.this.fireHeaderChangedEvent();
        }
    }

    class ColumnSizeChangeListener
    implements PropertyChangeListener {
        ColumnSizeChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!e.getPropertyName().equals("width")) {
                return;
            }
            if (!TaskListTable.this.initialized) {
                return;
            }
            TableColumn column = (TableColumn)e.getSource();
            TaskListTable.this.project.getView().getColumn((String)column.getIdentifier()).setWidth((Integer)e.getNewValue());
            TaskListTable.this.fireHeaderChangedEvent();
        }
    }

    class HeaderMouseListener
    implements MouseListener {
        HeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
            }
        }

        public void triggerPopup(MouseEvent e) {
            JPopupMenu menu = new JPopupMenu();
            String[] columnNames = TaskListTable.this.getTaskListTableModel().getColumnNames();
            int index = 0;
            while (index < columnNames.length) {
                if (index != 0) {
                    JMenuItem item = new JMenuItem(columnNames[index]);
                    item.addActionListener(new ColumnNameActionListener(index));
                    menu.add(item);
                }
                ++index;
            }
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

