/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.PreviewDialog;

public class IconMenuPane
extends JPanel {
    private static final long serialVersionUID = -4041049775879993378L;
    Application app;

    public IconMenuPane(final Application app) {
        this.app = app;
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(2);
        layout.setHgap(2);
        this.setLayout(layout);
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 28));
        this.add(this.createButton(Resource.get("menuFileNew"), "menuFileNew.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.newFile();
            }
        }));
        this.add(this.createButton(Resource.get("menuFileOpen"), "menuFileOpen.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.loadData();
            }
        }));
        this.add(this.createButton(Resource.get("menuFileSave"), "menuFileSave.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.saveData();
            }
        }));
        this.add(this.createButton(Resource.get("menuFileSaveAs"), "menuFileSaveAs.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.saveAsData();
            }
        }));
        this.add(new Sepalator());
        this.add(this.createButton(Resource.get("menuFilePreview"), "menuFilePreview.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog dialog = new PreviewDialog(app);
                dialog.setVisible(true);
            }
        }));
        this.add(this.createButton(Resource.get("menuFilePage"), "menuFilePage.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.configurePage();
            }
        }));
        this.add(this.createButton(Resource.get("menuFilePrint"), "menuFilePrint.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.print();
            }
        }));
        this.add(new Sepalator());
        this.add(this.createButton(Resource.get("menuViewCalendarMode"), "menuViewCalendarMode.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.changeCalendarMode();
            }
        }));
        this.add(this.createButton(Resource.get("menuViewPage"), "menuViewPage.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.getTaskLineDataPane().setPrintRangeMode(!app.getTaskLineDataPane().isPrintRangeMode());
                app.getTaskLineDataPane().repaint();
            }
        }));
        this.add(new Sepalator());
        this.add(this.createButton(Resource.get("menuWindowInfo"), "menuWindowInfo.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(0);
            }
        }));
        this.add(this.createButton(Resource.get("menuWindowResource"), "menuWindowResource.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(1);
            }
        }));
        this.add(this.createButton(Resource.get("menuWindowHoliday"), "menuWindowHoliday.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(2);
            }
        }));
    }

    public JButton createButton(String tooltip, String filename, ActionListener listener) {
        JButton button = new JButton();
        button.setUI(new BasicButtonUI());
        button.setBorder(new MenuItemBorder());
        button.setIcon(new ImageIcon(this.getClass().getResource(filename)));
        button.addActionListener(listener);
        button.setPreferredSize(new Dimension(24, 24));
        button.setToolTipText(tooltip);
        return button;
    }

    class MenuItemBorder
    extends MetalBorders.ButtonBorder {
        private static final long serialVersionUID = 8189671028968570980L;

        MenuItemBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ButtonModel model = ((AbstractButton)c).getModel();
            g.translate(x, y);
            if (model.isEnabled()) {
                boolean pressed = model.isPressed();
                if (pressed) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.fillRect(0, 0, w, 2);
                    g.fillRect(0, 2, 2, h - 2);
                    g.fillRect(w - 1, 1, 1, h - 1);
                    g.fillRect(1, h - 1, w - 2, 1);
                } else if (model.isRollover()) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 3;
            newInsets.left = 3;
            newInsets.bottom = 3;
            newInsets.right = 3;
            return newInsets;
        }
    }

    class Sepalator
    extends JPanel {
        private static final long serialVersionUID = 5819409774260437397L;

        public Sepalator() {
            this.setPreferredSize(new Dimension(9, 24));
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.gray);
            g.drawLine(4, 1, 4, this.getHeight() - 2);
        }
    }
}

