/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.PreviewDialog;

public class ApplicationMenu
extends JMenuBar {
    private static final long serialVersionUID = -8682706642684252609L;
    Application app;

    public ApplicationMenu(final Application app) {
        this.app = app;
        Font font = this.getFont();
        Font newFont = new Font(font.getName(), 0, font.getSize());
        UIManager.put("Menu.font", newFont);
        UIManager.put("MenuItem.font", newFont);
        UIManager.put("MenuItem.acceleratorFont", newFont);
        UIManager.put("MenuItem.acceleratorForeground", Color.gray);
        JMenu menu = new JMenu(Resource.get("menuFile"));
        JMenuItem item = new JMenuItem(Resource.get("menuFileNew"));
        item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.newFile();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileOpen"));
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.loadData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSave"));
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.saveData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSaveAs"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.saveAsData();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("menuFilePreview"));
        item.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog dialog = new PreviewDialog(app);
                dialog.setVisible(true);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFilePage"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.configurePage();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFilePrint"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.print();
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuView"));
        item = new JMenuItem(Resource.get("menuViewCalendarMode"));
        item.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.changeCalendarMode();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("menuViewPage"));
        item.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.getTaskLineDataPane().setPrintRangeMode(!app.getTaskLineDataPane().isPrintRangeMode());
                app.getTaskLineDataPane().repaint();
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuWindow"));
        item = new JMenuItem(Resource.get("menuWindowInfo"));
        item.setAccelerator(KeyStroke.getKeyStroke(73, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(0);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuWindowResource"));
        item.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(1);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuWindowHoliday"));
        item.setAccelerator(KeyStroke.getKeyStroke(72, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(2);
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuLang"));
        item = new JMenuItem(Resource.get("menuLangEn"));
        item.setEnabled(!app.getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.updateLocale(Locale.ENGLISH);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuLangJp"));
        item.setEnabled(!app.getLocale().getLanguage().equals(Locale.JAPANESE.getLanguage()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.updateLocale(Locale.JAPANESE);
            }
        });
        menu.add(item);
        this.add(menu);
    }
}

