/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class CalendarUtil {
    private static Pattern DATE_PATTERN = Pattern.compile("([1-2][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})");
    private static Pattern DATE_PATTERN_NUMERIC = Pattern.compile("([1-2][0-9]{3})([0-9]{2})([0-9]{2})");

    public static Calendar toDateCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return CalendarUtil.toDateCalendar(cal);
    }

    public static Calendar toDateCalendar(Calendar cal) {
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar get(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        return CalendarUtil.toDateCalendar(cal);
    }

    public static Calendar parseDate(String str, Locale locale) {
        if (locale.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd", locale);
                Date date = format.parse(str);
                return CalendarUtil.toDateCalendar(date.getTime());
            }
            catch (ParseException format) {
                try {
                    SimpleDateFormat format2 = new SimpleDateFormat("yyyyMMdd", locale);
                    Date date = format2.parse(str);
                    return CalendarUtil.toDateCalendar(date.getTime());
                }
                catch (ParseException format2) {}
            }
        } else {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy", locale);
                Date date = format.parse(str);
                return CalendarUtil.toDateCalendar(date.getTime());
            }
            catch (ParseException format) {
                try {
                    SimpleDateFormat format3 = new SimpleDateFormat("ddMMyyyy", locale);
                    Date date = format3.parse(str);
                    return CalendarUtil.toDateCalendar(date.getTime());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static int subDate(Calendar lhs, Calendar rhs) {
        if (lhs == null || rhs == null) {
            return 0;
        }
        return (int)((lhs.getTimeInMillis() - rhs.getTimeInMillis()) / 86400000L);
    }
}

